/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.calendar;

import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.ui.DatePickerUI;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DatePicker
extends CalendarPane {
    public static final String PROPERTY_NAME_DATE_FORMAT = "dateFormat";
    public static final String PROPERTY_NAME_FIELD_EDITABLE = "fieldEditable";
    public static final String PROPERTY_NAME_KEEP_TIME = "keepTime";
    public static final String PROPERTY_NAME_PICKER_STYLE = "pickerStyle";
    public static final String PROPERTY_NAME_DROPDOWN_FOCUSABLE = "dropdownFocusable";
    public static final int PICKER_STYLE_FIELD_AND_BUTTON = 272;
    public static final int PICKER_STYLE_BUTTON = 288;
    private static final String uiClassID = "microba.DatePickerUI";
    private DateFormat dateFormat;
    private boolean fieldEditable;
    private boolean keepTime;
    private int pickerStyle;
    private boolean dropdownFocusable;

    public DatePicker() {
        this(new Date(), 2, Locale.getDefault(), TimeZone.getDefault());
    }

    public DatePicker(Date initialDate) {
        this(initialDate, 2, Locale.getDefault(), TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, int dateStyle) {
        this(initialDate, dateStyle, Locale.getDefault(), TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, DateFormat dateFormat) {
        this(initialDate, dateFormat, Locale.getDefault(), TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, int dateStyle, Locale locale) {
        this(initialDate, dateStyle, locale, TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, DateFormat dateFormat, Locale locale) {
        this(initialDate, dateFormat, locale, TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, int dateStyle, Locale locale, TimeZone zone) {
        super(initialDate, 32, locale, zone);
        this.checkDateStyle(dateStyle);
        this.dateFormat = this.dateFormatFromStyle(dateStyle);
        this.fieldEditable = true;
        this.keepTime = true;
        this.pickerStyle = 272;
        this.setStripTime(false);
        this.dropdownFocusable = true;
        this.updateUI();
    }

    public DatePicker(Date initialDate, DateFormat dateFormat, Locale locale, TimeZone zone) {
        super(initialDate, 32, locale, zone);
        this.checkDateFormat(dateFormat);
        this.dateFormat = dateFormat;
        this.fieldEditable = true;
        this.keepTime = true;
        this.pickerStyle = 272;
        this.setStripTime(false);
        this.dropdownFocusable = true;
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.checkDateFormat(dateFormat);
        DateFormat oldValue = this.dateFormat;
        this.dateFormat = dateFormat;
        this.firePropertyChange(PROPERTY_NAME_DATE_FORMAT, oldValue, dateFormat);
    }

    public boolean isFieldEditable() {
        return this.fieldEditable;
    }

    public void setFieldEditable(boolean fieldEditable) {
        boolean old = this.fieldEditable;
        this.fieldEditable = fieldEditable;
        this.firePropertyChange(PROPERTY_NAME_FIELD_EDITABLE, old, fieldEditable);
    }

    public boolean isDropdownFocusable() {
        return this.dropdownFocusable;
    }

    public void setDropdownFocusable(boolean popupFocusable) {
        boolean old = this.dropdownFocusable;
        this.dropdownFocusable = popupFocusable;
        this.firePropertyChange(PROPERTY_NAME_DROPDOWN_FOCUSABLE, old, popupFocusable);
    }

    public boolean isKeepTime() {
        return this.keepTime;
    }

    public void setKeepTime(boolean keepTime) {
        boolean old = this.keepTime;
        this.keepTime = keepTime;
        this.firePropertyChange(PROPERTY_NAME_KEEP_TIME, old, keepTime);
    }

    public int getPickerStyle() {
        return this.pickerStyle;
    }

    public void setPickerStyle(int pickerStyle) {
        pickerStyle = this.checkPickerStyle(pickerStyle);
        int oldValue = this.pickerStyle;
        this.pickerStyle = pickerStyle;
        this.firePropertyChange(PROPERTY_NAME_PICKER_STYLE, oldValue, pickerStyle);
    }

    public void showButtonOnly(boolean buttonOnly) {
        if (buttonOnly) {
            this.setPickerStyle(288);
        } else {
            this.setPickerStyle(272);
        }
    }

    public void showPopup() {
        ((DatePickerUI)this.getUI()).showPopup(true);
    }

    public void hidePopup() {
        ((DatePickerUI)this.getUI()).showPopup(false);
    }

    @Override
    public boolean commitEdit() {
        try {
            ((DatePickerUI)this.getUI()).commit();
            this.fireCommitEvent(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void revertEdit() {
        ((DatePickerUI)this.getUI()).revert();
        this.fireCommitEvent(false);
    }

    private void checkDateStyle(int style) {
        if (style != 3 && style != 2 && style != 1) {
            throw new IllegalArgumentException("dateStyle: unrecognized style");
        }
    }

    private int checkPickerStyle(int style) {
        if (style == 0) {
            style = 272;
        }
        if (style != 272 && style != 288) {
            throw new IllegalArgumentException("pickerStyle: unrecognized style");
        }
        return style;
    }

    private void checkDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("dateFormat: null value");
        }
    }

    private DateFormat dateFormatFromStyle(int dateStyle) {
        DateFormat df = DateFormat.getDateInstance(dateStyle, this.getLocale());
        df.setTimeZone(this.getZone());
        return df;
    }
}

