/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.unix.CLibraryNative;
import com.pty4j.unix.FDSet;
import com.pty4j.unix.Pollfd;
import com.pty4j.unix.PollfdStructure;
import com.pty4j.unix.PollfdStructureByReference;
import com.pty4j.unix.fd_set;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0007J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u0005H\u0007J#\u0010\u001e\u001a\u00020\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/pty4j/unix/CLibrary;", "", "<init>", "()V", "O_WRONLY", "", "O_RDWR", "POLLIN", "", "EINTR", "EAGAIN", "O_NOCTTY", "ENOTTY", "libc", "Lcom/pty4j/unix/CLibraryNative;", "open", "path", "", "flags", "close", "fd", "read", "buf", "", "len", "write", "pipe", "fds", "", "errno", "poll", "", "Lcom/pty4j/unix/Pollfd;", "timeout", "([Lcom/pty4j/unix/Pollfd;I)I", "select", "nfds", "readfds", "Lcom/pty4j/unix/FDSet;", "pty4j"})
public final class CLibrary {
    @NotNull
    public static final CLibrary INSTANCE = new CLibrary();
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final short POLLIN = 1;
    public static final int EINTR = 4;
    @JvmField
    public static final int EAGAIN = Platform.isLinux() || Platform.isSolaris() ? 11 : 35;
    @JvmField
    public static final int O_NOCTTY = Platform.isLinux() ? 256 : (Platform.isFreeBSD() ? 32768 : (Platform.isSolaris() ? 2048 : 131072));
    public static final int ENOTTY = 25;
    @NotNull
    private static final CLibraryNative libc;

    private CLibrary() {
    }

    @JvmStatic
    public static final int open(@NotNull String path, int flags) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return libc.open(path, flags);
    }

    @JvmStatic
    public static final int close(int fd) {
        return libc.close(fd);
    }

    @JvmStatic
    public static final int read(int fd, @NotNull byte[] buf, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        LibCAPI.ssize_t result = libc.read(fd, buf, new LibCAPI.size_t((long)len));
        return result.intValue();
    }

    @JvmStatic
    public static final int write(int fd, @NotNull byte[] buf, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        LibCAPI.ssize_t result = libc.write(fd, buf, new LibCAPI.size_t((long)len));
        return result.intValue();
    }

    @JvmStatic
    public static final int pipe(@NotNull int[] fds) {
        Intrinsics.checkNotNullParameter((Object)fds, (String)"fds");
        return libc.pipe(fds);
    }

    @JvmStatic
    public static final int errno() {
        return Native.getLastError();
    }

    @JvmStatic
    public static final int poll(@NotNull Pollfd[] fds, int timeout) {
        Intrinsics.checkNotNullParameter((Object)fds, (String)"fds");
        PollfdStructureByReference pollfdsReference = new PollfdStructureByReference();
        Structure[] structureArray = pollfdsReference.toArray(fds.length);
        Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.pty4j.unix.PollfdStructure>");
        PollfdStructure[] pollfdStructures = (PollfdStructure[])structureArray;
        int n = fds.length;
        for (int i = 0; i < n; ++i) {
            pollfdStructures[i].fd = fds[i].getFd();
            pollfdStructures[i].events = fds[i].getEvents();
        }
        int ret = libc.poll(pollfdsReference, fds.length, timeout);
        int n2 = fds.length;
        for (int i = 0; i < n2; ++i) {
            fds[i].setRevents(pollfdStructures[i].revents);
        }
        return ret;
    }

    @JvmStatic
    public static final int select(int nfds, @NotNull FDSet readfds) {
        Intrinsics.checkNotNullParameter((Object)readfds, (String)"readfds");
        return libc.select(nfds, (fd_set)readfds, null, null, null);
    }

    static {
        Library library = Native.load((String)Platform.C_LIBRARY_NAME, CLibraryNative.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        libc = (CLibraryNative)library;
    }
}

