// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct NotificationConfiguration {
    /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    pub topic_configurations: ::std::option::Option<::std::vec::Vec<crate::types::TopicConfiguration>>,
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    pub queue_configurations: ::std::option::Option<::std::vec::Vec<crate::types::QueueConfiguration>>,
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    pub lambda_function_configurations: ::std::option::Option<::std::vec::Vec<crate::types::LambdaFunctionConfiguration>>,
    /// <p>Enables delivery of events to Amazon EventBridge.</p>
    pub event_bridge_configuration: ::std::option::Option<crate::types::EventBridgeConfiguration>,
}
impl NotificationConfiguration {
    /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.topic_configurations.is_none()`.
    pub fn topic_configurations(&self) -> &[crate::types::TopicConfiguration] {
        self.topic_configurations.as_deref().unwrap_or_default()
    }
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.queue_configurations.is_none()`.
    pub fn queue_configurations(&self) -> &[crate::types::QueueConfiguration] {
        self.queue_configurations.as_deref().unwrap_or_default()
    }
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.lambda_function_configurations.is_none()`.
    pub fn lambda_function_configurations(&self) -> &[crate::types::LambdaFunctionConfiguration] {
        self.lambda_function_configurations.as_deref().unwrap_or_default()
    }
    /// <p>Enables delivery of events to Amazon EventBridge.</p>
    pub fn event_bridge_configuration(&self) -> ::std::option::Option<&crate::types::EventBridgeConfiguration> {
        self.event_bridge_configuration.as_ref()
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::types::NotificationConfiguration).
    pub fn builder() -> crate::types::builders::NotificationConfigurationBuilder {
        crate::types::builders::NotificationConfigurationBuilder::default()
    }
}

/// A builder for [`NotificationConfiguration`](crate::types::NotificationConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct NotificationConfigurationBuilder {
    pub(crate) topic_configurations: ::std::option::Option<::std::vec::Vec<crate::types::TopicConfiguration>>,
    pub(crate) queue_configurations: ::std::option::Option<::std::vec::Vec<crate::types::QueueConfiguration>>,
    pub(crate) lambda_function_configurations: ::std::option::Option<::std::vec::Vec<crate::types::LambdaFunctionConfiguration>>,
    pub(crate) event_bridge_configuration: ::std::option::Option<crate::types::EventBridgeConfiguration>,
}
impl NotificationConfigurationBuilder {
    /// Appends an item to `topic_configurations`.
    ///
    /// To override the contents of this collection use [`set_topic_configurations`](Self::set_topic_configurations).
    ///
    /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    pub fn topic_configurations(mut self, input: crate::types::TopicConfiguration) -> Self {
        let mut v = self.topic_configurations.unwrap_or_default();
        v.push(input);
        self.topic_configurations = ::std::option::Option::Some(v);
        self
    }
    /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    pub fn set_topic_configurations(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::TopicConfiguration>>) -> Self {
        self.topic_configurations = input;
        self
    }
    /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    pub fn get_topic_configurations(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::TopicConfiguration>> {
        &self.topic_configurations
    }
    /// Appends an item to `queue_configurations`.
    ///
    /// To override the contents of this collection use [`set_queue_configurations`](Self::set_queue_configurations).
    ///
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    pub fn queue_configurations(mut self, input: crate::types::QueueConfiguration) -> Self {
        let mut v = self.queue_configurations.unwrap_or_default();
        v.push(input);
        self.queue_configurations = ::std::option::Option::Some(v);
        self
    }
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    pub fn set_queue_configurations(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::QueueConfiguration>>) -> Self {
        self.queue_configurations = input;
        self
    }
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    pub fn get_queue_configurations(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::QueueConfiguration>> {
        &self.queue_configurations
    }
    /// Appends an item to `lambda_function_configurations`.
    ///
    /// To override the contents of this collection use [`set_lambda_function_configurations`](Self::set_lambda_function_configurations).
    ///
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    pub fn lambda_function_configurations(mut self, input: crate::types::LambdaFunctionConfiguration) -> Self {
        let mut v = self.lambda_function_configurations.unwrap_or_default();
        v.push(input);
        self.lambda_function_configurations = ::std::option::Option::Some(v);
        self
    }
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    pub fn set_lambda_function_configurations(
        mut self,
        input: ::std::option::Option<::std::vec::Vec<crate::types::LambdaFunctionConfiguration>>,
    ) -> Self {
        self.lambda_function_configurations = input;
        self
    }
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    pub fn get_lambda_function_configurations(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::LambdaFunctionConfiguration>> {
        &self.lambda_function_configurations
    }
    /// <p>Enables delivery of events to Amazon EventBridge.</p>
    pub fn event_bridge_configuration(mut self, input: crate::types::EventBridgeConfiguration) -> Self {
        self.event_bridge_configuration = ::std::option::Option::Some(input);
        self
    }
    /// <p>Enables delivery of events to Amazon EventBridge.</p>
    pub fn set_event_bridge_configuration(mut self, input: ::std::option::Option<crate::types::EventBridgeConfiguration>) -> Self {
        self.event_bridge_configuration = input;
        self
    }
    /// <p>Enables delivery of events to Amazon EventBridge.</p>
    pub fn get_event_bridge_configuration(&self) -> &::std::option::Option<crate::types::EventBridgeConfiguration> {
        &self.event_bridge_configuration
    }
    /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::types::NotificationConfiguration).
    pub fn build(self) -> crate::types::NotificationConfiguration {
        crate::types::NotificationConfiguration {
            topic_configurations: self.topic_configurations,
            queue_configurations: self.queue_configurations,
            lambda_function_configurations: self.lambda_function_configurations,
            event_bridge_configuration: self.event_bridge_configuration,
        }
    }
}
