/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.utils.HelpUtils;

public class ConnectionPageInternalParameters
extends ConnectionWizardPage {
    private final DataSourceDescriptor dataSourceDescriptor;

    ConnectionPageInternalParameters(@NotNull DataSourceDescriptor dataSourceDescriptor) {
        super(ConnectionPageInternalParameters.class.getSimpleName());
        this.dataSourceDescriptor = dataSourceDescriptor;
        this.setTitle(CoreMessages.dialog_connection_internal_parameters_title);
        this.setDescription(CoreMessages.dialog_connection_internal_parameters_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite host = new Composite(parent, 0);
        host.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.createParametersGroup(host);
        this.createCustomPropertiesGroup(host);
        UIUtils.createInfoLink((Composite)host, (String)CoreMessages.dialog_connection_internal_parameters_tip, () -> {
            boolean bl = ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Admin-Manage-Preferences"));
        }, (int)0, (int)1, (int)300);
        this.setControl((Control)host);
    }

    private void createParametersGroup(@NotNull Composite parent) {
        Composite group = UIUtils.createTitledComposite((Composite)parent, (String)CoreMessages.dialog_connection_internal_parameters_parameters, (int)4, (int)768);
        Text projectIdText = UIUtils.createLabelText((Composite)group, (String)CoreMessages.dialog_connection_internal_parameters_parameters_project_id, (String)this.dataSourceDescriptor.getProject().getId());
        projectIdText.setEditable(false);
        ((GridData)projectIdText.getLayoutData()).horizontalSpan = 3;
        Text connectionIdText = UIUtils.createLabelText((Composite)group, (String)CoreMessages.dialog_connection_internal_parameters_parameters_connection_id, (String)this.dataSourceDescriptor.getId());
        connectionIdText.setEditable(false);
        ((GridData)connectionIdText.getLayoutData()).horizontalSpan = 3;
        DBPDriver driver = this.dataSourceDescriptor.getDriver();
        Text driverIdText = UIUtils.createLabelText((Composite)group, (String)CoreMessages.dialog_connection_internal_parameters_parameters_driver_id, (String)driver.getId());
        driverIdText.setEditable(false);
        Text driverProviderIdText = UIUtils.createLabelText((Composite)group, (String)CoreMessages.dialog_connection_internal_parameters_parameters_driver_provider_id, (String)driver.getProviderId());
        driverProviderIdText.setEditable(false);
    }

    private void createCustomPropertiesGroup(@NotNull Composite parent) {
        Composite group = UIUtils.createTitledComposite((Composite)parent, (String)CoreMessages.dialog_connection_internal_parameters_custom, (int)1, (int)1808);
        TableViewer viewer = new TableViewer(group, 68356);
        viewer.getTable().setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 100).applyTo(viewer.getControl());
        TableViewerColumn keyColumn = new TableViewerColumn(viewer, 0);
        keyColumn.getColumn().setText(CoreMessages.dialog_connection_internal_parameters_custom_key);
        keyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        final DataSourcePreferenceStore preferences = this.dataSourceDescriptor.getPreferenceStore();
        TableViewerColumn valueColumn = new TableViewerColumn(viewer, 0);
        valueColumn.getColumn().setText(CoreMessages.dialog_connection_internal_parameters_custom_value);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return preferences.getString((String)element);
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput((Object)preferences.preferenceNames());
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)viewer.getTable()));
    }

    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
    }
}

