/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.forms;

import java.text.Format;
import java.text.NumberFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.databinding.conversion.text.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;
import org.eclipse.core.internal.databinding.validation.StringToIntegerValidator;
import org.eclipse.swt.events.SelectionEvent;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.forms.UIControlBuilder;
import org.jkiss.dbeaver.ui.forms.UIObservable;
import org.jkiss.dbeaver.ui.forms.UIPanelBuilder;
import org.jkiss.dbeaver.ui.forms.UIRowBuilderImpl;

public sealed interface UIRowBuilder
permits UIRowBuilderImpl {
    @NotNull
    public static <T> Consumer<T> identityConsumer() {
        return t -> {};
    }

    @NotNull
    public UIRowBuilder enabled(@NotNull UIObservable<Boolean> var1);

    @NotNull
    public UIRowBuilder visible(@NotNull UIObservable<Boolean> var1);

    @NotNull
    public UIRowBuilder panel(@NotNull Consumer<? super UIPanelBuilder> var1);

    @NotNull
    public UIRowBuilder group(@NotNull String var1, @NotNull Consumer<? super UIPanelBuilder> var2);

    @NotNull
    public UIRowBuilder expandableGroup(@NotNull String var1, boolean var2, @NotNull Consumer<? super UIPanelBuilder> var3);

    @NotNull
    public UIRowBuilder label(@NotNull String var1, @NotNull Consumer<? super UIControlBuilder.LabelBuilder> var2);

    @NotNull
    default public UIRowBuilder label(@NotNull String text) {
        return this.label(text, UIRowBuilder.identityConsumer());
    }

    @NotNull
    public UIRowBuilder button(@NotNull String var1, @NotNull Consumer<SelectionEvent> var2, @NotNull Consumer<? super UIControlBuilder.ButtonBuilder> var3);

    @NotNull
    default public UIRowBuilder button(@NotNull String text, @NotNull Consumer<SelectionEvent> onSelect) {
        return this.button(text, onSelect, UIRowBuilder.identityConsumer());
    }

    @NotNull
    public UIRowBuilder radioButton(@NotNull String var1, @NotNull Consumer<? super UIControlBuilder.ButtonBuilder> var2);

    @NotNull
    public UIRowBuilder checkBox(@NotNull String var1, @NotNull Consumer<? super UIControlBuilder.ButtonBuilder> var2);

    @NotNull
    public <T> UIRowBuilder textField(@NotNull UIObservable<T> var1, @NotNull Consumer<? super UIControlBuilder.TextBuilder<T>> var2);

    @NotNull
    default public <T> UIRowBuilder textField(@NotNull UIObservable<T> binding) {
        return this.textField(binding, UIRowBuilder.identityConsumer());
    }

    @NotNull
    public <T> UIRowBuilder passwordField(@NotNull UIObservable<T> var1, @NotNull Consumer<? super UIControlBuilder.TextBuilder<T>> var2);

    @NotNull
    default public <T> UIRowBuilder passwordField(@NotNull UIObservable<T> binding) {
        return this.passwordField(binding, UIRowBuilder.identityConsumer());
    }

    @NotNull
    default public UIRowBuilder intTextField(@NotNull UIObservable<? super Integer> binding, @NotNull Consumer<? super UIControlBuilder.TextBuilder<? super Integer>> handler) {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        StringToNumberConverter toModelConverter = StringToNumberConverter.toInteger((boolean)true);
        StringToIntegerValidator toModelValidator = new StringToIntegerValidator((NumberFormatConverter)toModelConverter);
        NumberToStringConverter fromModelConverter = NumberToStringConverter.fromInteger((Format)format, (boolean)true);
        return this.textField(binding, tb -> {
            handler.accept((UIControlBuilder.TextBuilder<? super Integer>)tb);
            tb.toModel(arg_0 -> ((StringToIntegerValidator)toModelValidator).validate(arg_0), arg_0 -> ((StringToNumberConverter)toModelConverter).convert(arg_0));
            tb.fromModel(arg_0 -> ((NumberToStringConverter)fromModelConverter).convert(arg_0));
        });
    }

    @NotNull
    default public UIRowBuilder intTextField(@NotNull UIObservable<? super Integer> binding) {
        return this.intTextField(binding, UIRowBuilder.identityConsumer());
    }

    @NotNull
    public <T> UIRowBuilder comboBox(@NotNull List<? extends T> var1, @NotNull UIObservable<T> var2, @NotNull Function<? super T, String> var3, @NotNull Consumer<? super UIControlBuilder.ComboBuilder<T>> var4);

    @NotNull
    default public <T> UIRowBuilder comboBox(@NotNull List<? extends T> items, @NotNull UIObservable<T> binding, @NotNull Function<? super T, String> converter) {
        return this.comboBox(items, binding, converter, UIRowBuilder.identityConsumer());
    }

    @NotNull
    default public UIRowBuilder comboBox(@NotNull List<? extends String> items, @NotNull UIObservable<? super String> binding) {
        return this.comboBox(items, binding, Object::toString, UIRowBuilder.identityConsumer());
    }

    @NotNull
    default public <T extends Enum<T>> UIRowBuilder comboBox(@NotNull UIObservable<T> binding, @NotNull Function<? super T, String> converter, @NotNull Consumer<? super UIControlBuilder.ComboBuilder<T>> handler) {
        List<Enum> items = Stream.of((Enum[])binding.type().getEnumConstants()).map(value -> value).toList();
        return this.comboBox(items, binding, converter, handler);
    }

    @NotNull
    default public <T extends Enum<T>> UIRowBuilder comboBox(@NotNull UIObservable<T> binding, @NotNull Function<? super T, String> converter) {
        return this.comboBox(binding, converter, UIRowBuilder.identityConsumer());
    }
}

