import React from 'react';
import { Server } from './Server';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { SERVERS_TEXT } from '../../constants';
export var Servers = function () {
    var servers = useSpec().servers().all();
    var config = useConfig();
    if (!servers.length) {
        return null;
    }
    return (React.createElement("section", { id: "".concat(CommonHelpers.getIdentifier('servers', config)), className: "mt-16" },
        React.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, SERVERS_TEXT),
        React.createElement("ul", null, servers.map(function (server) {
            var serverName = server.id();
            return (React.createElement("li", { className: "mb-4", key: serverName, id: "".concat(CommonHelpers.getIdentifier("server-".concat(serverName), config)) },
                React.createElement(Server, { serverName: serverName, server: server, key: serverName })));
        }))));
};
//# sourceMappingURL=Servers.js.map