/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.relocated.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.ext.awt.image.PadMode;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.ColorMatrixRable8Bit;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeColorMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feColorMatrix";
    }

    @Override
    public Filter createFilter(BridgeContext ctx2, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        ColorMatrixRable colorMatrix;
        Filter in = SVGFeColorMatrixElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx2);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx2);
        int type = SVGFeColorMatrixElementBridge.convertType(filterElement, ctx2);
        switch (type) {
            case 2: {
                float a2 = SVGFeColorMatrixElementBridge.convertValuesToHueRotate(filterElement, ctx2);
                colorMatrix = ColorMatrixRable8Bit.buildHueRotate(a2);
                break;
            }
            case 3: {
                colorMatrix = ColorMatrixRable8Bit.buildLuminanceToAlpha();
                break;
            }
            case 0: {
                float[][] matrix = SVGFeColorMatrixElementBridge.convertValuesToMatrix(filterElement, ctx2);
                colorMatrix = ColorMatrixRable8Bit.buildMatrix(matrix);
                break;
            }
            case 1: {
                float s = SVGFeColorMatrixElementBridge.convertValuesToSaturate(filterElement, ctx2);
                colorMatrix = ColorMatrixRable8Bit.buildSaturate(s);
                break;
            }
            default: {
                throw new RuntimeException("invalid convertType:" + type);
            }
        }
        colorMatrix.setSource(in);
        SVGFeColorMatrixElementBridge.handleColorInterpolationFilters(colorMatrix, filterElement);
        PadRable8Bit filter2 = new PadRable8Bit(colorMatrix, primitiveRegion, PadMode.ZERO_PAD);
        SVGFeColorMatrixElementBridge.updateFilterMap(filterElement, filter2, filterMap);
        return filter2;
    }

    protected static float[][] convertValuesToMatrix(Element filterElement, BridgeContext ctx2) {
        int n;
        String s = filterElement.getAttributeNS(null, "values");
        float[][] matrix = new float[4][5];
        if (s.length() == 0) {
            matrix[0][0] = 1.0f;
            matrix[1][1] = 1.0f;
            matrix[2][2] = 1.0f;
            matrix[3][3] = 1.0f;
            return matrix;
        }
        StringTokenizer tokens = new StringTokenizer(s, " ,");
        try {
            for (n = 0; n < 20 && tokens.hasMoreTokens(); ++n) {
                matrix[n / 5][n % 5] = SVGUtilities.convertSVGNumber(tokens.nextToken());
            }
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx2, filterElement, nfEx, "attribute.malformed", new Object[]{"values", s, nfEx});
        }
        if (n != 20 || tokens.hasMoreTokens()) {
            throw new BridgeException(ctx2, filterElement, "attribute.malformed", new Object[]{"values", s});
        }
        for (int i = 0; i < 4; ++i) {
            float[] fArray = matrix[i];
            fArray[4] = fArray[4] * 255.0f;
        }
        return matrix;
    }

    protected static float convertValuesToSaturate(Element filterElement, BridgeContext ctx2) {
        String s = filterElement.getAttributeNS(null, "values");
        if (s.length() == 0) {
            return 1.0f;
        }
        try {
            return SVGUtilities.convertSVGNumber(s);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx2, filterElement, nfEx, "attribute.malformed", new Object[]{"values", s});
        }
    }

    protected static float convertValuesToHueRotate(Element filterElement, BridgeContext ctx2) {
        String s = filterElement.getAttributeNS(null, "values");
        if (s.length() == 0) {
            return 0.0f;
        }
        try {
            return (float)Math.toRadians(SVGUtilities.convertSVGNumber(s));
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx2, filterElement, nfEx, "attribute.malformed", new Object[]{"values", s});
        }
    }

    protected static int convertType(Element filterElement, BridgeContext ctx2) {
        String s = filterElement.getAttributeNS(null, "type");
        if (s.length() == 0) {
            return 0;
        }
        if ("hueRotate".equals(s)) {
            return 2;
        }
        if ("luminanceToAlpha".equals(s)) {
            return 3;
        }
        if ("matrix".equals(s)) {
            return 0;
        }
        if ("saturate".equals(s)) {
            return 1;
        }
        throw new BridgeException(ctx2, filterElement, "attribute.malformed", new Object[]{"type", s});
    }
}

