/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.AxisBreaksProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.VerticalRotatedLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ.\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002JG\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u00072\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00070\"\u00a2\u0006\u0002\u0010$J9\u0010%\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u00072\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00070\"\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001aJ\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020#J\u0016\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u0007J(\u00100\u001a\u0004\u0018\u00010\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ&\u00102\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002\u00a8\u00064"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/BreakLabelsLayoutUtil;", "", "()V", "alignToLabelMargin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "bounds", "tickLength", "", "margins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "spacing", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "applyLabelMargins", "doLayoutVerticalAxisLabels", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "estimateBreakCount", "", "length", "labels", "", "", "tickLabelSpec", "rotationAngle", "side", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Ljava/util/List;DLorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;Ljava/lang/Double;Lkotlin/jvm/functions/Function1;)I", "estimateBreakCountInitial", "(DLorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;Ljava/lang/Double;Lkotlin/jvm/functions/Function1;)I", "getFlexBreaks", "breaksProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProvider;", "maxCount", "horizontalCenteredLabelBounds", "labelSize", "rotatedLabelBounds", "labelNormalSize", "degreeAngle", "textBounds", "elementRect", "verticalAxisLabelsBounds", "projectedBreaks", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nBreakLabelsLayoutUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakLabelsLayoutUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/BreakLabelsLayoutUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1#2:258\n1549#3:259\n1620#3,3:260\n*S KotlinDebug\n*F\n+ 1 BreakLabelsLayoutUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/BreakLabelsLayoutUtil\n*L\n241#1:259\n241#1:260,3\n*E\n"})
public final class BreakLabelsLayoutUtil {
    @NotNull
    public static final BreakLabelsLayoutUtil INSTANCE = new BreakLabelsLayoutUtil();

    private BreakLabelsLayoutUtil() {
    }

    @NotNull
    public final ScaleBreaks getFlexBreaks(@NotNull AxisBreaksProvider breaksProvider, int maxCount) {
        Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
        if (!(!breaksProvider.isFixedBreaks())) {
            boolean $i$a$-check-BreakLabelsLayoutUtil$getFlexBreaks$32 = false;
            String $i$a$-check-BreakLabelsLayoutUtil$getFlexBreaks$32 = "fixed breaks not expected";
            throw new IllegalStateException($i$a$-check-BreakLabelsLayoutUtil$getFlexBreaks$32.toString());
        }
        if (!(maxCount > 0)) {
            boolean $i$a$-check-BreakLabelsLayoutUtil$getFlexBreaks$42 = false;
            String $i$a$-check-BreakLabelsLayoutUtil$getFlexBreaks$42 = "maxCount=" + maxCount;
            throw new IllegalStateException($i$a$-check-BreakLabelsLayoutUtil$getFlexBreaks$42.toString());
        }
        ScaleBreaks breaks = breaksProvider.getBreaks(maxCount);
        if (maxCount == 1 && !breaks.isEmpty()) {
            return breaks.withOneBreak();
        }
        int count2 = maxCount;
        while (breaks.getSize() > maxCount) {
            int delta = Math.max(1, (breaks.getSize() - maxCount) / 2);
            if ((count2 -= delta) <= 1) {
                breaks = breaksProvider.getBreaks(1);
                break;
            }
            breaks = breaksProvider.getBreaks(count2);
        }
        return breaks;
    }

    @NotNull
    public final DoubleRectangle horizontalCenteredLabelBounds(@NotNull DoubleVector labelSize) {
        Intrinsics.checkNotNullParameter((Object)labelSize, (String)"labelSize");
        return new DoubleRectangle(-labelSize.getX() / 2.0, 0.0, labelSize.getX(), labelSize.getY());
    }

    @NotNull
    public final AxisLabelsLayoutInfo doLayoutVerticalAxisLabels(@NotNull Orientation orientation, @NotNull LabelSpec labelSpec, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme2, @NotNull DoubleSpan axisDomain, double axisLength) {
        DoubleRectangle doubleRectangle;
        DoubleRectangle labelsBounds;
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        if (!(!orientation.isHorizontal())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (theme2.showLabels() && theme2.rotateLabels()) {
            return new VerticalRotatedLabelsLayout(orientation, breaks, theme2).doLayout(axisDomain, axisLength);
        }
        double tickLength = theme2.showTickMarks() ? theme2.tickMarkLength() : 0.0;
        if (theme2.showLabels()) {
            labelsBounds = this.verticalAxisLabelsBounds(breaks, breaks.projectOnAxis(axisDomain, axisLength, false), labelSpec);
            doubleRectangle = this.applyLabelMargins(labelsBounds, tickLength, theme2.tickLabelMargins(), theme2.labelSpacing(), orientation);
        } else if (theme2.showTickMarks()) {
            labelsBounds = DoubleRectangle.Companion.getZERO();
            doubleRectangle = this.applyLabelMargins(labelsBounds, tickLength, theme2.tickLabelMargins(), theme2.labelSpacing(), orientation);
        } else {
            doubleRectangle = DoubleRectangle.Companion.getZERO();
        }
        DoubleRectangle axisBounds = doubleRectangle;
        return new AxisLabelsLayoutInfo.Builder().breaks(breaks).bounds(axisBounds).build();
    }

    @NotNull
    public final DoubleRectangle applyLabelMargins(@NotNull DoubleRectangle bounds, double tickLength, @NotNull Thickness margins, double spacing, @NotNull Orientation orientation) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        DoubleRectangle it = this.alignToLabelMargin(bounds, tickLength, margins, spacing, orientation);
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(0.0, margins.getTop());
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(0.0, margins.getTop() + spacing);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(margins.getLeft(), 0.0);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(margins.getLeft() + spacing, 0.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleVector offset = doubleVector;
        DoubleVector origin = it.subtract(offset).getOrigin();
        DoubleVector dimension = bounds.getDimension().add(orientation.isHorizontal() ? new DoubleVector(0.0, margins.getHeight() + spacing) : new DoubleVector(margins.getWidth() + spacing, 0.0));
        return new DoubleRectangle(origin, dimension);
    }

    @NotNull
    public final DoubleRectangle alignToLabelMargin(@NotNull DoubleRectangle bounds, double tickLength, @NotNull Thickness margins, double spacing, @NotNull Orientation orientation) {
        DoubleVector doubleVector;
        double d;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 3: {
                d = margins.getRight() + bounds.getWidth();
                break;
            }
            case 1: {
                d = margins.getBottom() + bounds.getHeight();
                break;
            }
            case 4: {
                d = margins.getLeft();
                break;
            }
            case 2: {
                d = margins.getTop();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offset = tickLength + spacing + d;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 3: {
                doubleVector = new DoubleVector(-offset, 0.0);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(offset, 0.0);
                break;
            }
            case 1: {
                doubleVector = new DoubleVector(0.0, -offset);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(0.0, offset);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleVector offsetVector = doubleVector;
        return bounds.add(offsetVector);
    }

    @Nullable
    public final DoubleRectangle textBounds(@NotNull DoubleRectangle elementRect, @NotNull Thickness margins, double spacing, @NotNull Orientation orientation) {
        Thickness thickness;
        Intrinsics.checkNotNullParameter((Object)elementRect, (String)"elementRect");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        if (elementRect.getWidth() == 0.0 || elementRect.getHeight() == 0.0) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 3: {
                thickness = new Thickness(0.0, spacing, 0.0, 0.0);
                break;
            }
            case 4: {
                thickness = new Thickness(0.0, 0.0, 0.0, spacing);
                break;
            }
            case 1: {
                thickness = new Thickness(0.0, 0.0, spacing, 0.0);
                break;
            }
            case 2: {
                thickness = new Thickness(spacing, 0.0, 0.0, 0.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Thickness corrected_margins = margins.plus(thickness);
        return orientation.isHorizontal() ? new DoubleRectangle(elementRect.getLeft(), elementRect.getTop() + corrected_margins.getTop(), elementRect.getWidth(), elementRect.getHeight() - corrected_margins.getHeight()) : new DoubleRectangle(elementRect.getLeft() + corrected_margins.getLeft(), elementRect.getTop(), elementRect.getWidth() - corrected_margins.getWidth(), elementRect.getHeight());
    }

    @NotNull
    public final DoubleRectangle rotatedLabelBounds(@NotNull DoubleVector labelNormalSize, double degreeAngle) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        double angle = MathKt.toRadians(degreeAngle);
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double w = Math.sqrt(Math.pow(labelNormalSize.getX() * cos, 2) + Math.pow(Math.abs(labelNormalSize.getY() * sin), 2));
        double h = Math.sqrt(Math.pow(labelNormalSize.getY() * cos, 2) + Math.pow(Math.abs(labelNormalSize.getX() * sin), 2));
        double x2 = 0.0;
        double y2 = 0.0;
        return new DoubleRectangle(x2, y2, w, h);
    }

    private final DoubleRectangle verticalAxisLabelsBounds(ScaleBreaks breaks, List<Double> projectedBreaks, LabelSpec tickLabelSpec) {
        Double d;
        Iterator iterator2 = ((Iterable)breaks.getLabels()).iterator();
        if (!iterator2.hasNext()) {
            d = null;
        } else {
            String p0 = (String)iterator2.next();
            boolean bl = false;
            double d2 = tickLabelSpec.width(p0);
            while (iterator2.hasNext()) {
                String p02 = (String)iterator2.next();
                $i$a$-maxOfOrNull-BreakLabelsLayoutUtil$verticalAxisLabelsBounds$maxLabelWidth$1 = false;
                double d3 = tickLabelSpec.width(p02);
                d2 = Math.max(d2, d3);
            }
            d = d2;
        }
        double maxLabelWidth = d != null ? d : 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        if (!breaks.isEmpty()) {
            y1 = Math.min(((Number)projectedBreaks.get(0)).doubleValue(), ((Number)CollectionsKt.last(projectedBreaks)).doubleValue());
            y2 = Math.max(((Number)projectedBreaks.get(0)).doubleValue(), ((Number)CollectionsKt.last(projectedBreaks)).doubleValue());
            y1 -= tickLabelSpec.height() / (double)2;
            y2 += tickLabelSpec.height() / (double)2;
        }
        DoubleVector origin = new DoubleVector(0.0, y1);
        DoubleVector dimensions = new DoubleVector(maxLabelWidth, y2 - y1);
        return new DoubleRectangle(origin, dimensions);
    }

    public final int estimateBreakCountInitial(double axisLength, @NotNull LabelSpec tickLabelSpec, @Nullable Double rotationAngle, @NotNull Function1<? super DoubleVector, Double> side) {
        Intrinsics.checkNotNullParameter((Object)tickLabelSpec, (String)"tickLabelSpec");
        Intrinsics.checkNotNullParameter(side, (String)"side");
        DoubleVector initialDim = tickLabelSpec.dimensions("0000");
        DoubleVector dimension = rotationAngle != null ? this.rotatedLabelBounds(initialDim, rotationAngle).getDimension() : initialDim;
        return this.estimateBreakCount(((Number)side.invoke((Object)dimension)).doubleValue(), axisLength);
    }

    /*
     * WARNING - void declaration
     */
    public final int estimateBreakCount(@NotNull List<String> labels, double axisLength, @NotNull LabelSpec tickLabelSpec, @Nullable Double rotationAngle, @NotNull Function1<? super DoubleVector, Double> side) {
        Double d;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)tickLabelSpec, (String)"tickLabelSpec");
        Intrinsics.checkNotNullParameter(side, (String)"side");
        Iterable $this$map$iv = labels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void label2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(rotationAngle != null ? INSTANCE.rotatedLabelBounds(tickLabelSpec.multilineDimensions((String)label2), rotationAngle).getDimension() : tickLabelSpec.dimensions((String)label2));
        }
        List dims = (List)destination$iv$iv;
        Iterator iterator2 = ((Iterable)dims).iterator();
        if (!iterator2.hasNext()) {
            d = null;
        } else {
            double d2 = ((Number)side.invoke(iterator2.next())).doubleValue();
            while (iterator2.hasNext()) {
                double d3 = ((Number)side.invoke(iterator2.next())).doubleValue();
                d2 = Math.max(d2, d3);
            }
            d = d2;
        }
        double longestSide = d != null ? d : 0.0;
        return this.estimateBreakCount(longestSide, axisLength);
    }

    private final int estimateBreakCount(double length, double axisLength) {
        double tickDistance = length + 20.0;
        return (int)Math.max(1.0, axisLength / tickDistance);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

