/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.xml.Lexer;
import org.jetbrains.letsPlot.commons.xml.Token;
import org.jetbrains.letsPlot.commons.xml.TokenType;
import org.jetbrains.letsPlot.commons.xml.Xml;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\b\u0010\u000b\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/commons/xml/Parser;", "", "lexer", "Lorg/jetbrains/letsPlot/commons/xml/Lexer;", "(Lorg/jetbrains/letsPlot/commons/xml/Lexer;)V", "getLexer", "()Lorg/jetbrains/letsPlot/commons/xml/Lexer;", "consumeToken", "Lorg/jetbrains/letsPlot/commons/xml/Token;", "expectedType", "Lorg/jetbrains/letsPlot/commons/xml/TokenType;", "skipSpaces", "", "parse", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode;", "parseAttributes", "", "", "parseChildren", "", "parseContent", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode$Text;", "parseElement", "", "token", "commons"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\norg/jetbrains/letsPlot/commons/xml/Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class Parser {
    @NotNull
    private final Lexer lexer;

    public Parser(@NotNull Lexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.lexer = lexer;
    }

    @NotNull
    public final Lexer getLexer() {
        return this.lexer;
    }

    @NotNull
    public final Xml.XmlNode parse() {
        return this.parseElement();
    }

    private final void skipSpaces() {
        while (this.token().getType() == TokenType.WHITESPACE) {
            this.lexer.nextToken();
        }
    }

    private final Token consumeToken(TokenType expectedType, boolean skipSpaces) {
        Token token;
        Token it = token = this.token();
        boolean bl = false;
        this.lexer.nextToken();
        Token consumed = token;
        if (expectedType != null && !(consumed.getType() == expectedType)) {
            boolean bl2 = false;
            String string = "Expected " + (Object)((Object)expectedType) + ", got " + consumed;
            throw new IllegalStateException(string.toString());
        }
        if (skipSpaces) {
            this.skipSpaces();
        }
        return consumed;
    }

    static /* synthetic */ Token consumeToken$default(Parser parser, TokenType tokenType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            tokenType = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return parser.consumeToken(tokenType, bl);
    }

    private final Xml.XmlNode parseElement() {
        int pos = this.lexer.getTokenPos();
        try {
            Parser.consumeToken$default(this, TokenType.LT, false, 2, null);
            String name = Parser.consumeToken$default(this, TokenType.TEXT, false, 2, null).getValue();
            this.skipSpaces();
            Map<String, String> attributes2 = this.parseAttributes();
            this.skipSpaces();
            Token token = Parser.consumeToken$default(this, null, false, 3, null);
            if (Intrinsics.areEqual((Object)token, (Object)Token.Companion.getSLASH_GT())) {
                return new Xml.XmlNode.Element(name, attributes2, null, 4, null);
            }
            if (!Intrinsics.areEqual((Object)token, (Object)Token.Companion.getGT())) {
                throw new IllegalStateException("Expected '>' or '/>'".toString());
            }
            List<Xml.XmlNode> children2 = this.parseChildren();
            Parser.consumeToken$default(this, TokenType.LT_SLASH, false, 2, null);
            this.consumeToken(TokenType.TEXT, true);
            Parser.consumeToken$default(this, TokenType.GT, false, 2, null);
            return new Xml.XmlNode.Element(name, attributes2, children2);
        }
        catch (Throwable _) {
            String string = this.lexer.getInput().substring(pos, this.lexer.getTokenPos());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return new Xml.XmlNode.Text(string);
        }
    }

    private final List<Xml.XmlNode> parseChildren() {
        List children2 = new ArrayList();
        while (!Intrinsics.areEqual((Object)this.token(), (Object)Token.Companion.getEOF())) {
            Collection collection = children2;
            Object object = this.token();
            if (Intrinsics.areEqual((Object)object, (Object)Token.Companion.getLT_SLASH()) ? true : Intrinsics.areEqual((Object)object, (Object)Token.Companion.getSLASH_GT())) break;
            object = Intrinsics.areEqual((Object)object, (Object)Token.Companion.getLT()) ? this.parseElement() : (Xml.XmlNode)this.parseContent();
            collection.add(object);
        }
        return children2;
    }

    private final Map<String, String> parseAttributes() {
        Map attributes2 = new LinkedHashMap();
        while (this.token().getType() == TokenType.TEXT) {
            String key = this.token().getValue();
            Parser.consumeToken$default(this, null, true, 1, null);
            this.consumeToken(TokenType.EQUALS, true);
            TokenType[] tokenTypeArray = new TokenType[]{TokenType.TEXT, TokenType.QUOTED_STRING};
            if (!CollectionsKt.listOf((Object[])tokenTypeArray).contains((Object)this.token().getType())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            attributes2.put(key, this.token().getValue());
            Parser.consumeToken$default(this, null, true, 1, null);
        }
        return attributes2;
    }

    private final Xml.XmlNode.Text parseContent() {
        Token token;
        StringBuilder buffer = new StringBuilder();
        while (!Intrinsics.areEqual((Object)this.token(), (Object)Token.Companion.getEOF()) && !((Intrinsics.areEqual((Object)(token = this.token()), (Object)Token.Companion.getLT_SLASH()) ? true : Intrinsics.areEqual((Object)token, (Object)Token.Companion.getLT())) ? true : Intrinsics.areEqual((Object)token, (Object)Token.Companion.getEOF()))) {
            buffer.append(this.token().getValue());
            Parser.consumeToken$default(this, null, false, 3, null);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Xml.XmlNode.Text(string);
    }

    private final Token token() {
        return this.lexer.getToken();
    }
}

