/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.dialects.postgresbase.PgBaseDomains;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseDomains;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;

public final class PgDomains
extends PgGPlumBaseDomains {
    private static final VersionRange PG_9_4 = VersionRange.after((Version)Version.of((int[])new int[]{9, 4}));
    private static final VersionRange PG_9_2 = VersionRange.after((Version)Version.of((int[])new int[]{9, 2}));

    public PgDomains() {
        this.add((Domain)new IntegerDomain("smallserial", ConversionPoint.SERIAL_NUMBER, -32768.0, 32767.0));
        this.add((Domain)new PgBaseDomains.MyTextLikeDomain("int4range", ConversionPoint.NUMBER_RANGE));
        this.add((Domain)new PgBaseDomains.MyTextLikeDomain("int8range", ConversionPoint.NUMBER_RANGE));
        this.add((Domain)new PgBaseDomains.MyTextLikeDomain("numrange", ConversionPoint.NUMBER_RANGE));
        this.add((Domain)new PgBaseDomains.MyTextLikeDomain("daterange", ConversionPoint.DATE_RANGE));
        this.add((Domain)new PgBaseDomains.MyTextLikeDomain("tsrange", ConversionPoint.TIMESTAMP_RANGE));
        this.add((Domain)new PgBaseDomains.MyTextLikeDomain("tstzrange", ConversionPoint.TIMESTAMP_TZ_RANGE));
        this.add(new SimpleDomain("json", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING).withVersionRange(PG_9_2));
        this.add(new SimpleDomain("jsonb", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING).withVersionRange(PG_9_4));
        this.add((Domain)new UnknownDomain("pg_dependencies"));
        this.add((Domain)new UnknownDomain("pg_ndistinct"));
        this.add((Domain)new UnknownDomain("regnamespace"));
        this.add((Domain)new UnknownDomain("regrole"));
    }
}

