/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.RegistryKeys;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010JP\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u00142\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b`\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/packageChecker/toolwindow/TransitiveDependenciesTraversal;", "", "<init>", "()V", "DEPTH_LIMIT", "", "getTransitiveDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "graph", "packagesDeclaration", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDependenciesTreeDfs", "depth", "dependencyContext", "Lcom/intellij/packageChecker/toolwindow/DependencyContext;", "nameToEntryWithDependencies", "Ljava/util/HashMap;", "Lcom/intellij/packageChecker/model/Package;", "Lkotlin/collections/HashMap;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nTransitiveDependenciesTraversal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransitiveDependenciesTraversal.kt\ncom/intellij/packageChecker/toolwindow/TransitiveDependenciesTraversal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1208#2,2:70\n1236#2,4:72\n1869#2,2:76\n1869#2,2:78\n*S KotlinDebug\n*F\n+ 1 TransitiveDependenciesTraversal.kt\ncom/intellij/packageChecker/toolwindow/TransitiveDependenciesTraversal\n*L\n20#1:70,2\n20#1:72,4\n23#1:76,2\n51#1:78,2\n*E\n"})
public final class TransitiveDependenciesTraversal {
    @NotNull
    public static final TransitiveDependenciesTraversal INSTANCE = new TransitiveDependenciesTraversal();
    private static final int DEPTH_LIMIT = RegistryKeys.INSTANCE.getDepthLimitOfTransitiveDependencies();

    private TransitiveDependenciesTraversal() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Dependency> getTransitiveDependencies(@NotNull Set<? extends Dependency> graph, @NotNull List<PackageDeclaration> packagesDeclaration, @NotNull Module module, @NotNull VirtualFile buildFile) {
        Set set;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Intrinsics.checkNotNullParameter(packagesDeclaration, (String)"packagesDeclaration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        Iterable $this$associateBy$iv = graph;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Dependency dependency = (Dependency)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getPkg(), element$iv$iv);
        }
        HashMap nameToEntryWithDependencies = (HashMap)destination$iv$iv;
        Set $this$getTransitiveDependencies_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = packagesDeclaration;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl2;
            PackageDeclaration entry = (PackageDeclaration)element$iv;
            boolean bl3 = false;
            Dependency dependencyEntry = (Dependency)nameToEntryWithDependencies.get(entry.getPkg());
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DependencyContext dependencyContext = new DependencyContext(project, module, buildFile, null, (arg_0, arg_1, arg_2) -> TransitiveDependenciesTraversal.getTransitiveDependencies$lambda$1$0$0(entry, arg_0, arg_1, arg_2), 8, null);
            if (dependencyEntry != null) {
                Set<Dependency> traversedDependenciesOfEntry = INSTANCE.getDependenciesTreeDfs(0, dependencyEntry.getChildren(), dependencyContext, nameToEntryWithDependencies);
                bl2 = $this$getTransitiveDependencies_u24lambda_u241.add(new Dependency(entry.getPkg(), traversedDependenciesOfEntry, dependencyContext));
                continue;
            }
            bl2 = $this$getTransitiveDependencies_u24lambda_u241.add(new Dependency(entry.getPkg(), SetsKt.emptySet(), dependencyContext));
        }
        return SetsKt.build((Set)set);
    }

    private final Set<Dependency> getDependenciesTreeDfs(int depth, Set<? extends Dependency> graph, DependencyContext dependencyContext, HashMap<Package, Dependency> nameToEntryWithDependencies) {
        Set set;
        if (depth >= DEPTH_LIMIT) {
            return SetsKt.emptySet();
        }
        Set $this$getDependenciesTreeDfs_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = graph;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dependency entry = (Dependency)element$iv;
            boolean bl2 = false;
            Dependency entryWithDependencies = nameToEntryWithDependencies.get(entry.getPkg());
            if (entryWithDependencies == null) {
                $this$getDependenciesTreeDfs_u24lambda_u240.add(entry);
                continue;
            }
            Set<Dependency> traversedDependenciesOfEntry = INSTANCE.getDependenciesTreeDfs(depth + 1, entryWithDependencies.getChildren(), dependencyContext, nameToEntryWithDependencies);
            Dependency dependency = new Dependency(entry.getPkg(), traversedDependenciesOfEntry, dependencyContext);
            $this$getDependenciesTreeDfs_u24lambda_u240.add(dependency);
        }
        return SetsKt.build((Set)set);
    }

    private static final PsiElement getTransitiveDependencies$lambda$1$0$0(PackageDeclaration $entry, VirtualFile virtualFile, Module module, Package package_) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)package_, (String)"<unused var>");
        return $entry.getPsiElement();
    }
}

