/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class NSDeclTracker
implements ModificationTracker {
    private static final Key<Long> MOD_COUNT = Key.create((String)"MOD_COUNT");
    private final XmlTag myRootTag;
    private final PsiFile myFile;
    private final List<XmlAttribute> myNSDecls;
    private long myRootCount;
    private int myCount;

    public NSDeclTracker(XmlTag rootTag) {
        this.myRootTag = rootTag;
        this.myFile = rootTag.getContainingFile();
        this.myNSDecls = this.getNSDecls(false);
        this.myRootCount = this.myFile.getModificationStamp();
        this.myCount = 0;
    }

    public long getModificationCount() {
        return this.myFile.getModificationStamp() == this.myRootCount ? (long)this.myCount : this.queryCount();
    }

    private synchronized long queryCount() {
        for (XmlAttribute decl : this.myNSDecls) {
            if (!decl.isValid()) {
                return this.update();
            }
            Long modCount = (Long)decl.getUserData(MOD_COUNT);
            if (modCount == null || decl.getContainingFile().getModificationStamp() == modCount.longValue()) continue;
            return this.update();
        }
        ArrayList<XmlAttribute> list = this.getNSDecls(false);
        if (!list.equals(this.myNSDecls)) {
            return this.update();
        }
        this.myRootCount = this.myFile.getModificationStamp();
        return this.myCount;
    }

    private long update() {
        this.myNSDecls.clear();
        this.myNSDecls.addAll(this.getNSDecls(true));
        this.myRootCount = this.myFile.getModificationStamp();
        return ++this.myCount;
    }

    private ArrayList<XmlAttribute> getNSDecls(boolean updateModCount) {
        ArrayList<XmlAttribute> list = new ArrayList<XmlAttribute>(Arrays.asList(this.myRootTag.getAttributes()));
        Iterator<XmlAttribute> it = list.iterator();
        while (it.hasNext()) {
            XmlAttribute attribute = it.next();
            if (!attribute.isNamespaceDeclaration() || !attribute.isValid()) {
                it.remove();
            }
            if (!updateModCount) continue;
            attribute.putUserData(MOD_COUNT, (Object)this.myFile.getModificationStamp());
        }
        return list;
    }
}

