/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathPredicate;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IndexZeroPredicate
extends XPathInspection {
    @Override
    protected XPathInspection.Visitor createVisitor(InspectionManager manager, boolean isOnTheFly) {
        return new MyVisitor(manager, isOnTheFly);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "IndexZeroUsage";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected boolean acceptsLanguage(Language language) {
        return language == XPathFileType.XPATH.getLanguage() || language == XPathFileType.XPATH2.getLanguage();
    }

    static final class MyVisitor
    extends XPathInspection.Visitor {
        MyVisitor(InspectionManager manager, boolean isOnTheFly) {
            super(manager, isOnTheFly);
        }

        @Override
        protected void checkPredicate(XPathPredicate predicate) {
            XPathExpression expr = predicate.getPredicateExpression();
            if (expr != null) {
                if (expr.getType() == XPathType.NUMBER) {
                    if (MyVisitor.isZero(expr)) {
                        String message = XPathBundle.message("inspection.message.use.of.0.as.predicate.index", new Object[0]);
                        this.addProblem(this.myManager.createProblemDescriptor((PsiElement)expr, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
                    }
                } else if (expr instanceof XPathBinaryExpression) {
                    XPathBinaryExpression expression = (XPathBinaryExpression)expr;
                    if (expr.getType() == XPathType.BOOLEAN) {
                        if (!XPathTokenTypes.BOOLEAN_OPERATIONS.contains((IElementType)expression.getOperator())) {
                            return;
                        }
                        XPathExpression lOp = expression.getLOperand();
                        XPathExpression rOp = expression.getROperand();
                        if (MyVisitor.isZero(lOp)) {
                            assert (lOp != null);
                            if (MyVisitor.isPosition(rOp)) {
                                String message = XPathBundle.message("inspection.message.comparing.position.to.0", new Object[0]);
                                this.addProblem(this.myManager.createProblemDescriptor((PsiElement)expr, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
                            }
                        } else if (MyVisitor.isZero(rOp)) {
                            assert (rOp != null);
                            if (MyVisitor.isPosition(lOp)) {
                                String message = XPathBundle.message("inspection.message.comparing.position.to", new Object[0]);
                                this.addProblem(this.myManager.createProblemDescriptor((PsiElement)expr, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
                            }
                        }
                    }
                }
            }
        }

        private static boolean isPosition(XPathExpression expression) {
            if (!((expression = ExpectedTypeUtil.unparenthesize(expression)) instanceof XPathFunctionCall)) {
                return false;
            }
            XPathFunctionCall call = (XPathFunctionCall)expression;
            PrefixedName qName = call.getQName();
            if (qName.getPrefix() != null) {
                return false;
            }
            return "position".equals(qName.getLocalName());
        }

        private static boolean isZero(XPathExpression op) {
            return (op = ExpectedTypeUtil.unparenthesize(op)) != null && "0".equals(op.getText());
        }
    }
}

