/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorBase;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DbStructureNodeEditor<E extends BasicElement, S extends DbStructureNodeState<?, ?>>
extends DbEditorBase<E, S> {
    private final List<DbStructureNodeEditor<?, ?>> myChildren;

    public DbStructureNodeEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model) {
        if (controller == null) {
            DbStructureNodeEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbStructureNodeEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
        this.myChildren = new ArrayList();
    }

    @Override
    public boolean register() {
        if (!super.register()) {
            return false;
        }
        this.myChildren.forEach(DbEditor::register);
        return true;
    }

    @Override
    public boolean unregister(boolean keepModel) {
        if (!super.unregister(keepModel)) {
            return false;
        }
        for (DbStructureNodeEditor<?, ?> myChild : this.myChildren) {
            myChild.unregister(keepModel);
        }
        return true;
    }

    public void unregisterEditorsOnly() {
        this.unregister(true);
    }

    @NotNull
    public List<DbStructureNodeEditor<?, ?>> getChildren() {
        List<DbStructureNodeEditor<?, ?>> list = this.myChildren;
        if (list == null) {
            DbStructureNodeEditor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.myChildren.isEmpty();
    }

    @Override
    protected void applyImpl() {
        DbStructureFamilyModelState ss = (DbStructureFamilyModelState)ObjectUtils.tryCast(this.getState(), DbStructureFamilyModelState.class);
        if (ss != null) {
            this.applyFamily(ss);
        }
    }

    private <T extends BasicElement> void applyFamily(@NotNull DbStructureFamilyModelState<T> ss) {
        if (ss == null) {
            DbStructureNodeEditor.$$$reportNull$$$0(3);
        }
        BasicMetaObject meta = ss.getMetaObject();
        List newStates = ContainerUtil.mapNotNull(this.myChildren, c2 -> {
            DbStructureObjectModelState cs = (DbStructureObjectModelState)ObjectUtils.tryCast(c2.getState(), DbStructureObjectModelState.class);
            if (cs == null) {
                return null;
            }
            return c2.getModelRef().cast(ElementIdentity.tryCast(c2.getIdentity(), ss.getMetaObject()), cs.tryCast(meta));
        });
        ss.setCollection(this.getController().getModelController(), newStates);
    }

    @Override
    protected void resetImpl() {
        LinkedHashMap cache = new LinkedHashMap();
        ContainerUtil.fillMapWithValues(cache, this.myChildren.iterator(), DbEditor::getModelRef);
        List newStates = ((DbStructureNodeState)this.getState()).getStructureChildren();
        ArrayList newChildren = new ArrayList(newStates.size());
        for (DbModelRef ref : newStates) {
            DbStructureNodeEditor editor2 = (DbStructureNodeEditor)cache.remove(ref);
            if (editor2 == null) {
                editor2 = this.getController().createStructureNodeEditor(ref);
            }
            newChildren.add(editor2);
        }
        for (DbStructureNodeEditor editor3 : cache.values()) {
            editor3.unregister(false);
        }
        this.setChildren(newChildren);
    }

    public void setChildren(@NotNull List<DbStructureNodeEditor<?, ?>> newChildren) {
        if (newChildren == null) {
            DbStructureNodeEditor.$$$reportNull$$$0(4);
        }
        if (this.myChildren.equals(newChildren)) {
            return;
        }
        ((DbEditorListener)this.getController().getEventDispatcher().getMulticaster()).beforeStructureChanged(this);
        LinkedHashSet toCleanup = new LinkedHashSet(this.myChildren);
        this.myChildren.clear();
        this.myChildren.addAll(newChildren);
        newChildren.forEach(toCleanup::remove);
        for (DbStructureNodeEditor dbStructureNodeEditor : toCleanup) {
            dbStructureNodeEditor.unregister(false);
        }
        newChildren.forEach(DbEditor::register);
        ((DbEditorListener)this.getController().getEventDispatcher().getMulticaster()).structureChanged(this);
        this.modified();
    }

    @Override
    public void updateState() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureNodeEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ss";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureNodeEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFamily";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

