/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.DbObjectEditorModelFactory;
import com.intellij.database.schemaEditor.DbmsObjectEditorModelFactoryKt;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.PropertyModelRequest;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u0003\u0018\u00010\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u00030\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000e0\rH\u0016JR\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00100\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007\"\b\b\u0001\u0010\u0011*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0016J4\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u0003\u0018\u00010\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0013H\u0016J^\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u0003\u0018\u00010\u0005\"\b\b\u0000\u0010\u0018*\u00020\u0019\"\b\b\u0001\u0010\u001a*\u00020\u001b\"\b\b\u0002\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u001a\u0018\u00010\u001dH\u0016Jf\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u0003\u0018\u00010\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007\"\b\b\u0001\u0010\u001f*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u001f0!2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000e0\rH\u0016J<\u0010\"\u001a\u00020#\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00152\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000e0\rH\u0016J)\u0010'\u001a\u00070(\u00a2\u0006\u0002\b)2\u0006\u0010$\u001a\u00020%2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010*\u001a\u00020+H\u0016J\u001c\u0010,\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0010\u0010,\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%H\u0002\u00a8\u0006-"}, d2={"Lcom/intellij/database/schemaEditor/DbObjectModelFactoryBroker;", "Lcom/intellij/database/schemaEditor/DbObjectEditorModelFactory;", "<init>", "()V", "createPropertyEditorModel", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "E", "Lcom/intellij/database/model/basic/BasicElement;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "req", "Lcom/intellij/database/schemaEditor/PropertyModelRequest;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "createStructureFamilyEditorModel", "Lcom/intellij/database/schemaEditor/model/state/DbStructureFamilyModelState;", "C", "id", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "child", "Lcom/intellij/database/model/meta/BasicMetaObject;", "createAnyGrantsEditorModel", "createGrantsEditorModel", "G", "Lcom/intellij/database/model/properties/Grants$Grant;", "U", "Lcom/intellij/database/model/basic/BasicGrantee;", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "createReferenceEditorModel", "T", "reference", "Lcom/intellij/database/model/meta/BasicMetaReference;", "prepareProperties", "", "dbms", "Lcom/intellij/database/Dbms;", "meta", "getTitle", "", "Lcom/intellij/openapi/util/NlsSafe;", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "getDelegate", "intellij.database.impl"})
public class DbObjectModelFactoryBroker
implements DbObjectEditorModelFactory {
    @Override
    @Nullable
    public <E extends BasicElement> DbEditorModel<E, ?> createPropertyEditorModel(@NotNull DbEditorModelController controller, @NotNull PropertyModelRequest<E, ?> req, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(req, (String)"req");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        return this.getDelegate(controller, req.getId()).createPropertyEditorModel(controller, req, fields);
    }

    @Override
    @NotNull
    public <E extends BasicElement, C extends BasicElement> DbEditorModel<E, DbStructureFamilyModelState<C>> createStructureFamilyEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaObject<C> child) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        return this.getDelegate(controller, id).createStructureFamilyEditorModel(controller, id, child);
    }

    @Override
    @Nullable
    public <E extends BasicElement> DbEditorModel<E, ?> createAnyGrantsEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return this.getDelegate(controller, id).createAnyGrantsEditorModel(controller, id);
    }

    @Override
    @Nullable
    public <G extends Grants.Grant, U extends BasicGrantee, E extends BasicElement> DbEditorModel<E, ?> createGrantsEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @Nullable Grants.Controller<G, U> grantCtl) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return this.getDelegate(controller, id).createGrantsEditorModel(controller, id, grantCtl);
    }

    @Override
    @Nullable
    public <E extends BasicElement, T extends BasicElement> DbEditorModel<E, ?> createReferenceEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaReference<E, T> reference, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        return this.getDelegate(controller, id).createReferenceEditorModel(controller, id, reference, fields);
    }

    @Override
    public <E extends BasicElement> void prepareProperties(@NotNull Dbms dbms, @NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.getDelegate(dbms).prepareProperties(dbms, meta, fields);
    }

    @Override
    @NotNull
    public String getTitle(@NotNull Dbms dbms, @NotNull ElementIdentity<?> id, @NotNull BasicMetaId prop) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        return this.getDelegate(dbms).getTitle(dbms, id, prop);
    }

    private final DbObjectEditorModelFactory getDelegate(DbEditorModelController controller, ElementIdentity<?> id) {
        Dbms dbms = controller.getDbms(id);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return this.getDelegate(dbms);
    }

    private final DbObjectEditorModelFactory getDelegate(Dbms dbms) {
        Object object = DbmsObjectEditorModelFactoryKt.DbmsObjectEditorModelFactories.forDbms(dbms);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forDbms(...)");
        return (DbObjectEditorModelFactory)object;
    }
}

