/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.queryFiles;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DataSourcePerFileMappings;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.console.queryFiles.QueryFilesIgnoreUpdater;
import com.intellij.database.console.queryFiles.QueryFilesOpener;
import com.intellij.database.console.session.DatabaseConsoleHistoryController;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/console/queryFiles/QueryFilesOpener;", "", "<init>", "()V", "Companion", "Mode", "intellij.database.impl"})
@ApiStatus.Internal
public final class QueryFilesOpener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @JvmStatic
    @Nullable
    public static final VirtualFile getAttachedFile(@NotNull LocalDataSource dataSource, @NotNull Project project, @NotNull Mode mode) {
        return Companion.getAttachedFile(dataSource, project, mode);
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile createNewFileInDirectory(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull VirtualFile directory, @NotNull String fileName) {
        return Companion.createNewFileInDirectory(project, dataSource, directory, fileName);
    }

    @JvmStatic
    @Nullable
    public static final Path getRootPath(@NotNull Project project) {
        return Companion.getRootPath(project);
    }

    static {
        Logger logger = Logger.getInstance(QueryFilesOpener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001d\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0017J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000eH\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010$\u001a\u00020\fH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\fH\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\"\u0010)\u001a\u0004\u0018\u00010\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/console/queryFiles/QueryFilesOpener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "handleException", "", "e", "", "pathName", "", "getAttachedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "mode", "Lcom/intellij/database/console/queryFiles/QueryFilesOpener$Mode;", "suggestAttachingDirectoryIfNotAttached", "directory", "suggestAttachingDirectoryIfNotAttached$intellij_database_impl", "attachDirectory", "createDefaultModule", "Lcom/intellij/openapi/module/Module;", "tryToCreateRoot", "contentRootPath", "Ljava/nio/file/Path;", "localFileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "getExistingFile", "parentVirtualFile", "dataSourceId", "createNewFile", "fileName", "createNewScratchFile", "getFileExtension", "createNewFileInDirectory", "getRootPath", "createVirtualFile", "parent", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nQueryFilesOpener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryFilesOpener.kt\ncom/intellij/database/console/queryFiles/QueryFilesOpener$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,238:1\n57#2:239\n35#2,2:240\n536#3:242\n521#3,6:243\n*S KotlinDebug\n*F\n+ 1 QueryFilesOpener.kt\ncom/intellij/database/console/queryFiles/QueryFilesOpener$Companion\n*L\n47#1:239\n47#1:240,2\n150#1:242\n150#1:243,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void handleException(Throwable e, String pathName) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(e);
            ApplicationManager.getApplication().invokeLater(() -> Companion.handleException$lambda$0(pathName, e));
        }

        @JvmStatic
        @Nullable
        public final VirtualFile getAttachedFile(@NotNull LocalDataSource dataSource, @NotNull Project project, @NotNull Mode mode) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2;
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            if (!QueryFilesUtilsKt.isQueryFilesFlagEnabled()) {
                return DatabaseConsoleHistoryController.Companion.getContentFile((DasDataSource)dataSource, mode.toScratchFileServiceOption());
            }
            String string = dataSource.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
            String id = string;
            Path path = this.getRootPath(project);
            if (path == null) {
                return null;
            }
            Path contentRootPath = path;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            LocalFileSystem localFileSystem2 = localFileSystem;
            try {
                VirtualFile virtualFile3 = localFileSystem2.findFileByNioFile(contentRootPath);
                if (virtualFile3 == null && (virtualFile3 = this.tryToCreateRoot(contentRootPath, localFileSystem2)) == null) {
                    return null;
                }
                virtualFile2 = virtualFile3;
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.getAttachedFile$lambda$0(e));
                return null;
            }
            VirtualFile contentRoot = virtualFile2;
            QueryFileSettings settings = QueryFileSettings.Companion.getInstance(project);
            if (!settings.isAskedToAttachDirectory()) {
                settings.setAskedToAttachProjectDirectory();
                this.suggestAttachingDirectoryIfNotAttached$intellij_database_impl(project, contentRoot);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    virtualFile = this.createNewScratchFile(dataSource, project);
                    break;
                }
                case 2: {
                    virtualFile = com.intellij.database.console.queryFiles.QueryFilesOpener$Companion.createNewFile$default(this, contentRoot, dataSource, project, null, 8, null);
                    break;
                }
                case 3: {
                    virtualFile = this.getExistingFile(contentRoot, id, project);
                    if (virtualFile != null) break;
                    virtualFile = com.intellij.database.console.queryFiles.QueryFilesOpener$Companion.createNewFile$default(this, contentRoot, dataSource, project, null, 8, null);
                    break;
                }
                case 4: {
                    virtualFile = this.getExistingFile(contentRoot, id, project);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return virtualFile;
        }

        public final void suggestAttachingDirectoryIfNotAttached$intellij_database_impl(@NotNull Project project, @NotNull VirtualFile directory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            if (ModuleUtilCore.findModuleForFile((VirtualFile)directory, (Project)project) != null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                WriteAction.runAndWait(() -> Companion.suggestAttachingDirectoryIfNotAttached$lambda$0(project, directory));
                return;
            }
            BuildersKt.launch$default((CoroutineScope)QueryFileSettings.Companion.getInstance(project).getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(directory, project, null){
                int label;
                final /* synthetic */ VirtualFile $directory;
                final /* synthetic */ Project $project;
                {
                    this.$directory = $directory;
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$directory, this.$project, null){
                                int label;
                                final /* synthetic */ VirtualFile $directory;
                                final /* synthetic */ Project $project;
                                {
                                    this.$directory = $directory;
                                    this.$project = $project;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            String string = DatabaseBundle.message((String)"query.files.attach.directory.title", (Object[])new Object[0]);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                            Object[] objectArray = new Object[]{this.$directory.getPath()};
                                            String string2 = DatabaseBundle.message((String)"query.files.attach.directory.text", (Object[])objectArray);
                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                            if (!MessageUtil.showYesNoDialog$default((String)string, (String)string2, (Project)this.$project, null, null, null, (int)56, null)) {
                                                QueryFilesOpener.access$getLOG$cp().debug("User didn't accept to attach directory '" + this.$directory + "' to project '" + this.$project.getName() + "'");
                                                return Unit.INSTANCE;
                                            }
                                            QueryFilesOpener.access$getLOG$cp().debug("User accepted to attach directory '" + this.$directory + "' to project '" + this.$project.getName() + "'");
                                            this.label = 1;
                                            Object object2 = CoroutinesKt.writeAction(() -> suggestAttachingDirectoryIfNotAttached.1.invokeSuspend$lambda$0(this.$project, this.$directory), (Continuation)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final Unit invokeSuspend$lambda$0(Project $project, VirtualFile $directory) {
                                    com.intellij.database.console.queryFiles.QueryFilesOpener$Companion.access$attachDirectory(QueryFilesOpener.Companion, $project, $directory);
                                    return Unit.INSTANCE;
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @RequiresWriteLock
        private final void attachDirectory(Project project, VirtualFile directory) {
            Module[] modules = ModuleManager.Companion.getInstance(project).getModules();
            Module module = modules.length == 0 ? this.createDefaultModule(project) : modules[0];
            ModuleRootModificationUtil.updateModel((Module)module, arg_0 -> Companion.attachDirectory$lambda$0(directory, arg_0));
            LOG.debug("Directory '" + directory + "' attached to module '" + module.getName() + "'");
        }

        private final Module createDefaultModule(Project project) {
            IProjectStore store = ProjectKt.getStateStore((Project)project);
            Path proDir = store.getProjectFilePath().getParent();
            Path modulePath = proDir.resolve(project.getName() + ".iml");
            ModuleType moduleType = ModuleTypeManager.getInstance().getDefaultModuleType();
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"getDefaultModuleType(...)");
            ModuleType defType = moduleType;
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)modulePath);
            String string = defType.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            return moduleManager.newModule(modulePath, string);
        }

        private final VirtualFile tryToCreateRoot(Path contentRootPath, LocalFileSystem localFileSystem) {
            Files.createDirectories(contentRootPath, new FileAttribute[0]);
            return localFileSystem.refreshAndFindFileByNioFile(contentRootPath);
        }

        /*
         * WARNING - void declaration
         */
        private final VirtualFile getExistingFile(VirtualFile parentVirtualFile, String dataSourceId, Project project) {
            void $this$filterTo$iv$iv;
            Map mappings = (Map)ReadAction.compute(() -> Companion.getExistingFile$lambda$0(project));
            Path path = parentVirtualFile.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Path parentNioPath = path;
            Intrinsics.checkNotNull((Object)mappings);
            Map $this$filter$iv = mappings;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile file = (VirtualFile)entry.getKey();
                LocalDataSource ds = (LocalDataSource)entry.getValue();
                if (!(Intrinsics.areEqual((Object)ds.getUniqueId(), (Object)dataSourceId) && file.toNioPath().startsWith(parentNioPath))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return (VirtualFile)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.keySet());
        }

        private final VirtualFile createNewFile(VirtualFile parentVirtualFile, LocalDataSource dataSource, Project project, String fileName) {
            String fileExtension = this.getFileExtension(dataSource);
            String string = VfsUtil.getNextAvailableName((VirtualFile)parentVirtualFile, (String)fileName, (String)fileExtension);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNextAvailableName(...)");
            String path = string;
            VirtualFile file = (VirtualFile)WriteAction.compute(() -> Companion.createNewFile$lambda$0(parentVirtualFile, path, project, dataSource));
            if (file != null) {
                LOG.debug("File '" + file.getPath() + "' created and attached to a data source '" + dataSource.getName() + "'");
            }
            BuildersKt.launch$default((CoroutineScope)QueryFileSettings.Companion.getInstance(project).getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                                int label;
                                final /* synthetic */ Project $project;
                                {
                                    this.$project = $project;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            ((QueryFilesIgnoreUpdater)this.$project.getService(QueryFilesIgnoreUpdater.class)).suggestUpdatingGitignoreIfNeeded();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return file;
        }

        static /* synthetic */ VirtualFile createNewFile$default(Companion companion, VirtualFile virtualFile, LocalDataSource localDataSource, Project project, String string, int n, Object object) {
            if ((n & 8) != 0) {
                String string2 = localDataSource.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                string = QueryFileSettings.Companion.getDefaultNameForQueryFile(project, string2);
            }
            return companion.createNewFile(virtualFile, localDataSource, project, string);
        }

        private final VirtualFile createNewScratchFile(LocalDataSource dataSource, Project project) {
            String fileExtension = this.getFileExtension(dataSource);
            String string = dataSource.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = QueryFileSettings.Companion.getDefaultNameForQueryFile(project, string) + "." + fileExtension;
            return (VirtualFile)WriteAction.compute(() -> Companion.createNewScratchFile$lambda$0(project, fileName, dataSource));
        }

        private final String getFileExtension(LocalDataSource dataSource) {
            DbConsoleRootType dbConsoleRootType = DbConsoleRootType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dbConsoleRootType), (String)"getInstance(...)");
            return DatabaseConsoleHistoryController.Companion.getFileExtension$intellij_database_impl(dbConsoleRootType, (DasDataSource)dataSource);
        }

        @JvmStatic
        @Nullable
        public final VirtualFile createNewFileInDirectory(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull VirtualFile directory, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.suggestAttachingDirectoryIfNotAttached$intellij_database_impl(project, directory);
            return this.createNewFile(directory, dataSource, project, fileName);
        }

        @JvmStatic
        @Nullable
        public final Path getRootPath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            QueryFileSettings settings = QueryFileSettings.Companion.getInstance(project);
            return settings.getQueriesDirectory();
        }

        private final VirtualFile createVirtualFile(VirtualFile parent2, String fileName, Project project) {
            Object object;
            block2: {
                Object object2;
                object = this;
                try {
                    Companion $this$createVirtualFile_u24lambda_u240 = object;
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)((VirtualFile)WriteCommandAction.runWriteCommandAction((Project)project, () -> Companion.createVirtualFile$lambda$0$0(parent2, fileName))));
                }
                catch (Throwable bl) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = object2;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) break block2;
                Object e = object2 = throwable;
                boolean bl = false;
                Path path = parent2.toNioPath().resolve(fileName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Companion.handleException((Throwable)e, ((Object)path).toString());
            }
            return (VirtualFile)(Result.isFailure-impl((Object)object) ? null : object);
        }

        private static final void handleException$lambda$0(String $pathName, Throwable $e) {
            Object[] objectArray = new Object[]{$pathName, $e.getLocalizedMessage()};
            String string = DatabaseBundle.message((String)"dialog.message.unable.to.open.reason", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String errorMessage = string;
            String string2 = DatabaseBundle.message((String)"dialog.title.unable.to.open.file", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String title = string2;
            Messages.showErrorDialog((String)errorMessage, (String)title);
        }

        private static final void getAttachedFile$lambda$0(Exception $e) {
            Messages.showErrorDialog((String)$e.getLocalizedMessage(), (String)DatabaseBundle.message((String)"dialog.title.cannot.create.directory", (Object[])new Object[0]));
        }

        private static final void suggestAttachingDirectoryIfNotAttached$lambda$0(Project $project, VirtualFile $directory) {
            Companion.attachDirectory($project, $directory);
        }

        private static final void attachDirectory$lambda$0(VirtualFile $directory, ModifiableRootModel model) {
            block0: {
                ModifiableRootModel modifiableRootModel = model;
                if (modifiableRootModel == null) break block0;
                modifiableRootModel.addContentEntry($directory);
            }
        }

        private static final Map getExistingFile$lambda$0(Project $project) {
            return DataSourcePerFileMappings.Companion.getInstance($project).getMappings();
        }

        private static final VirtualFile createNewFile$lambda$0(VirtualFile $parentVirtualFile, String $path, Project $project, LocalDataSource $dataSource) {
            VirtualFile vfile = Companion.createVirtualFile($parentVirtualFile, $path, $project);
            DataSourcePerFileMappingsImpl.Companion.setDataSourcePerFileMapping($project, vfile, $dataSource);
            return vfile;
        }

        private static final VirtualFile createNewScratchFile$lambda$0(Project $project, String $fileName, LocalDataSource $dataSource) {
            return ScratchRootType.getInstance().createScratchFile($project, $fileName, DbSqlUtilCore.getLanguage((LocalDataSource)$dataSource), "", ScratchFileService.Option.create_new_always);
        }

        private static final VirtualFile createVirtualFile$lambda$0$0(VirtualFile $parent, String $fileName) {
            return $parent.createChildData((Object)$parent, $fileName);
        }

        public static final /* synthetic */ void access$attachDirectory(Companion $this, Project project, VirtualFile directory) {
            $this.attachDirectory(project, directory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.CREATE_SCRATCH.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.CREATE_NEW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.CREATE_IF_NEEDED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.EXISTING_ONLY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/console/queryFiles/QueryFilesOpener$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "CREATE_SCRATCH", "EXISTING_ONLY", "CREATE_NEW", "CREATE_IF_NEEDED", "toScratchFileServiceOption", "Lcom/intellij/ide/scratch/ScratchFileService$Option;", "intellij.database.impl"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode CREATE_SCRATCH = new Mode();
        public static final /* enum */ Mode EXISTING_ONLY = new Mode();
        public static final /* enum */ Mode CREATE_NEW = new Mode();
        public static final /* enum */ Mode CREATE_IF_NEEDED = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final ScratchFileService.Option toScratchFileServiceOption() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> ScratchFileService.Option.existing_only;
                case 2 -> ScratchFileService.Option.create_new_always;
                case 3 -> ScratchFileService.Option.create_if_missing;
                case 4 -> ScratchFileService.Option.create_new_always;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.CREATE_SCRATCH, Mode.EXISTING_ONLY, Mode.CREATE_NEW, Mode.CREATE_IF_NEEDED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.EXISTING_ONLY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.CREATE_NEW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.CREATE_IF_NEEDED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.CREATE_SCRATCH.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

