/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.microservices.HttpRequestMicroservicesUtil;
import com.intellij.httpClient.http.request.microservices.HttpRequestPartiallyKnownUrls;
import com.intellij.httpClient.http.request.microservices.LastUrlSegmentInsertHandler;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.impl.HttpRequestTargetImpl;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlSpecialSegmentMarker;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.PathSegmentHandler;
import com.intellij.microservices.url.references.UrlExtractors;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.SplitEscaper;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class HttpRequestSegmentsReferenceContributor
extends PsiReferenceContributor {
    private static final String PLACEHOLDER = "{{$placeholder}}";
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("\\s*([\\p{Alpha}\\d_\\-.]+)\\s*");
    private static final UrlSpecialSegmentMarker VARIABLE_MARKER = new UrlSpecialSegmentMarker("{{", "}}", VARIABLE_NAME_PATTERN);

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(0);
        }
        final UrlPathReferenceInjector injector = UrlPathReferenceInjector.forPartialStringFrom((UrlPksParser)HttpRequestSegmentsReferenceContributor.getParser(), HttpRequestSegmentsReferenceContributor::getElementPks).withDefaultRootContextProviderFactory(psiElement -> {
            HttpRequest httpRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)psiElement, HttpRequest.class);
            if (httpRequest != null) {
                String method = httpRequest.getHttpMethod();
                Set schemes = StreamEx.of(RequestExecutionSupport.All.forMethod(method, httpRequest.getProject())).flatCollection(RequestExecutionSupport::getSupportedSchemes).map(scheme -> scheme + "://").toSet();
                UrlPathContext provider = UrlPathContext.emptyRoot();
                if (UrlConstants.HTTP_METHODS.contains(method)) {
                    provider = provider.withMethod(method);
                }
                if (!schemes.isEmpty()) {
                    provider = provider.withSchemes(schemes);
                }
                return provider;
            }
            return UrlPathContext.supportingSchemes((List)UrlConstants.HTTP_SCHEMES);
        }).withPathSegmentHandler(new PathSegmentHandler(this){

            @NotNull
            public String render(@NotNull UrlPath.PathSegment segment) {
                if (segment == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = HttpRequestMicroservicesUtil.HTTP_REQUEST_RENDERER.patternMatch(segment);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public List<UrlPath.PathSegment> getExactPrefix(@NotNull UrlPath path) {
                if (path == null) {
                    1.$$$reportNull$$$0(2);
                }
                ArrayList<UrlPath.PathSegment> segments = new ArrayList<UrlPath.PathSegment>(path.getSegments());
                ListIterator iterator = segments.listIterator(segments.size());
                while (iterator.hasPrevious() && ((UrlPath.PathSegment)iterator.previous()).isEmpty()) {
                    iterator.remove();
                }
                ArrayList<UrlPath.PathSegment> arrayList = segments;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            @NotNull
            public InsertHandler<LookupElement> createInsertHandler(@NotNull UrlTargetInfo variant, boolean hasSomethingNext) {
                if (variant == null) {
                    1.$$$reportNull$$$0(4);
                }
                return new LastUrlSegmentInsertHandler(variant.getContentTypes(), hasSomethingNext);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "segment";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variant";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "render";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExactPrefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "render";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getExactPrefix";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createInsertHandler";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        }).withCustomHostAligner(entry -> {
            if (entry.getRange().isEmpty() || entry.getHost() == null) {
                return null;
            }
            return new Pair((Object)entry.getHost(), (Object)entry.getRange());
        });
        injector.getUrlParser().setShouldHaveScheme(false);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(HttpRequestTarget.class), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
                String method;
                HttpRequest containingRequest;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!((containingRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequest.class, (boolean)true)) == null || UrlConstants.HTTP_METHODS.contains(method = containingRequest.getHttpMethod()) || "GRAPHQL".equals(method) || "WEBSOCKET".equals(method))) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = injector.buildFullUrlReference((Object)element, element);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    @NotNull
    private static UrlPksParser getParser() {
        return new UrlPksParser((s, c) -> SplitEscaper.AcceptAll.INSTANCE, s -> HttpRequestSegmentsReferenceContributor.extractSegment(s));
    }

    @NotNull
    private static UrlPath.PathSegment extractSegment(@NotNull String segmentStr) {
        UrlPath.PathSegment placeholder;
        if (segmentStr == null) {
            HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(1);
        }
        if ((placeholder = UrlExtractors.extractPlaceholder((String)segmentStr, (String)PLACEHOLDER)) != null) {
            UrlPath.PathSegment pathSegment = placeholder;
            if (pathSegment == null) {
                HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(2);
            }
            return pathSegment;
        }
        UrlPath.PathSegment variables2 = UrlExtractors.extractPathVariable((String)segmentStr, (UrlSpecialSegmentMarker)VARIABLE_MARKER);
        if (variables2 != null) {
            UrlPath.PathSegment pathSegment = variables2;
            if (pathSegment == null) {
                HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(3);
            }
            return pathSegment;
        }
        return new UrlPath.PathSegment.Exact(segmentStr);
    }

    private static PartiallyKnownString getElementPks(PsiElement o) {
        if (!(o instanceof HttpRequestTargetImpl)) {
            return new PartiallyKnownString(o.getText(), o, ElementManipulators.getValueTextRange((PsiElement)o));
        }
        HttpRequestTargetImpl target = (HttpRequestTargetImpl)o;
        return new PartiallyKnownString(HttpRequestPartiallyKnownUrls.getUrlParts(target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentStr";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSegment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractSegment";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

