/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.httpClient.actions.HttpClientConvertFromCurlDialog;
import com.intellij.httpClient.actions.OpenInScratchFileUtil;
import com.intellij.httpClient.converters.curl.CurlConversionUtilsKt;
import com.intellij.httpClient.converters.curl.Utils;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertCurlToHttpRequestAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ConvertCurlToHttpRequestAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        String clipboard = ConvertCurlToHttpRequestAction.getClipboardContent();
        String initial = Utils.isCurlString(clipboard) ? clipboard : "curl -i http://httpbin.org/ip";
        HttpClientConvertFromCurlDialog dialog = new HttpClientConvertFromCurlDialog(project, initial);
        if (dialog.showAndGet()) {
            try {
                String text2 = dialog.getCurlText();
                PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
                if (ConvertCurlToHttpRequestAction.isHttpClientFile(psiFile) && editor2 != null) {
                    int offset;
                    Document document = editor2.getDocument();
                    boolean hasSeparator = CurlConversionUtilsKt.hasSeparator((HttpRequestPsiFile)psiFile, offset = document.getTextLength());
                    String convertedRequestText = CurlConversionUtilsKt.convertToCurl(text2, offset, !hasSeparator);
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)RestClientBundle.message("http.request.convert.curl.ui.title", new Object[0]), null, () -> {
                        document.insertString(offset, (CharSequence)convertedRequestText);
                        editor2.getCaretModel().moveToOffset(offset);
                        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    }, (PsiFile[])new PsiFile[0]);
                } else {
                    String convertedRequestText = CurlConversionUtilsKt.convertToCurl(text2, 0, true);
                    OpenInScratchFileUtil.createAndOpenScratchFile(project, convertedRequestText);
                }
            }
            catch (CurlParseException ex) {
                Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)RestClientBundle.message("http.request.convert.curl.to.http.request.failed.title", new Object[0]));
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    private static String getClipboardContent() {
        block3: {
            String string;
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                if (contents == null) break block3;
                string = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e1) {
                LOG.warn("Failed getting clipboard content");
            }
            if (string == null) {
                ConvertCurlToHttpRequestAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    private static boolean isHttpClientFile(@Nullable PsiFile psiFile) {
        if (!(psiFile instanceof HttpRequestPsiFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile != null && !HttpRequestFileUtils.isHttpRequestSystemFile(psiFile.getProject(), virtualFile.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/ConvertCurlToHttpRequestAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/ConvertCurlToHttpRequestAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClipboardContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

