/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Elements
implements Iterable<Element> {
    private final NodeList elements;
    private final int length;

    Elements(NodeList elements) {
        this.elements = elements;
        this.length = elements.getLength();
    }

    @Override
    public Iterator<Element> iterator() {
        return new ElementIterator();
    }

    private class ElementIterator
    implements Iterator<Element> {
        private int i = 0;
        private Element next = null;

        private ElementIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next != null || (this.next = this.findNext()) != null;
        }

        @Override
        public Element next() {
            try {
                Element element = this.findNext();
                return element;
            }
            finally {
                this.next = null;
            }
        }

        private Element findNext() {
            if (this.next == null) {
                while (this.i < Elements.this.length) {
                    Node node;
                    if ((node = Elements.this.elements.item(this.i++)).getNodeType() != 1) continue;
                    this.next = (Element)node;
                    break;
                }
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

