/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;
import org.jetbrains.plugins.less.references.LESSVariableReference;

public class LessPropertyAsVariableReference
extends LESSVariableReference {
    public LessPropertyAsVariableReference(LESSVariableImpl lessVariable) {
        super(lessVariable);
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiElement propertyNameElement;
        String name = ((LESSVariableImpl)this.getElement()).getName();
        Ref result = new Ref();
        CssDeclaration contextDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), CssDeclaration.class);
        if (contextDeclaration == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                LessPropertyAsVariableReference.$$$reportNull$$$0(0);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        LessPropertyAsVariableReference.processPropertyDeclarationsInEnclosingBlocks(contextDeclaration, (Processor<? super CssDeclaration>)((Processor)declaration -> {
            if (name.equals(declaration.getPropertyName())) {
                if (declaration != contextDeclaration) {
                    result.set(declaration);
                }
                return false;
            }
            return true;
        }));
        if (!result.isNull() && (propertyNameElement = ((CssDeclaration)result.get()).getPropertyNameElement()) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(propertyNameElement)};
            if (resolveResultArray == null) {
                LessPropertyAsVariableReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            LessPropertyAsVariableReference.$$$reportNull$$$0(2);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static void processPropertyDeclarationsInEnclosingBlocks(@NotNull CssDeclaration context, @NotNull Processor<? super CssDeclaration> processor) {
        if (context == null) {
            LessPropertyAsVariableReference.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            LessPropertyAsVariableReference.$$$reportNull$$$0(4);
        }
        CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)context, CssBlock.class);
        while (block != null) {
            for (int i = block.getDeclarations().length - 1; i >= 0; --i) {
                CssDeclaration declaration = block.getDeclarations()[i];
                if (processor.process((Object)declaration)) continue;
                return;
            }
            block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)block, CssBlock.class);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/references/LessPropertyAsVariableReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/references/LessPropertyAsVariableReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processPropertyDeclarationsInEnclosingBlocks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

