/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Time;
import java.util.List;
import org.jetbrains.idea.perforce.util.tracer.ConcurrentThreadsStatistics;
import org.jetbrains.idea.perforce.util.tracer.StatisticsPresentation;
import org.jetbrains.idea.perforce.util.tracer.Timed;

class ConcurrentThreadsPresentation<Kind extends Enum>
implements StatisticsPresentation<ConcurrentThreadsStatistics<Kind>> {
    ConcurrentThreadsPresentation() {
    }

    @Override
    public void putSelf(StringBuilder sb, ConcurrentThreadsStatistics<Kind> statistics) {
        sb.append("Number of concurrent threads\nAverage:\n");
        ConcurrentThreadsStatistics.MaxAveragePairAverage average = (ConcurrentThreadsStatistics.MaxAveragePairAverage)statistics.getAverage();
        int cnt = average.getCnt();
        sb.append("Maximum number: ").append(average.getMax());
        if (cnt > 0) {
            sb.append(", average: ").append(average.getTotal().divide(new BigDecimal(cnt), RoundingMode.HALF_DOWN));
        }
        sb.append("\nRecently:\n");
        List list = statistics.receiveRecentComplete();
        for (Timed timed : list) {
            sb.append("Maximum at ").append(new Time(timed.getTime())).append(": ").append(((ConcurrentThreadsStatistics.MaxCurrentPair)timed.getT()).getMax()).append('\n');
        }
    }
}

