/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.actionscript.psi.ActionScriptUseScopeProvider;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBoundNameOwner;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassBase;
import com.intellij.lang.javascript.psi.impl.JSCachingNamespaceOwner;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSUseScopeProvider {
    private static final Class<? extends PsiElement>[] SCOPE_TYPES = new Class[]{JSBlockStatement.class, JSExecutionScope.class, JSSwitchStatement.class, JSVariableDeclaringScope.class, PsiFile.class};

    private JSUseScopeProvider() {
    }

    @Nullable
    public static PsiElement getLexicalScope(@NotNull PsiElement context) {
        if (context == null) {
            JSUseScopeProvider.$$$reportNull$$$0(0);
        }
        return JSUseScopeProvider.getLexicalScope(context, false, true);
    }

    @Nullable
    public static PsiElement getLexicalScopeOrFile(@NotNull PsiElement element) {
        if (element == null) {
            JSUseScopeProvider.$$$reportNull$$$0(1);
        }
        return JSUseScopeProvider.getLexicalScope(element, false, false);
    }

    @Nullable
    private static PsiElement getLexicalScope(@NotNull PsiElement context, boolean includePropertyHolders, boolean checkForGlobalContext) {
        PsiElement parent;
        if (context == null) {
            JSUseScopeProvider.$$$reportNull$$$0(2);
        }
        for (parent = context.getContext(); !(parent == null || parent instanceof JSExecutionScope || parent instanceof JSPackage || parent instanceof JSPackageStatement || parent instanceof ActionScriptClassBase || includePropertyHolders && (parent instanceof JSObjectLiteralExpression || parent instanceof JSClass)); parent = parent.getContext()) {
        }
        return checkForGlobalContext && JSUseScopeProvider.isGlobalLexicalScopeElement(parent) ? null : parent;
    }

    private static boolean isGlobalLexicalScopeElement(@Nullable PsiElement node) {
        return node == null || node instanceof JSEmbeddedContent && !ES6PsiUtil.isEmbeddedModule(node) || node instanceof JSFile && !((JSFile)node).getModuleStatus().isStrictlyModule() && !DialectDetector.isActionScript(node);
    }

    @Nullable
    public static PsiElement getUseScopeElement(@Nullable JSNamedElement declaration) {
        JSAttributeListOwner attributeListOwner;
        JSAttributeList attributeList;
        if (!(declaration instanceof JSBoundNameOwner) && !(declaration instanceof JSAttributeListOwner)) {
            return null;
        }
        if (declaration.getContext() instanceof JSExportAssignment || JSUseScopeProvider.isExportedAsPartOfParentExport((PsiElement)declaration)) {
            return null;
        }
        if (declaration instanceof JSParameter) {
            if (TypeScriptPsiUtil.isFieldParameter((JSParameter)declaration)) {
                JSAttributeList attributeList2 = ((JSParameter)declaration).getAttributeList();
                if (attributeList2 != null && attributeList2.getAccessType() != JSAttributeList.AccessType.PRIVATE) {
                    return null;
                }
                JSFunction constructorFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)declaration, (Class[])new Class[]{JSFunction.class});
                if (constructorFunction != null) {
                    return JSUseScopeProvider.getLexicalScope(constructorFunction, true, false);
                }
            }
            return JSParameterImpl.getOwner((JSParameterListElement)((Object)declaration));
        }
        if (declaration instanceof JSVariable) {
            if (declaration instanceof ImplicitJSVariableImpl) {
                return declaration.getContext();
            }
            if (((JSVariable)declaration).hasBlockScope()) {
                return ((JSVariable)declaration).getDeclarationScope();
            }
        }
        if (declaration instanceof ES6Class && ((ES6Class)declaration).hasBlockScope()) {
            return JSUseScopeProvider.getBlockScopeElement((PsiElement)declaration);
        }
        PsiElement scopeNode = JSUseScopeProvider.getLexicalScope((PsiElement)declaration, true, false);
        if (scopeNode == null || scopeNode instanceof JSPackageStatement || scopeNode instanceof JSPackage || scopeNode instanceof JSObjectLiteralExpression) {
            return null;
        }
        if (!(scopeNode instanceof JSClass || scopeNode instanceof JSFile || scopeNode instanceof TypeScriptModule || scopeNode instanceof JSEmbeddedContent)) {
            return scopeNode;
        }
        if (DialectDetector.isActionScript(scopeNode)) {
            return JSUseScopeProvider.getUseScopeElementForActionScript(declaration, scopeNode);
        }
        if (scopeNode instanceof JSFile) {
            JSFile jsFile = (JSFile)scopeNode;
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)declaration.getProject());
            if (injectedLanguageManager.isInjectedFragment((PsiFile)jsFile)) {
                JSLiteralExpression literalExpression;
                PsiLanguageInjectionHost host = injectedLanguageManager.getInjectionHost((PsiElement)jsFile);
                if (host instanceof JSLiteralExpression && JSPsiImplUtils.isDynamicJSCode(literalExpression = (JSLiteralExpression)host)) {
                    return scopeNode;
                }
                if (host != null) {
                    scopeNode = host.getContainingFile();
                }
                return scopeNode;
            }
            return jsFile.getModuleStatus().isStrictlyModule() && !ES6ImportHandler.isExportedWithNameOrDefaultOrAssignment((PsiElement)declaration) ? scopeNode : null;
        }
        if (JSUseScopeProvider.isGlobalLexicalScopeElement(scopeNode)) {
            return null;
        }
        if (DialectDetector.isTypeScript((PsiElement)declaration) && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)declaration)) {
            return null;
        }
        if (scopeNode instanceof TypeScriptModule && ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)declaration)) {
            return null;
        }
        if (declaration instanceof JSAttributeListOwner && (attributeList = (attributeListOwner = (JSAttributeListOwner)((Object)declaration)).getAttributeList()) != null && attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return scopeNode;
        }
        return null;
    }

    @Nullable
    private static PsiElement getUseScopeElementForActionScript(@NotNull JSNamedElement declaration, @NotNull PsiElement scopeNode) {
        PsiElement nodeParent;
        PsiLanguageInjectionHost injectionHost;
        if (declaration == null) {
            JSUseScopeProvider.$$$reportNull$$$0(3);
        }
        if (scopeNode == null) {
            JSUseScopeProvider.$$$reportNull$$$0(4);
        }
        if (!(declaration instanceof JSAttributeListOwner)) {
            return null;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)((Object)declaration)).getAttributeList();
        if (JSUseScopeProvider.isGlobalLexicalScopeElement(scopeNode)) {
            return null;
        }
        if (attributeList == null) {
            return null;
        }
        if (scopeNode instanceof JSFile && (injectionHost = InjectedLanguageManager.getInstance((Project)scopeNode.getProject()).getInjectionHost(scopeNode)) instanceof XmlText) {
            scopeNode = injectionHost.getContainingFile();
        }
        if (attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return scopeNode;
        }
        if (attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL && (nodeParent = declaration.getContext()) instanceof JSFile && nodeParent.getContext() == null) {
            return scopeNode;
        }
        return null;
    }

    private static boolean isExportedAsPartOfParentExport(@NotNull PsiElement node) {
        if (node == null) {
            JSUseScopeProvider.$$$reportNull$$$0(5);
        }
        for (PsiElement current = node; current != null && !(current instanceof JSFile) && !(current instanceof JSEmbeddedContent); current = current.getContext()) {
            JSAttributeList attributeList;
            if (current instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)current).getAttributeList()) != null && attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (JSUseScopeProvider.isDirectlyExported(current)) {
                return true;
            }
            if ((!node.equals((Object)current) || !(current instanceof JSProperty)) && !(current instanceof JSObjectLiteralExpression) && (!(current instanceof JSProperty) || current instanceof JSFunctionProperty)) break;
        }
        return false;
    }

    private static boolean isDirectlyExported(@Nullable PsiElement current) {
        return current instanceof JSElementBase && (((JSElementBase)current).isExportedWithDefault() || ((JSElementBase)current).isExported()) || JSUseScopeProvider.isExportStatementSyntaxElement(current);
    }

    private static boolean isExportStatementSyntaxElement(@Nullable PsiElement current) {
        return current instanceof ES6ExportDefaultAssignment || current instanceof ES6ExportDeclaration || current instanceof ES6ExportedDefaultBinding;
    }

    @NotNull
    public static <T extends JSStubElementImpl> SearchScope findUseScope(@NotNull T element) {
        PsiElement xmlFromContext;
        PsiElement scope;
        if (element == null) {
            JSUseScopeProvider.$$$reportNull$$$0(6);
        }
        if (DialectDetector.isActionScript(element)) {
            SearchScope searchScope = ActionScriptUseScopeProvider.findUseScope(element);
            if (searchScope == null) {
                JSUseScopeProvider.$$$reportNull$$$0(7);
            }
            return searchScope;
        }
        if (DialectDetector.isJavaScript(element) && element instanceof JSCachingNamespaceOwner && ((JSCachingNamespaceOwner)((Object)element)).useTypesFromJSDoc() && JSStubBasedPsiTreeUtil.findOwnDocComment(element) != null && element instanceof JSElementBase && !((JSElementBase)((Object)element)).getJSNamespace().isLocal()) {
            SearchScope searchScope = element.getDefaultUseScope();
            if (searchScope == null) {
                JSUseScopeProvider.$$$reportNull$$$0(8);
            }
            return searchScope;
        }
        PsiElement scopeElement = scope = JSUseScopeProvider.getUseScopeElement((JSNamedElement)((Object)element));
        if (scope instanceof JSFile && (xmlFromContext = JSResolveUtil.getClassReferenceForXmlFromContext(scope)) != scope) {
            scope = xmlFromContext;
            scopeElement = scope.getContainingFile();
        }
        if (scope != null) {
            if (scope instanceof JSEmbeddedContent) {
                return new LocalSearchScope((PsiElement)scopeElement.getContainingFile());
            }
            return new LocalSearchScope(scopeElement);
        }
        SearchScope searchScope = element.getDefaultUseScope();
        if (searchScope == null) {
            JSUseScopeProvider.$$$reportNull$$$0(9);
        }
        return searchScope;
    }

    public static boolean isLexicalScopeElement(@NotNull PsiElement element) {
        if (element == null) {
            JSUseScopeProvider.$$$reportNull$$$0(10);
        }
        return element instanceof JSClass || element instanceof JSVariable && (!(element instanceof JSField) || DialectDetector.isActionScript(element)) || element instanceof JSFunctionDeclaration && !JSClassUtils.isClassMember(element) || element instanceof ES6ImportSpecifier || element instanceof ES6ImportSpecifierAlias || element instanceof ES6ImportedBinding || element instanceof TypeScriptModule || element instanceof TypeScriptImportStatement;
    }

    @Nullable
    public static PsiElement getBlockScopeElement(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSUseScopeProvider.$$$reportNull$$$0(11);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)declaration, (Class[])SCOPE_TYPES);
    }

    public static Class<? extends PsiElement>[] getScopeTypes() {
        return (Class[])ArrayUtil.copyOf((Object[])SCOPE_TYPES);
    }

    @Nullable
    public static PsiElement getExecOrClassContext(@NotNull PsiElement element) {
        if (element == null) {
            JSUseScopeProvider.$$$reportNull$$$0(12);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSUseScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSUseScopeProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLexicalScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLexicalScopeOrFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUseScopeElementForActionScript";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExportedAsPartOfParentExport";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUseScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLexicalScopeElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBlockScopeElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExecOrClassContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

