/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.gist.JSCachedDataService;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSDestructuringElementImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSParameterListImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringParameterStub;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDestructuringParameterImpl
extends JSDestructuringElementImpl<JSDestructuringParameterStub<JSDestructuringParameter>>
implements JSDestructuringParameter {
    public JSDestructuringParameterImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringParameterImpl(JSDestructuringParameterStub<JSDestructuringParameter> stub) {
        super(stub, JSElementTypes.DESTRUCTURING_PARAMETER);
    }

    @Override
    @Nullable
    public String getName() {
        JSDestructuringContainer target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.getText();
    }

    @Override
    public boolean isOptional() {
        JSDestructuringParameterStub stub = (JSDestructuringParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isOptional();
        }
        return this.getInitializer() != null || this.getNode().findChildByType(JSTokenTypes.QUEST) != null;
    }

    @Override
    public boolean isRest() {
        JSDestructuringParameterStub parameterStub = (JSDestructuringParameterStub)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isRest();
        }
        return this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
    }

    @Override
    @Nullable
    public JSFunction getDeclaringFunction() {
        JSElement owner = JSParameterImpl.getOwner(this);
        return owner instanceof JSFunction ? (JSFunction)owner : null;
    }

    @Override
    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        return new JSParameterTypeDecoratorImpl(this.getTypeDecoratorName(), this.getJSType(), this.isOptional(), this.isRest(), true);
    }

    @Nullable
    private String getTypeDecoratorName() {
        JSDestructuringContainer target = this.getTarget();
        if (target == null) {
            return this.getName();
        }
        StringBuilder builder = new StringBuilder();
        ES6PsiUtil.buildSignatureForDestructuringContainer(target, builder, false);
        return builder.toString();
    }

    @Override
    @Nullable
    public JSType getInferredType() {
        return this.getJSType();
    }

    @Override
    @Nullable
    public JSType getJSType() {
        String serializedType = JSCachedDataService.getInstance(this.getProject()).getData(this).getSerializedType();
        if (serializedType != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this, true);
            return JSTypeParser.parseSerializedType(this.getProject(), serializedType, source);
        }
        return this.getTypeFromPsi();
    }

    @Nullable
    public static JSType calculateTypeForSerialization(@NotNull JSDestructuringParameterImpl destructuringParameter) {
        JSType typeFromComments;
        JSTypeDeclaration element;
        if (destructuringParameter == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(0);
        }
        if ((element = destructuringParameter.getTypeElement()) != null) {
            return null;
        }
        JSFunction function = destructuringParameter.getDeclaringFunction();
        if (function instanceof JSFunctionBaseImpl && (typeFromComments = ((JSFunctionBaseImpl)function).getTypeFromComments(destructuringParameter)) != null) {
            return typeFromComments;
        }
        JSDestructuringContainer target = destructuringParameter.getTarget();
        if (target != null) {
            return null;
        }
        JSType typeFromInitializer = destructuringParameter.buildTypeFromInitializer();
        if (typeFromInitializer != null) {
            return typeFromInitializer;
        }
        return null;
    }

    @NotNull
    private JSType getTypeFromPsi() {
        JSTypeDeclaration element = this.getTypeElement();
        if (element != null) {
            JSType jSType = element.getJSType();
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(1);
            }
            return jSType;
        }
        JSDestructuringContainer target = this.getTarget();
        if (target != null) {
            return JSDestructuringParameterImpl.buildElement(this, target);
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)this);
        if (jSAnyType == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(2);
        }
        return jSAnyType;
    }

    @Nullable
    public JSElement getDeclarationElement() {
        return this.getTarget();
    }

    @NotNull
    private static JSType buildDestructuringObject(@NotNull JSElement context, @NotNull JSDestructuringObject object) {
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(3);
        }
        if (object == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(4);
        }
        ArrayList<JSRecordType.TypeMember> member = new ArrayList<JSRecordType.TypeMember>();
        for (JSDestructuringProperty property : object.getProperties()) {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            if (property.isRest()) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)property, true);
                JSType stringType = JSNamedTypeFactory.createType("string", source, JSContext.INSTANCE);
                member.add(new IndexSignatureImpl(stringType, (JSType)JSAnyType.get(source), (PsiElement)property, false));
                continue;
            }
            JSInitializerOwner element = property.getDestructuringElement();
            JSType type = JSDestructuringParameterImpl.buildElement(context, element);
            boolean optional = element == null || element.hasOwnInitializer();
            member.add(new PropertySignatureImpl(name, type, optional |= element instanceof JSParameter && ((JSParameter)element).isOptional(), false, (PsiElement)element));
        }
        return new JSSimpleRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)object, true), member);
    }

    @NotNull
    private static JSType buildElement(@NotNull JSElement context, @Nullable JSElement element) {
        JSType elementType;
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(5);
        }
        if (element instanceof JSDestructuringElement) {
            element = ((JSDestructuringElement)element).getTarget();
        }
        if (element instanceof JSDestructuringObject) {
            return JSDestructuringParameterImpl.buildDestructuringObject(context, (JSDestructuringObject)element);
        }
        if (element instanceof JSDestructuringArray) {
            JSType jSType = JSDestructuringParameterImpl.buildDestructuringArray(context, (JSDestructuringArray)element);
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (element instanceof JSParameter && !DialectDetector.isTypeScript((PsiElement)context) && (elementType = ((JSParameter)element).getJSType()) != null) {
            JSType jSType = elementType;
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)context);
        if (jSAnyType == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(8);
        }
        return jSAnyType;
    }

    private static JSType buildDestructuringArray(@NotNull JSElement context, @NotNull JSDestructuringArray element) {
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(9);
        }
        if (element == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(10);
        }
        JSElement[] elements = element.getElementsWithRest();
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)element, true);
        ArrayList<JSType> types = new ArrayList<JSType>(elements.length);
        int firstOptional = -1;
        for (int i = 0; i < elements.length; ++i) {
            JSElement jsElement = elements[i];
            if (jsElement instanceof JSDestructuringArrayRestElement) {
                firstOptional = i;
                types.add(new JSSpreadTypeImpl(source, JSDestructuringParameterImpl.buildElement(context, ((JSDestructuringArrayRestElement)jsElement).getPattern())));
                continue;
            }
            types.add(JSDestructuringParameterImpl.buildElement(context, jsElement));
        }
        JSType type = JSCompositeTypeFactory.createTupleType(source, types, true, firstOptional, true);
        PsiElement parent = element.getParent();
        return parent instanceof JSParameterListElement && ((JSParameterListElement)parent).isRest() ? new JSRestTypeImpl(type, source) : type;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        if (!JSParameterListImpl.handleChildDeletion(this)) {
            super.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringParameter";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromPsi";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateTypeForSerialization";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildDestructuringObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDestructuringArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

