/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 l*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004ijklB\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0014J\r\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eJ\b\u0010\u000f\u001a\u00020\nH\u0014J\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u0016\u001a\u00020\nH\u0014J\b\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0004J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\bH\u0004J\u0012\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0014J\u0012\u0010\u001d\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u001e\u001a\u00020\bJ\u0012\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010!\u001a\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010#\u001a\u00020\nH\u0004J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0014J\u001c\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\u00122\b\u0010)\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\bH\u0004J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u00020\bH\u0004J\u0018\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\b\u00106\u001a\u00020\bH\u0014J\b\u00107\u001a\u00020\nH\u0016J\u0014\u00108\u001a\u00020\b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:J\b\u0010<\u001a\u00020\bH\u0014J\u0012\u0010=\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0014J\u000e\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020&J\b\u0010B\u001a\u00020\bH\u0004J\b\u0010C\u001a\u00020\bH\u0002J\u0012\u0010D\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010I\u001a\u00020\b2\u0006\u0010?\u001a\u00020&H\u0014J\u001e\u0010J\u001a\u00020\b2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020&0L2\u0006\u0010M\u001a\u00020\bH\u0014J\u0016\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020\bJ\b\u0010Q\u001a\u00020\bH\u0014J\u0006\u0010R\u001a\u00020\nJ\b\u0010S\u001a\u00020\nH\u0004J\b\u0010T\u001a\u00020\bH\u0014J\u0006\u0010U\u001a\u00020\nJ\u0010\u0010V\u001a\u00020\b2\u0006\u0010W\u001a\u00020\bH\u0016J\u0010\u0010X\u001a\u00020\b2\u0006\u0010W\u001a\u00020\bH\u0004J\u0010\u0010Y\u001a\u00020\b2\u0006\u0010W\u001a\u00020\bH\u0004J\b\u0010Z\u001a\u00020\bH\u0002J\u0012\u0010[\u001a\u00020\u00122\b\u0010\\\u001a\u0004\u0018\u00010\u0012H\u0014J\u0012\u0010]\u001a\u00020^2\b\u0010_\u001a\u0004\u0018\u00010\u0012H\u0014J\u0018\u0010`\u001a\u00020\u00182\u0006\u0010W\u001a\u00020\b2\u0006\u0010a\u001a\u00020\bH\u0014J\b\u0010b\u001a\u00020\bH\u0014J\b\u0010c\u001a\u00020\bH\u0004J\u0012\u0010d\u001a\u00020\b2\b\b\u0002\u0010W\u001a\u00020\bH\u0007J\u0006\u0010e\u001a\u00020\nJ\b\u0010f\u001a\u00020\nH\u0016J\u000e\u0010f\u001a\u00020\n2\u0006\u0010g\u001a\u00020\bJ\b\u0010h\u001a\u00020\nH\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0016\u0010@\u001a\u0004\u0018\u00010\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00103R\u0014\u0010E\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u00103R\u0014\u0010G\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u00103\u00a8\u0006m"}, d2={"Lcom/intellij/lang/javascript/parsing/ExpressionParser;", "T", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase;", "parser", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "parsePrimaryExpression", "", "parseYieldExpression", "", "parseStringTemplate", "validateLiteral", "", "Lcom/intellij/openapi/util/NlsContexts$ParsingError;", "parseDestructuringProperty", "parseDestructuringElement", "varType", "Lcom/intellij/psi/tree/IElementType;", "parseType", "isOuterParameterElement", "parseDestructuringElementNoMarker", "parseDestructuringArrayElement", "nestedObjectLiterals", "", "parseObjectLiteralExpression", "isDestructuring", "isPropertyStart", "elementType", "isPropertyNameStart", "parsePropertyName", "advancePropertyName", "tokenType", "advanceIdentifier", "currentTokenType", "parseProperty", "parsePropertyNoMarker", "property", "Lcom/intellij/lang/PsiBuilder$Marker;", "canBeIncompleteProperty", "firstToken", "secondToken", "parsePropertyInitializer", "couldHaveComma", "isFunctionPropertyStart", "builder", "Lcom/intellij/lang/PsiBuilder;", "parseFunctionPropertyNoMarker", "skipName", "functionPropertyElementType", "getFunctionPropertyElementType", "()Lcom/intellij/psi/tree/IElementType;", "parseArrayLiteralExpression", "allowSkippingLeadingElements", "parseArrayElement", "parseParenthesizedExpression", "parseLeftHandSideExpression", "options", "", "Lcom/intellij/lang/javascript/parsing/ExpressionParser$ParseLeftHandSideExpressionOptions;", "parseSpecialReference", "isParenAfterReferenceSeparator", "parseImportCall", "expr", "safeAccessOperator", "getSafeAccessOperator", "shouldParseBindExpressions", "hasE4XNamespaceQualifiers", "isReferenceQualifierSeparator", "newExpressionElementType", "getNewExpressionElementType", "nameReferenceElementType", "getNameReferenceElementType", "parseAfterReferenceQualifierSeparator", "parseDialectSpecificMemberExpressionPart", "markerRef", "Lcom/intellij/openapi/util/Ref;", "isInExtendsOrImplementsList", "proceedWithNamespaceReference", "identifier", "expressionContext", "parseNewExpression", "parseArgumentList", "parseArgumentListNoMarker", "parseArgument", "parseExpression", "parseAssignmentExpression", "allowIn", "parseConditionalExpression", "parseBinaryExpression", "parseExponentialExpression", "getBinaryExpressionElementType", "signType", "parseBinaryRightHandSide", "Lcom/intellij/lang/javascript/parsing/ExpressionParser$BinaryParsingState;", "type", "getCurrentBinarySignPriority", "advance", "parseUnaryExpression", "parsePostfixExpression", "parseExpressionOptional", "parseSimpleExpression", "parseScriptExpression", "isEmbeddedToken", "parseTypeInEmbeddedTypeContext", "MarkerData", "BinaryParsingState", "ParseLeftHandSideExpressionOptions", "Companion", "intellij.javascript.parser"})
@SourceDebugExtension(value={"SMAP\nExpressionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionParser.kt\ncom/intellij/lang/javascript/parsing/ExpressionParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1437:1\n1#2:1438\n13#3:1439\n*S KotlinDebug\n*F\n+ 1 ExpressionParser.kt\ncom/intellij/lang/javascript/parsing/ExpressionParser\n*L\n1377#1:1439\n*E\n"})
public class ExpressionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int nestedObjectLiterals;
    @Nullable
    private final IElementType safeAccessOperator;
    @JvmField
    @NotNull
    protected static final Logger LOG;
    @JvmField
    @NotNull
    public static final Key<IElementType> DESTRUCTURING_VAR_TYPE;
    @JvmField
    @NotNull
    protected static final Key<Boolean> ALLOW_PIPE_TOPICS;
    @JvmField
    @NotNull
    protected static final Key<Boolean> HAS_PIPE_TOPICS;
    @JvmField
    @NotNull
    public static final Key<Boolean> PROHIBIT_TOKEN_REMAPPING;
    @NotNull
    private static final JSModifiersStructure FUNCTION_PROPERTY_MODIFIERS;

    public ExpressionParser(@NotNull T parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super(parser);
    }

    public boolean parsePrimaryExpression() {
        boolean bl;
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.THIS_KEYWORD) {
            this.parser.buildTokenElement(JSElementTypes.THIS_EXPRESSION);
            bl = true;
        } else if (firstToken == JSTokenTypes.SUPER_KEYWORD) {
            this.parser.buildTokenElement(JSElementTypes.SUPER_EXPRESSION);
            bl = true;
        } else if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD && this.isJSorTS()) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker classMarker = marker;
            PsiBuilder.Marker marker2 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
            PsiBuilder.Marker modifierList = marker2;
            modifierList.done(this.parser.getFunctionParser().getAttributeListElementType());
            this.parser.getStatementParser().parseClassNoMarker(classMarker, true, true);
            bl = true;
        } else if (this.isIdentifierToken(firstToken) || firstToken == JSTokenTypes.ANY_IDENTIFIER) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker start = marker;
            IElementType elementType = StringUtil.equalsIgnoreCase((CharSequence)"jbIdentifier6b52cc4b", (CharSequence)this.getTokenCharSequence()) ? JSElementTypes.OUTER_LANGUAGE_ELEMENT_EXPRESSION : this.getNameReferenceElementType();
            this.parser.buildTokenElement(elementType);
            if (this.proceedWithNamespaceReference(start, true)) {
                start.precede().done(this.getNameReferenceElementType());
            }
            bl = true;
        } else if (firstToken == JSTokenTypes.NUMERIC_LITERAL || firstToken == JSTokenTypes.STRING_LITERAL || firstToken == JSTokenTypes.REGEXP_LITERAL || firstToken == JSTokenTypes.NULL_KEYWORD || firstToken == JSTokenTypes.UNDEFINED_KEYWORD || firstToken == JSTokenTypes.FALSE_KEYWORD || firstToken == JSTokenTypes.TRUE_KEYWORD) {
            String errorMessage = this.validateLiteral();
            this.parser.buildTokenElement(JSElementTypes.LITERAL_EXPRESSION);
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            bl = true;
        } else if (firstToken == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            bl = true;
        } else if (firstToken == JSTokenTypes.LBRACKET) {
            this.parseArrayLiteralExpression(true, false);
            bl = true;
        } else if (firstToken == JSTokenTypes.LBRACE) {
            this.parseObjectLiteralExpression(false);
            bl = true;
        } else if (firstToken == JSTokenTypes.FUNCTION_KEYWORD) {
            this.parser.getFunctionParser().parseFunctionExpression();
            bl = true;
        } else if (JSTokenTypes.ACCESS_MODIFIERS.contains(firstToken)) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker3 = marker;
            this.builder.advanceLexer();
            if (JSTokenTypes.COLON_COLON == this.builder.getTokenType()) {
                this.builder.advanceLexer();
                if (this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.advanceLexer();
                }
                marker3.done(this.getNameReferenceElementType());
                bl = true;
            } else {
                marker3.drop();
                bl = false;
            }
        } else if (this.parser.getXmlParser().isXmlTagStart(firstToken)) {
            this.parser.getXmlParser().parseTag((Stack<String>)new Stack());
            bl = true;
        } else if (firstToken == JSTokenTypes.AT) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker attrReferenceStartMarker = marker;
            PsiBuilder.Marker marker4 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker4, (String)"mark(...)");
            PsiBuilder.Marker modifierList = marker4;
            this.parser.getFunctionParser().parseES7Decorators();
            modifierList.done(this.parser.getFunctionParser().getAttributeListElementType());
            if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD) {
                this.parser.getStatementParser().parseClassNoMarker(attrReferenceStartMarker, true, true);
            } else {
                attrReferenceStartMarker.drop();
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.class", new Object[0]));
            }
            bl = true;
        } else if (firstToken == JSTokenTypes.INT_KEYWORD || firstToken == JSTokenTypes.UINT_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker5 = marker;
            this.builder.advanceLexer();
            marker5.done(this.getNameReferenceElementType());
            bl = true;
        } else {
            bl = firstToken == JSTokenTypes.BACKQUOTE ? this.parseStringTemplate() : false;
        }
        return bl;
    }

    private final void parseYieldExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.YIELD_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        if (!JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
            if (this.builder.getTokenType() == JSTokenTypes.MULT) {
                this.builder.advanceLexer();
            }
            this.parseAssignmentExpression(true);
        }
        marker2.done(JSElementTypes.YIELD_EXPRESSION);
    }

    protected boolean parseStringTemplate() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BACKQUOTE);
        boolean parsedSomething = false;
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker stringTemplate = marker;
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.BACKQUOTE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                stringTemplate.done(JSElementTypes.STRING_TEMPLATE_EXPRESSION);
                return parsedSomething;
            }
            if (this.builder.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOLLAR) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                    this.builder.advanceLexer();
                    this.parseExpression();
                    JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
                }
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                this.builder.advanceLexer();
            }
            parsedSomething = true;
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.BACKQUOTE, "javascript.parser.message.missing.back.quote");
        stringTemplate.done(JSElementTypes.STRING_TEMPLATE_EXPRESSION);
        return true;
    }

    @Nullable
    public final String validateLiteral() {
        IElementType ttype = this.builder.getTokenType();
        if (ttype == JSTokenTypes.STRING_LITERAL) {
            CharSequence charSequence = this.getTokenCharSequence();
            if (charSequence == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            CharSequence ttext = charSequence;
            return Companion.validateLiteralText(ttext);
        }
        return null;
    }

    protected void parseDestructuringProperty() {
        IElementType nameToken = this.builder.getTokenType();
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker property = marker;
        if (this.isIdentifierToken(nameToken) && this.builder.lookAhead(1) != JSTokenTypes.COLON) {
            this.parseDestructuringElement();
            property.done(JSElementTypes.DESTRUCTURING_SHORTHANDED_PROPERTY);
            return;
        }
        if (!this.parsePropertyName()) {
            this.builder.advanceLexer();
            property.done(JSElementTypes.DESTRUCTURING_PROPERTY);
            return;
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
        IElementType valueFirstToken = this.builder.getTokenType();
        if (valueFirstToken == JSTokenTypes.LBRACE || valueFirstToken == JSTokenTypes.LBRACKET || this.isIdentifierToken(valueFirstToken)) {
            this.parseDestructuringElement();
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.lbrace.or.lbracket", new Object[0]));
        }
        property.done(JSElementTypes.DESTRUCTURING_PROPERTY);
    }

    public final void parseDestructuringElement(@NotNull IElementType varType, boolean parseType, boolean isOuterParameterElement) {
        Intrinsics.checkNotNullParameter((Object)varType, (String)"varType");
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        IElementType elementType = this.parseDestructuringElementNoMarker(varType, parseType, isOuterParameterElement);
        marker2.done(elementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IElementType parseDestructuringElementNoMarker(@NotNull IElementType varType, boolean parseType, boolean isOuterParameterElement) {
        Intrinsics.checkNotNullParameter((Object)varType, (String)"varType");
        IElementType savedDestructuringVarType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
        try {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)varType);
            IElementType iElementType = this.parseDestructuringElementNoMarker(parseType, isOuterParameterElement);
            return iElementType;
        }
        finally {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)savedDestructuringVarType);
        }
    }

    protected void parseDestructuringArrayElement() {
        this.parseDestructuringElement();
    }

    private final void parseDestructuringElement() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        marker2.done(this.parseDestructuringElementNoMarker(false, false));
    }

    @NotNull
    protected final IElementType parseDestructuringElementNoMarker(boolean parseType, boolean isOuterParameterElement) {
        IElementType firstToken = this.builder.getTokenType();
        boolean isSingleNameBinding = false;
        if (this.isIdentifierToken(firstToken)) {
            isSingleNameBinding = true;
            this.builder.advanceLexer();
        } else if (JSTokenTypes.LBRACE == firstToken) {
            this.parseObjectLiteralExpression(true);
        } else if (JSTokenTypes.LBRACKET == firstToken) {
            this.parseArrayLiteralExpression(true, true);
        } else {
            this.builder.advanceLexer();
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
        }
        if (isOuterParameterElement) {
            this.parser.getFunctionParser().parseParameterOptionalMark();
        }
        if (parseType) {
            this.parser.getTypeParser().tryParseType();
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
        }
        IElementType elementType = null;
        if (isSingleNameBinding) {
            elementType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
            v0 = elementType;
            if (v0 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
        } else {
            elementType = isOuterParameterElement ? JSElementTypes.DESTRUCTURING_PARAMETER : JSElementTypes.DESTRUCTURING_ELEMENT;
            v0 = Unit.INSTANCE;
        }
        return elementType;
    }

    protected final void parseObjectLiteralExpression(boolean isDestructuring) {
        int n;
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LBRACE);
        int n2 = this.nestedObjectLiterals;
        this.nestedObjectLiterals = n2 + 1;
        if (this.nestedObjectLiterals > JavaScriptParserBase.MAX_TREE_DEPTH) {
            this.builder.advanceLexer();
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        this.builder.advanceLexer();
        IElementType elementType = this.builder.getTokenType();
        while (elementType != JSTokenTypes.RBRACE && elementType != null) {
            if (elementType == JSTokenTypes.LPAR && this.isECMAL4()) {
                this.parseProperty();
            } else {
                if (!this.isPropertyStart(elementType)) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.string.literal.or.numeric.literal", new Object[0]));
                    break;
                }
                if (isDestructuring) {
                    this.parseDestructuringProperty();
                } else {
                    this.parseProperty();
                }
            }
            while (this.nestedObjectLiterals > JavaScriptParserBase.MAX_TREE_DEPTH && this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                n = this.nestedObjectLiterals;
                this.nestedObjectLiterals = n + -1;
                this.builder.advanceLexer();
            }
            boolean wasCommaBefore = false;
            elementType = this.builder.getTokenType();
            if (elementType == JSTokenTypes.RBRACE) break;
            if (elementType == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                wasCommaBefore = true;
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma", new Object[0]));
                if (elementType == JSTokenTypes.SEMICOLON) {
                    this.builder.advanceLexer();
                    wasCommaBefore = true;
                }
            }
            elementType = this.builder.getTokenType();
            if (elementType == JSTokenTypes.RBRACE) {
                if (wasCommaBefore) break;
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.property.expected", new Object[0]));
                continue;
            }
            if (this.isPropertyStart(elementType)) continue;
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        expr.done(isDestructuring ? JSElementTypes.DESTRUCTURING_OBJECT : JSElementTypes.OBJECT_LITERAL_EXPRESSION);
        n = this.nestedObjectLiterals;
        this.nestedObjectLiterals = n + -1;
    }

    protected boolean isPropertyStart(@Nullable IElementType elementType) {
        return this.isPropertyNameStart(elementType) || elementType == JSTokenTypes.DOT || elementType == JSTokenTypes.DOT_DOT || elementType == JSTokenTypes.DOT_DOT_DOT;
    }

    public boolean isPropertyNameStart(@Nullable IElementType elementType) {
        return JSKeywordSets.PROPERTY_NAMES.contains(elementType) || elementType == JSTokenTypes.LBRACKET;
    }

    public final boolean parsePropertyName() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.LBRACKET) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker computedPropertyMarker = marker;
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
            JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
            computedPropertyMarker.done(JSElementTypes.COMPUTED_NAME);
            return true;
        }
        if (JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            this.advancePropertyName(tokenType);
            return true;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
        return false;
    }

    public void advancePropertyName(@Nullable IElementType tokenType) {
        if (!JSKeywordSets.NON_IDENTIFIER_PROPERTY_NAMES.contains(tokenType)) {
            this.advanceIdentifier(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    private final void advanceIdentifier(IElementType currentTokenType) {
        if (!Intrinsics.areEqual((Object)this.builder.getUserData(PROHIBIT_TOKEN_REMAPPING), (Object)true) && currentTokenType != JSTokenTypes.IDENTIFIER && currentTokenType != JSTokenTypes.PRIVATE_IDENTIFIER) {
            this.builder.remapCurrentTokenAndRestoreOnRollback(JSTokenTypes.IDENTIFIER);
        }
        this.builder.advanceLexer();
    }

    protected final void parseProperty() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        if (!this.parsePropertyNoMarker(mark)) {
            mark.drop();
        }
    }

    protected boolean parsePropertyNoMarker(@NotNull PsiBuilder.Marker property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        IElementType firstToken = this.builder.getTokenType();
        IElementType secondToken = this.builder.lookAhead(1);
        if (firstToken == JSTokenTypes.LBRACKET) {
            boolean lexerAdvanced = this.parsePropertyName();
            if (_Assertions.ENABLED && !lexerAdvanced) {
                boolean bl = false;
                String string = "must be advanced after LBRACKET";
                throw new AssertionError((Object)string);
            }
            if (this.builder.getTokenType() == JSTokenTypes.LPAR || this.builder.getTokenType() == JSTokenTypes.LT) {
                this.parseFunctionPropertyNoMarker(property, true);
            } else {
                this.parsePropertyInitializer(false);
                property.done(JSElementTypes.PROPERTY);
            }
            return true;
        }
        if (this.parseFunctionPropertyNoMarker(property, false)) {
            return true;
        }
        if (this.parser.isIdentifierName(firstToken) && (secondToken == JSTokenTypes.COMMA || secondToken == JSTokenTypes.RBRACE || this.canBeIncompleteProperty(firstToken, secondToken))) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker ref = marker;
            this.builder.advanceLexer();
            ref.done(this.getNameReferenceElementType());
            property.done(JSElementTypes.PROPERTY);
            return true;
        }
        if (this.parser.isIdentifierName(firstToken) && secondToken == JSTokenTypes.EQ) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker ref = marker;
            this.builder.advanceLexer();
            ref.done(this.getNameReferenceElementType());
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
            property.done(JSElementTypes.PROPERTY);
            return true;
        }
        if (firstToken == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
            property.done(JSElementTypes.SPREAD_EXPRESSION);
            return true;
        }
        if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            String errorMessage = this.validateLiteral();
            this.advancePropertyName(firstToken);
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
            this.builder.advanceLexer();
        }
        this.parsePropertyInitializer(JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken));
        property.done(JSElementTypes.PROPERTY);
        property.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    protected boolean canBeIncompleteProperty(@Nullable IElementType firstToken, @Nullable IElementType secondToken) {
        if (!JavaScriptParserBase.Companion.hasLineTerminatorAfter(this.builder)) {
            return false;
        }
        return this.isPropertyNameStart(firstToken) && secondToken != JSTokenTypes.COLON && secondToken != JSTokenTypes.EQ;
    }

    protected final void parsePropertyInitializer(boolean couldHaveComma) {
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COLON, couldHaveComma ? "javascript.parser.message.expected.colon.or.comma" : "javascript.parser.message.expected.colon") && JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
            return;
        }
        if (!this.parseAssignmentExpression(true)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    protected boolean isFunctionPropertyStart(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        IElementType firstToken = builder.getTokenType();
        return JSKeywordSets.PROPERTY_NAMES.contains(firstToken) && builder.lookAhead(1) == JSTokenTypes.LPAR || firstToken == JSTokenTypes.LBRACKET;
    }

    protected final boolean parseFunctionPropertyNoMarker(@NotNull PsiBuilder.Marker property, boolean skipName) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        boolean lexerAdvanced = false;
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiers = EnumSet.noneOf(JSModifiersStructure.JSModifiersParseResult.class);
        if (!skipName) {
            modifiers = this.parser.parseModifiers(FUNCTION_PROPERTY_MODIFIERS, true, arg_0 -> ExpressionParser.parseFunctionPropertyNoMarker$lambda$0((Function1)new Function1<PsiBuilder, Boolean>((Object)this){

                public final Boolean invoke(PsiBuilder p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ExpressionParser)this.receiver).isFunctionPropertyStart(p0);
                }
            }, arg_0));
            lexerAdvanced = modifiers.contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            if (!lexerAdvanced && !this.isFunctionPropertyStart(this.builder)) {
                IElementType tokenType = this.builder.getTokenType();
                if ((tokenType == JSTokenTypes.ASYNC_KEYWORD || tokenType == JSTokenTypes.GET_KEYWORD || tokenType == JSTokenTypes.SET_KEYWORD || tokenType == JSTokenTypes.MULT) && JSKeywordSets.PROPERTY_NAMES.contains(this.builder.lookAhead(1))) {
                    this.parser.getFunctionParser().parseFunctionExpressionAttributeList();
                } else {
                    return false;
                }
            }
            lexerAdvanced |= this.parsePropertyName();
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = modifiers;
        Intrinsics.checkNotNull(enumSet);
        EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(enumSet, this.builder);
        JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        if (!(lexerAdvanced |= this.parser.getFunctionParser().parseParameterListAndBody(property, this.getFunctionPropertyElementType()))) {
            this.builder.advanceLexer();
        }
        return true;
    }

    @NotNull
    protected IElementType getFunctionPropertyElementType() {
        return JSElementTypes.FUNCTION_PROPERTY;
    }

    private final void parseArrayLiteralExpression(boolean allowSkippingLeadingElements, boolean isDestructuring) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LBRACKET);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        boolean commaExpected = false;
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET && !this.builder.eof()) {
            if (commaExpected) {
                JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma");
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                if (!allowSkippingLeadingElements) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    PsiBuilder.Marker emptyMark;
                    Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
                    emptyMark.done(JSElementTypes.EMPTY_EXPRESSION);
                    this.builder.advanceLexer();
                }
            }
            commaExpected = false;
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) continue;
            if (isDestructuring) {
                this.parseDestructuringArrayElement();
            } else if (!this.parseArrayElement()) break;
            commaExpected = true;
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
        marker2.done(isDestructuring ? JSElementTypes.DESTRUCTURING_ARRAY : JSElementTypes.ARRAY_LITERAL_EXPRESSION);
    }

    protected boolean parseArrayElement() {
        if (!this.parseAssignmentExpression(true)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            return false;
        }
        return true;
    }

    public void parseParenthesizedExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        this.builder.advanceLexer();
        if (!this.parseExpressionOptional(true)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        expr.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
    }

    public final boolean parseLeftHandSideExpression(@NotNull Set<? extends ParseLeftHandSideExpressionOptions> options) {
        IElementType tokenType;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        IElementType type = this.builder.getTokenType();
        boolean isNew = false;
        if (type == JSTokenTypes.SHARP && Intrinsics.areEqual((Object)this.builder.getUserData(ALLOW_PIPE_TOPICS), (Object)true)) {
            this.builder.advanceLexer();
            expr.done(JSElementTypes.EMPTY_EXPRESSION);
            PsiBuilder.Marker marker2 = expr.precede();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"precede(...)");
            expr = marker2;
            isNew = false;
            this.builder.putUserData(HAS_PIPE_TOPICS, (Object)true);
        } else if (type == JSTokenTypes.NEW_KEYWORD) {
            isNew = this.parseNewExpression();
        } else if (type == JSTokenTypes.COLON_COLON && this.shouldParseBindExpressions()) {
            this.builder.advanceLexer();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            this.parseLeftHandSideExpression((Set<ParseLeftHandSideExpressionOptions>)enumSet);
            expr.done(JSElementTypes.BIND_EXPRESSION);
            PsiBuilder.Marker marker3 = expr.precede();
            Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"precede(...)");
            expr = marker3;
            isNew = false;
        } else if (type == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.LPAR) {
            this.parseImportCall(expr);
            PsiBuilder.Marker marker4 = expr.precede();
            Intrinsics.checkNotNullExpressionValue((Object)marker4, (String)"precede(...)");
            expr = marker4;
            isNew = false;
        } else if (type == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.DOT && this.builder.lookAhead(2) == JSTokenTypes.IDENTIFIER) {
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            CharSequence propertyName = this.getTokenCharSequence();
            if (!(StringUtil.equals((CharSequence)"meta", (CharSequence)propertyName) || StringUtil.equals((CharSequence)"defer", (CharSequence)propertyName) || StringUtil.equals((CharSequence)"source", (CharSequence)propertyName))) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.meta", new Object[0]));
            }
            this.builder.advanceLexer();
            expr.done(JSElementTypes.META_PROPERTY);
            PsiBuilder.Marker marker5 = expr.precede();
            Intrinsics.checkNotNullExpressionValue((Object)marker5, (String)"precede(...)");
            expr = marker5;
            isNew = false;
        } else {
            isNew = false;
            if (this.parseSpecialReference()) {
                expr.done(this.getNameReferenceElementType());
                PsiBuilder.Marker marker6 = expr.precede();
                Intrinsics.checkNotNullExpressionValue((Object)marker6, (String)"precede(...)");
                expr = marker6;
            } else if (!this.parsePrimaryExpression()) {
                expr.drop();
                return false;
            }
        }
        while (true) {
            tokenType = this.builder.getTokenType();
            boolean parsedSuccessfully = true;
            IElementType safeAccessOperator = this.getSafeAccessOperator();
            if (this.isReferenceQualifierSeparator(tokenType)) {
                IElementType separatorType = tokenType;
                this.builder.advanceLexer();
                boolean hasAt = false;
                if (this.builder.getTokenType() == JSTokenTypes.AT) {
                    hasAt = true;
                    if (this.parseSpecialReference()) {
                        expr.done(this.getNameReferenceElementType());
                        Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
                        continue;
                    }
                    this.builder.advanceLexer();
                }
                if ((tokenType = this.builder.getTokenType()) == JSTokenTypes.LBRACKET && hasAt && this.parser.getDialect().hasE4XStandard()) continue;
                if (this.parseAfterReferenceQualifierSeparator(expr)) {
                    Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
                    continue;
                }
                if (tokenType == JSTokenTypes.ANY_IDENTIFIER || this.parser.isIdentifierName(tokenType)) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
                        identifier.done(this.getNameReferenceElementType());
                        PsiBuilder.Marker marker7 = identifier.precede();
                        Intrinsics.checkNotNullExpressionValue((Object)marker7, (String)"precede(...)");
                        this.proceedWithNamespaceReference(marker7, true);
                    } else {
                        identifier.drop();
                    }
                } else {
                    if (separatorType != null && separatorType == safeAccessOperator && (this.isParenAfterReferenceSeparator(tokenType) || tokenType == JSTokenTypes.LBRACKET)) continue;
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
                }
                expr.done(this.getNameReferenceElementType());
                Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
            } else if (!options.contains((Object)ParseLeftHandSideExpressionOptions.DISALLOW_INDEXER) && tokenType == JSTokenTypes.LBRACKET) {
                this.builder.advanceLexer();
                this.parseExpression();
                JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
                expr.done(JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION);
                Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
            } else if (!options.contains((Object)ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION) && tokenType == JSTokenTypes.LPAR) {
                this.parseArgumentList();
                expr.done(isNew ? this.getNewExpressionElementType() : JSElementTypes.CALL_EXPRESSION);
                Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
                isNew = false;
            } else if (tokenType == JSTokenTypes.BACKQUOTE) {
                this.parseStringTemplate();
                expr.done(JSElementTypes.TAGGED_TEMPLATE_EXPRESSION);
                Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
            } else if (tokenType == JSTokenTypes.COLON_COLON && !options.contains((Object)ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION) && this.shouldParseBindExpressions()) {
                if (isNew) {
                    expr.done(this.getNewExpressionElementType());
                    PsiBuilder.Marker marker8 = expr.precede();
                    Intrinsics.checkNotNullExpressionValue((Object)marker8, (String)"precede(...)");
                    expr = marker8;
                    isNew = false;
                }
                this.builder.advanceLexer();
                EnumSet<Enum> enumSet = EnumSet.of((Enum)ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
                if (!this.parseLeftHandSideExpression((Set<ParseLeftHandSideExpressionOptions>)enumSet)) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                expr.done(JSElementTypes.BIND_EXPRESSION);
                Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
            } else {
                Ref ref = Ref.create((Object)expr);
                Intrinsics.checkNotNull((Object)ref);
                parsedSuccessfully = this.parseDialectSpecificMemberExpressionPart((Ref<PsiBuilder.Marker>)ref, options.contains((Object)ParseLeftHandSideExpressionOptions.IS_IN_EXTENDS_OR_IMPLEMENTS_LIST));
                if (parsedSuccessfully) {
                    Object object = ref.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    expr = (PsiBuilder.Marker)object;
                }
            }
            if (!parsedSuccessfully) break;
        }
        if (isNew) {
            if (tokenType == JSTokenTypes.LT && this.isECMAL4()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.dot", new Object[0]));
            }
            expr.done(this.getNewExpressionElementType());
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseSpecialReference() {
        return false;
    }

    protected boolean isParenAfterReferenceSeparator(@Nullable IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR;
    }

    public final void parseImportCall(@NotNull PsiBuilder.Marker expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        this.parseAssignmentExpression(false);
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.RPAR) {
                this.parseAssignmentExpression(false);
                if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        expr.done(JSElementTypes.IMPORT_CALL);
    }

    @Nullable
    protected IElementType getSafeAccessOperator() {
        return this.safeAccessOperator;
    }

    protected final boolean shouldParseBindExpressions() {
        return !this.parser.getDialect().hasFeature(JSLanguageFeature.REFERENCE_NAMESPACE);
    }

    private final boolean hasE4XNamespaceQualifiers() {
        DialectOptionHolder dialect = this.parser.getDialect();
        return dialect.hasFeature(JSLanguageFeature.E4X) && !dialect.hasFeature(JSLanguageFeature.BIND_EXPRESSIONS);
    }

    protected boolean isReferenceQualifierSeparator(@Nullable IElementType tokenType) {
        return tokenType == JSTokenTypes.DOT || tokenType == JSTokenTypes.COLON_COLON && this.hasE4XNamespaceQualifiers() || tokenType == JSTokenTypes.DOT_DOT && this.hasE4XNamespaceQualifiers();
    }

    @NotNull
    protected IElementType getNewExpressionElementType() {
        return JSElementTypes.NEW_EXPRESSION;
    }

    @NotNull
    protected IElementType getNameReferenceElementType() {
        return JSElementTypes.REFERENCE_EXPRESSION;
    }

    protected boolean parseAfterReferenceQualifierSeparator(@NotNull PsiBuilder.Marker expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        return false;
    }

    protected boolean parseDialectSpecificMemberExpressionPart(@NotNull Ref<PsiBuilder.Marker> markerRef, boolean isInExtendsOrImplementsList) {
        Intrinsics.checkNotNullParameter(markerRef, (String)"markerRef");
        return false;
    }

    public final boolean proceedWithNamespaceReference(@NotNull PsiBuilder.Marker identifier, boolean expressionContext) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON && this.hasE4XNamespaceQualifiers()) {
            this.builder.advanceLexer();
            identifier.done(JSElementTypes.E4X_NAMESPACE_REFERENCE);
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType != JSTokenTypes.ANY_IDENTIFIER && !this.isIdentifierToken(tokenType)) {
                if (!expressionContext || tokenType != JSTokenTypes.LBRACKET) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
                }
            } else {
                this.builder.advanceLexer();
            }
            return true;
        }
        identifier.drop();
        return false;
    }

    protected boolean parseNewExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            this.builder.advanceLexer();
            this.parser.getFunctionParser().parseFunctionExpression();
            marker2.done(this.getNewExpressionElementType());
            return false;
        }
        this.builder.advanceLexer();
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.LT && this.isECMAL4()) {
            this.parser.getTypeParser().parseECMA4GenericSignature();
            if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                this.parseArrayLiteralExpression(false, false);
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbracket", new Object[0]));
            }
            return true;
        }
        EnumSet<Enum> enumSet = EnumSet.of((Enum)ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        if (!this.parseLeftHandSideExpression((Set<ParseLeftHandSideExpressionOptions>)enumSet)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
                break;
            }
            this.builder.advanceLexer();
        }
        return true;
    }

    public final void parseArgumentList() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker arglist = marker;
        this.parseArgumentListNoMarker();
        arglist.done(JSElementTypes.ARGUMENT_LIST);
    }

    protected final void parseArgumentListNoMarker() {
        this.builder.advanceLexer();
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.parser.getFunctionParser().allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma.or.rparen", new Object[0]));
                break;
            }
            if (this.parseArgument()) continue;
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
    }

    protected boolean parseArgument() {
        return this.parseAssignmentExpression(true);
    }

    public final void parseExpression() {
        if (!ExpressionParser.parseExpressionOptional$default(this, false, 1, null)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    public boolean parseAssignmentExpression(boolean allowIn) {
        if (this.builder.getTokenType() == JSTokenTypes.YIELD_KEYWORD && (JSParsingContextUtil.isGeneratorContext(this.builder) || ExpressionParser.Companion.isDefinitelyYieldExpression(this.builder.lookAhead(1)))) {
            this.parseYieldExpression();
            return true;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        if (JSElementTypes.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSElementTypes.ASSIGNMENT_EXPRESSION);
            return true;
        }
        PsiBuilder.Marker marker2 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker definitionExpr = marker2;
        if (!this.parseConditionalExpression(allowIn)) {
            definitionExpr.drop();
            expr.drop();
            return false;
        }
        if (JSElementTypes.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType())) {
            definitionExpr.done(JSElementTypes.DEFINITION_EXPRESSION);
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSElementTypes.ASSIGNMENT_EXPRESSION);
        } else {
            definitionExpr.drop();
            expr.drop();
        }
        return true;
    }

    protected final boolean parseConditionalExpression(boolean allowIn) {
        IElementType nextTokenType;
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        if (!this.parseBinaryExpression(allowIn)) {
            if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            } else {
                expr.drop();
                return false;
            }
        }
        if ((nextTokenType = this.builder.getTokenType()) == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    protected final boolean parseBinaryExpression(boolean allowIn) {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker currentMarker = marker;
        if (!this.parseExponentialExpression()) {
            currentMarker.drop();
            return false;
        }
        if (this.getCurrentBinarySignPriority(allowIn, false) < 0) {
            currentMarker.drop();
            return true;
        }
        int depth = 0;
        Deque markers = new ArrayDeque();
        int priority = 0;
        boolean tempStop = false;
        while (true) {
            BinaryParsingState parsingState;
            boolean depthExceeded;
            int n;
            int it = n = this.getCurrentBinarySignPriority(allowIn, false);
            boolean bl = false;
            priority = it;
            if (n < 0) break;
            IElementType type = this.builder.getTokenType();
            IElementType elementType = this.getBinaryExpressionElementType(type);
            boolean bl2 = depthExceeded = depth >= JavaScriptParserBase.MAX_TREE_DEPTH;
            if (!(depthExceeded || markers.isEmpty() || ((MarkerData)markers.peek()).getPriority() < priority && !tempStop)) {
                int lastPriority;
                currentMarker.drop();
                PsiBuilder.Marker lastPoppedMarker = null;
                while (!markers.isEmpty() && ((MarkerData)markers.peek()).getPriority() > priority) {
                    MarkerData markerData = (MarkerData)markers.pop();
                    lastPoppedMarker = markerData.getMarker();
                    lastPoppedMarker.done(markerData.getElementType());
                }
                int n2 = lastPriority = markers.isEmpty() ? -1 : ((MarkerData)markers.peek()).getPriority();
                if (lastPriority == priority || tempStop && !markers.isEmpty()) {
                    PsiBuilder.Marker precede;
                    MarkerData markerData2 = (MarkerData)markers.pop();
                    PsiBuilder.Marker lastMarker = markerData2.getMarker();
                    lastMarker.done(markerData2.getElementType());
                    Intrinsics.checkNotNullExpressionValue((Object)lastMarker.precede(), (String)"precede(...)");
                    markers.push(new MarkerData(priority, precede, elementType));
                } else {
                    PsiBuilder.Marker precede;
                    boolean markerData2;
                    boolean bl3 = markerData2 = lastPriority < priority;
                    if (_Assertions.ENABLED && !markerData2) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    if (lastPoppedMarker == null) {
                        String markerData2 = "Required value was null.";
                        throw new IllegalStateException(markerData2.toString());
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)lastPoppedMarker.precede(), (String)"precede(...)");
                    markers.push(new MarkerData(priority, precede, elementType));
                }
            } else if (!depthExceeded) {
                markers.push(new MarkerData(priority, currentMarker, elementType));
            }
            tempStop = false;
            this.getCurrentBinarySignPriority(allowIn, true);
            if (!depthExceeded) {
                Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
            }
            if (type == JSTokenTypes.PIPE) {
                this.builder.putUserData(ALLOW_PIPE_TOPICS, (Object)true);
                this.builder.putUserData(HAS_PIPE_TOPICS, (Object)false);
            }
            if ((parsingState = this.parseBinaryRightHandSide(type)) == BinaryParsingState.FAIL || parsingState == BinaryParsingState.FAIL_AND_STOP) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            if (parsingState == BinaryParsingState.STOP || parsingState == BinaryParsingState.FAIL_AND_STOP) {
                tempStop = true;
            }
            ++depth;
        }
        currentMarker.drop();
        while (!markers.isEmpty()) {
            MarkerData markerData = (MarkerData)markers.pop();
            IElementType elementType = markerData.getElementType();
            markerData.getMarker().done(elementType);
            if (elementType != JSElementTypes.PIPE_EXPRESSION) continue;
            this.builder.putUserData(ALLOW_PIPE_TOPICS, (Object)false);
        }
        return true;
    }

    private final boolean parseExponentialExpression() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        boolean result = this.parseUnaryExpression();
        if (this.builder.getTokenType() == JSTokenTypes.MULTMULT) {
            this.builder.advanceLexer();
            result = this.parseExponentialExpression();
            marker2.done(JSElementTypes.BINARY_EXPRESSION);
        } else {
            marker2.drop();
        }
        return result;
    }

    @NotNull
    protected IElementType getBinaryExpressionElementType(@Nullable IElementType signType) {
        if (signType == JSTokenTypes.PIPE) {
            return JSElementTypes.PIPE_EXPRESSION;
        }
        return JSElementTypes.BINARY_EXPRESSION;
    }

    @NotNull
    protected BinaryParsingState parseBinaryRightHandSide(@Nullable IElementType type) {
        return this.parseExponentialExpression() ? BinaryParsingState.OK : BinaryParsingState.FAIL;
    }

    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int result;
        IElementType tokenType = this.builder.getTokenType();
        int n = tokenType == JSTokenTypes.OROR || tokenType == JSTokenTypes.QUEST_QUEST ? 0 : (tokenType == JSTokenTypes.ANDAND ? 1 : (tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.PIPE ? 2 : (tokenType == JSTokenTypes.XOR ? 3 : (tokenType == JSTokenTypes.AND ? 4 : (JSTokenTypes.EQUALITY_OPERATIONS.contains(tokenType) ? 5 : (JSTokenTypes.RELATIONAL_OPERATIONS.contains(tokenType) && (allowIn || this.builder.getTokenType() != JSTokenTypes.IN_KEYWORD) ? 6 : (JSTokenTypes.SHIFT_OPERATIONS.contains(tokenType) ? 7 : (JSTokenTypes.ADDITIVE_OPERATIONS.contains(tokenType) ? 8 : (result = JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(tokenType) ? 9 : -1)))))))));
        if (advance && result >= 0) {
            this.builder.advanceLexer();
        }
        return result;
    }

    protected boolean parseUnaryExpression() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker expr = marker;
            this.builder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parsePostfixExpression();
    }

    protected final boolean parsePostfixExpression() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        EnumSet<ParseLeftHandSideExpressionOptions> enumSet = EnumSet.noneOf(ParseLeftHandSideExpressionOptions.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        if (!this.parseLeftHandSideExpression((Set<ParseLeftHandSideExpressionOptions>)enumSet)) {
            expr.drop();
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(tokenType != JSTokenTypes.PLUSPLUS && tokenType != JSTokenTypes.MINUSMINUS || JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder))) {
            this.builder.advanceLexer();
            expr.done(JSElementTypes.POSTFIX_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    @JvmOverloads
    public final boolean parseExpressionOptional(boolean allowIn) {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        if (!this.parseAssignmentExpression(allowIn)) {
            expr.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD) {
            expr.done(JSElementTypes.DEFINITION_EXPRESSION);
            return true;
        }
        int nestingLevel = 0;
        while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            if (nestingLevel < JavaScriptParserBase.MAX_TREE_DEPTH) {
                expr.done(JSElementTypes.COMMA_EXPRESSION);
                Intrinsics.checkNotNullExpressionValue((Object)expr.precede(), (String)"precede(...)");
            }
            ++nestingLevel;
        }
        expr.drop();
        return true;
    }

    public static /* synthetic */ boolean parseExpressionOptional$default(ExpressionParser expressionParser, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseExpressionOptional");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return expressionParser.parseExpressionOptional(bl);
    }

    public final void parseSimpleExpression() {
        if (!this.parseUnaryExpression()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    public void parseScriptExpression() {
        this.parseScriptExpression(true);
    }

    public final void parseScriptExpression(boolean isEmbeddedToken) {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker root = marker;
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.XML_LBRACE, "javascript.parser.message.expected.lbrace");
        DialectOptionHolder dialect = this.parser.getDialect();
        if (dialect == DialectOptionHolder.ECMA_4) {
            this.parseExpression();
        } else {
            this.parseArgument();
        }
        if (isEmbeddedToken) {
            JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.XML_RBRACE, "javascript.parser.message.expected.rbrace");
            while (!this.builder.eof()) {
                this.builder.advanceLexer();
            }
        } else if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.XML_RBRACE, "javascript.parser.message.expected.rbrace")) {
            while (!this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                this.builder.advanceLexer();
                if (tokenType != JSTokenTypes.XML_RBRACE) continue;
            }
        }
        root.done(JSElementTypes.EMBEDDED_EXPRESSION);
    }

    public void parseTypeInEmbeddedTypeContext() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker root = marker;
        this.parser.getTypeParser().parseType();
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        root.done(JSElementTypes.EMBEDDED_EXPRESSION);
    }

    @JvmOverloads
    public final boolean parseExpressionOptional() {
        return ExpressionParser.parseExpressionOptional$default(this, false, 1, null);
    }

    private static final boolean parseFunctionPropertyNoMarker$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @Nullable
    public static final String validateLiteralText(@NotNull CharSequence text) {
        return Companion.validateLiteralText(text);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExpressionParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"within.destructuring.expression");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DESTRUCTURING_VAR_TYPE = key;
        Key key2 = Key.create((String)"allow.pipe.topics");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        ALLOW_PIPE_TOPICS = key2;
        Key key3 = Key.create((String)"has.pipe.topics");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        HAS_PIPE_TOPICS = key3;
        Key key4 = Key.create((String)"no.token.remapping");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"create(...)");
        PROHIBIT_TOKEN_REMAPPING = key4;
        JSModifiersStructure[] jSModifiersStructureArray = new JSModifiersStructure[3];
        jSModifiersStructureArray[0] = new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD, false, 2, null);
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD};
        jSModifiersStructureArray[1] = new JSOneOfModifiersStructure(iElementTypeArray);
        jSModifiersStructureArray[2] = new JSModifiersStructureLeaf(JSTokenTypes.MULT, false, 2, null);
        FUNCTION_PROPERTY_MODIFIERS = new JSOrderedModifiersStructure(jSModifiersStructureArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/parsing/ExpressionParser$BinaryParsingState;", "", "<init>", "(Ljava/lang/String;I)V", "FAIL", "OK", "STOP", "FAIL_AND_STOP", "intellij.javascript.parser"})
    protected static final class BinaryParsingState
    extends Enum<BinaryParsingState> {
        public static final /* enum */ BinaryParsingState FAIL = new BinaryParsingState();
        public static final /* enum */ BinaryParsingState OK = new BinaryParsingState();
        public static final /* enum */ BinaryParsingState STOP = new BinaryParsingState();
        public static final /* enum */ BinaryParsingState FAIL_AND_STOP = new BinaryParsingState();
        private static final /* synthetic */ BinaryParsingState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BinaryParsingState[] values() {
            return (BinaryParsingState[])$VALUES.clone();
        }

        public static BinaryParsingState valueOf(String value) {
            return Enum.valueOf(BinaryParsingState.class, value);
        }

        @NotNull
        public static EnumEntries<BinaryParsingState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = binaryParsingStateArray = new BinaryParsingState[]{BinaryParsingState.FAIL, BinaryParsingState.OK, BinaryParsingState.STOP, BinaryParsingState.FAIL_AND_STOP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/parsing/ExpressionParser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DESTRUCTURING_VAR_TYPE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/tree/IElementType;", "ALLOW_PIPE_TOPICS", "", "HAS_PIPE_TOPICS", "PROHIBIT_TOKEN_REMAPPING", "FUNCTION_PROPERTY_MODIFIERS", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure;", "validateLiteralText", "", "Lcom/intellij/openapi/util/NlsContexts$ParsingError;", "text", "", "lastSymbolEscaped", "isDefinitelyYieldExpression", "tokenType", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String validateLiteralText(@NotNull CharSequence text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (this.lastSymbolEscaped(text) || StringsKt.startsWith$default((CharSequence)text, (CharSequence)"\"", (boolean)false, (int)2, null) && (!StringsKt.endsWith$default((CharSequence)text, (CharSequence)"\"", (boolean)false, (int)2, null) || text.length() == 1) || StringsKt.startsWith$default((CharSequence)text, (CharSequence)"'", (boolean)false, (int)2, null) && (!StringsKt.endsWith$default((CharSequence)text, (CharSequence)"'", (boolean)false, (int)2, null) || text.length() == 1)) {
                return JavaScriptParserBundle.message("javascript.parser.message.unclosed.string.literal", new Object[0]);
            }
            return null;
        }

        private final boolean lastSymbolEscaped(CharSequence text) {
            boolean escapes = false;
            boolean escaped = true;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (escapes) {
                    escapes = false;
                    escaped = true;
                    continue;
                }
                if (c == '\\') {
                    escapes = true;
                }
                escaped = false;
            }
            return escapes || escaped;
        }

        private final boolean isDefinitelyYieldExpression(IElementType tokenType) {
            return JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType) || JSTokenTypes.LITERALS.contains(tokenType) || tokenType == JSTokenTypes.LBRACE || tokenType == JSTokenTypes.LBRACKET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/parsing/ExpressionParser$MarkerData;", "", "priority", "", "marker", "Lcom/intellij/lang/PsiBuilder$Marker;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(ILcom/intellij/lang/PsiBuilder$Marker;Lcom/intellij/psi/tree/IElementType;)V", "getPriority", "()I", "getMarker", "()Lcom/intellij/lang/PsiBuilder$Marker;", "getElementType", "()Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.parser"})
    private static final class MarkerData {
        private final int priority;
        @NotNull
        private final PsiBuilder.Marker marker;
        @NotNull
        private final IElementType elementType;

        public MarkerData(int priority, @NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            this.priority = priority;
            this.marker = marker;
            this.elementType = elementType;
        }

        public final int getPriority() {
            return this.priority;
        }

        @NotNull
        public final PsiBuilder.Marker getMarker() {
            return this.marker;
        }

        @NotNull
        public final IElementType getElementType() {
            return this.elementType;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/parsing/ExpressionParser$ParseLeftHandSideExpressionOptions;", "", "<init>", "(Ljava/lang/String;I)V", "ONLY_MEMBER_EXPRESSION", "DISALLOW_INDEXER", "IS_IN_EXTENDS_OR_IMPLEMENTS_LIST", "intellij.javascript.parser"})
    public static final class ParseLeftHandSideExpressionOptions
    extends Enum<ParseLeftHandSideExpressionOptions> {
        public static final /* enum */ ParseLeftHandSideExpressionOptions ONLY_MEMBER_EXPRESSION = new ParseLeftHandSideExpressionOptions();
        public static final /* enum */ ParseLeftHandSideExpressionOptions DISALLOW_INDEXER = new ParseLeftHandSideExpressionOptions();
        public static final /* enum */ ParseLeftHandSideExpressionOptions IS_IN_EXTENDS_OR_IMPLEMENTS_LIST = new ParseLeftHandSideExpressionOptions();
        private static final /* synthetic */ ParseLeftHandSideExpressionOptions[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ParseLeftHandSideExpressionOptions[] values() {
            return (ParseLeftHandSideExpressionOptions[])$VALUES.clone();
        }

        public static ParseLeftHandSideExpressionOptions valueOf(String value) {
            return Enum.valueOf(ParseLeftHandSideExpressionOptions.class, value);
        }

        @NotNull
        public static EnumEntries<ParseLeftHandSideExpressionOptions> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = parseLeftHandSideExpressionOptionsArray = new ParseLeftHandSideExpressionOptions[]{ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION, ParseLeftHandSideExpressionOptions.DISALLOW_INDEXER, ParseLeftHandSideExpressionOptions.IS_IN_EXTENDS_OR_IMPLEMENTS_LIST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

