/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClientBootstrap;
import reactor.netty.tcp.TcpClientConfig;
import reactor.netty.tcp.TcpClientConnect;
import reactor.netty.tcp.TcpResources;
import reactor.netty.transport.ClientTransport;
import reactor.netty.transport.ProxyProvider;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public abstract class TcpClient
extends ClientTransport<TcpClient, TcpClientConfig> {
    static final Logger log = Loggers.getLogger(TcpClient.class);

    public static TcpClient create() {
        return TcpClient.create(TcpResources.get());
    }

    public static TcpClient create(ConnectionProvider provider) {
        Objects.requireNonNull(provider, "provider");
        return new TcpClientConnect(provider);
    }

    public static TcpClient newConnection() {
        return TcpClient.create(ConnectionProvider.newConnection());
    }

    @Deprecated
    public final TcpClient addressSupplier(Supplier<? extends SocketAddress> connectAddressSupplier) {
        return this.remoteAddress((Supplier)connectAddressSupplier);
    }

    @Override
    public <A> TcpClient attr(AttributeKey<A> key, @Nullable A value) {
        return (TcpClient)super.attr(key, value);
    }

    @Override
    public TcpClient bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        return (TcpClient)super.bindAddress(bindAddressSupplier);
    }

    @Deprecated
    public final TcpClient bootstrap(Function<? super Bootstrap, ? extends Bootstrap> bootstrapMapper) {
        Objects.requireNonNull(bootstrapMapper, "bootstrapMapper");
        TcpClientBootstrap tcpClientBootstrap = new TcpClientBootstrap(this);
        bootstrapMapper.apply(tcpClientBootstrap);
        return tcpClientBootstrap.tcpClient;
    }

    @Override
    public Mono<? extends Connection> connect() {
        return super.connect();
    }

    @Override
    public final Connection connectNow() {
        return super.connectNow();
    }

    @Override
    public final Connection connectNow(Duration timeout) {
        return super.connectNow(timeout);
    }

    @Override
    public TcpClient doOnConnect(Consumer<? super TcpClientConfig> doOnConnect) {
        return (TcpClient)super.doOnConnect(doOnConnect);
    }

    @Override
    public TcpClient doOnConnected(Consumer<? super Connection> doOnConnected) {
        return (TcpClient)super.doOnConnected(doOnConnected);
    }

    @Override
    public TcpClient doOnDisconnected(Consumer<? super Connection> doOnDisconnected) {
        return (TcpClient)super.doOnDisconnected(doOnDisconnected);
    }

    public TcpClient handle(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnConnected((Consumer)new OnConnectedHandle(handler));
    }

    @Override
    public TcpClient host(String host) {
        return (TcpClient)super.host(host);
    }

    @Override
    public TcpClient metrics(boolean enable) {
        return (TcpClient)super.metrics(enable);
    }

    @Override
    public TcpClient metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        return (TcpClient)super.metrics(enable, recorder);
    }

    @Override
    public TcpClient noProxy() {
        return (TcpClient)super.noProxy();
    }

    public TcpClient noSSL() {
        if (((TcpClientConfig)this.configuration()).isSecure()) {
            TcpClient dup = (TcpClient)this.duplicate();
            ((TcpClientConfig)dup.configuration()).sslProvider = null;
            return dup;
        }
        return this;
    }

    @Override
    public TcpClient observe(ConnectionObserver observer) {
        return (TcpClient)super.observe(observer);
    }

    @Override
    public <O> TcpClient option(ChannelOption<O> key, @Nullable O value) {
        return (TcpClient)super.option(key, value);
    }

    @Override
    public TcpClient port(int port) {
        return (TcpClient)super.port(port);
    }

    @Override
    public TcpClient proxy(Consumer<? super ProxyProvider.TypeSpec> proxyOptions) {
        return (TcpClient)super.proxy(proxyOptions);
    }

    @Override
    public TcpClient remoteAddress(Supplier<? extends SocketAddress> remoteAddressSupplier) {
        return (TcpClient)super.remoteAddress(remoteAddressSupplier);
    }

    @Override
    public TcpClient resolver(AddressResolverGroup<?> resolver) {
        return (TcpClient)super.resolver(resolver);
    }

    @Override
    public TcpClient runOn(EventLoopGroup eventLoopGroup) {
        return (TcpClient)super.runOn(eventLoopGroup);
    }

    @Override
    public TcpClient runOn(LoopResources channelResources) {
        return (TcpClient)super.runOn(channelResources);
    }

    @Override
    public TcpClient runOn(LoopResources loopResources, boolean preferNative) {
        return (TcpClient)super.runOn(loopResources, preferNative);
    }

    public TcpClient secure() {
        TcpClient dup = (TcpClient)this.duplicate();
        ((TcpClientConfig)dup.configuration()).sslProvider = SslProvider.defaultClientProvider();
        return dup;
    }

    public TcpClient secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        TcpClient dup = (TcpClient)this.duplicate();
        SslProvider.SslContextSpec builder = SslProvider.builder();
        sslProviderBuilder.accept(builder);
        ((TcpClientConfig)dup.configuration()).sslProvider = ((SslProvider.Builder)((Object)builder)).build();
        return dup;
    }

    public TcpClient secure(SslProvider sslProvider) {
        Objects.requireNonNull(sslProvider, "sslProvider");
        TcpClient dup = (TcpClient)this.duplicate();
        ((TcpClientConfig)dup.configuration()).sslProvider = sslProvider;
        return dup;
    }

    @Override
    public Mono<Void> warmup() {
        return Mono.when(super.warmup(), Mono.fromRunnable(() -> {
            SslProvider provider = ((TcpClientConfig)this.configuration()).sslProvider();
            if (provider != null && !(provider.getSslContext() instanceof JdkSslContext)) {
                OpenSsl.version();
            }
        }));
    }

    @Override
    public TcpClient wiretap(boolean enable) {
        return (TcpClient)super.wiretap(enable);
    }

    @Override
    public TcpClient wiretap(String category) {
        return (TcpClient)super.wiretap(category);
    }

    @Override
    public TcpClient wiretap(String category, LogLevel level) {
        return (TcpClient)super.wiretap(category, level);
    }

    static final class OnConnectedHandle
    implements Consumer<Connection> {
        final BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler;

        OnConnectedHandle(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
            this.handler = handler;
        }

        @Override
        public void accept(Connection c) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), this.handler);
            }
            Mono.fromDirect(this.handler.apply((NettyInbound)((Object)c), (NettyOutbound)((Object)c))).subscribe(c.disposeSubscriber());
        }
    }
}

