/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import javax.swing.JTabbedPane;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.ComponentFormatterTemplate;
import org.assertj.swing.util.Arrays;

public class JTabbedPaneFormatter
extends ComponentFormatterTemplate {
    private static final String NO_SELECTION = "<No selection>";

    @Override
    @Nonnull
    protected String doFormat(@Nonnull Component c) {
        JTabbedPane tabbedPane = (JTabbedPane)c;
        String format = "%s[name=%s, selectedTabIndex=%d, selectedTabTitle=%s, tabCount=%d, tabTitles=%s, enabled=%b, visible=%s, showing=%s";
        return String.format(format, this.getRealClassName(c), Strings.quote((String)tabbedPane.getName()), tabbedPane.getSelectedIndex(), this.selectedTab(tabbedPane), tabbedPane.getTabCount(), Arrays.format(this.tabTitles(tabbedPane)), tabbedPane.isEnabled(), tabbedPane.isVisible(), tabbedPane.isShowing());
    }

    private String selectedTab(JTabbedPane tabbedPane) {
        if (tabbedPane.getTabCount() == 0) {
            return NO_SELECTION;
        }
        int index = tabbedPane.getSelectedIndex();
        if (index == -1) {
            return NO_SELECTION;
        }
        return Strings.quote((String)tabbedPane.getTitleAt(index));
    }

    private String[] tabTitles(JTabbedPane tabbedPane) {
        int count = tabbedPane.getTabCount();
        if (count == 0) {
            return new String[0];
        }
        String[] titles = new String[count];
        for (int i = 0; i < count; ++i) {
            titles[i] = tabbedPane.getTitleAt(i);
        }
        return titles;
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JTabbedPane.class;
    }
}

