/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.spellchecker.dictionary.DictionaryChecker;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class ProjectNameDictionaryChecker
implements DictionaryChecker {
    private final Pattern splitWordsRegex = Pattern.compile("[._-]|\\s|\\d");
    private final Key<Set<String>> projectWordsKey = Key.create((String)"PROJECT_SPELLING_WORDS");

    ProjectNameDictionaryChecker() {
    }

    @Override
    public boolean isCorrect(@NotNull Project project, @NotNull String word) {
        Set words;
        if (project == null) {
            ProjectNameDictionaryChecker.$$$reportNull$$$0(0);
        }
        if (word == null) {
            ProjectNameDictionaryChecker.$$$reportNull$$$0(1);
        }
        if ((words = (Set)project.getUserData(this.projectWordsKey)) != null) {
            return words.contains(word.toLowerCase(Locale.ROOT));
        }
        words = Set.copyOf(Arrays.stream(this.splitWordsRegex.split(project.getName())).map(w -> w.trim().toLowerCase(Locale.ROOT)).filter(w -> w.length() > 3).collect(Collectors.toSet()));
        project.putUserData(this.projectWordsKey, words);
        return words.contains(word.toLowerCase(Locale.ROOT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "word";
                break;
            }
        }
        objectArray[1] = "com/intellij/spellchecker/dictionary/ProjectNameDictionaryChecker";
        objectArray[2] = "isCorrect";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

