/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class FallbackStringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private int[] outSourceOffsets;

    public FallbackStringLiteralEscaper(T host) {
        super(host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            FallbackStringLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            FallbackStringLiteralEscaper.$$$reportNull$$$0(1);
        }
        String subText = rangeInsideHost.substring(this.myHost.getText());
        Ref sourceOffsetsRef = new Ref();
        boolean result = FallbackStringLiteralEscaper.parseStringCharacters(subText, outChars, (Ref<int[]>)sourceOffsetsRef, false, !this.isOneLine());
        this.outSourceOffsets = (int[])sourceOffsetsRef.get();
        return result;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            FallbackStringLiteralEscaper.$$$reportNull$$$0(2);
        }
        int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return Math.min(result, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    public static boolean parseStringCharacters(String chars, StringBuilder outChars, Ref<int[]> sourceOffsetsRef, boolean regExp, boolean escapeBacktick) {
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            sourceOffsetsRef.set((Object)IntStream.range(0, chars.length() + 1).toArray());
            return true;
        }
        int[] sourceOffsets = new int[chars.length() + 1];
        int index = 0;
        int outOffset = outChars.length();
        boolean result = true;
        block20: while (index < chars.length()) {
            char c = chars.charAt(index++);
            sourceOffsets[outChars.length() - outOffset] = index - 1;
            sourceOffsets[outChars.length() + 1 - outOffset] = index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                result = false;
                break;
            }
            c = chars.charAt(index++);
            if (escapeBacktick && c == '`') {
                outChars.append(c);
            } else if (regExp) {
                if (c != '/') {
                    outChars.append('\\');
                }
                outChars.append(c);
            } else {
                switch (c) {
                    case 'b': {
                        outChars.append('\b');
                        break;
                    }
                    case 't': {
                        outChars.append('\t');
                        break;
                    }
                    case '\n': 
                    case 'n': {
                        outChars.append('\n');
                        break;
                    }
                    case 'f': {
                        outChars.append('\f');
                        break;
                    }
                    case 'r': {
                        outChars.append('\r');
                        break;
                    }
                    case '\"': {
                        outChars.append('\"');
                        break;
                    }
                    case '/': {
                        outChars.append('/');
                        break;
                    }
                    case '\'': {
                        outChars.append('\'');
                        break;
                    }
                    case '\\': {
                        outChars.append('\\');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char startC = c;
                        int v2 = c - 48;
                        if (index < chars.length()) {
                            if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                v2 <<= 3;
                                v2 += c - 48;
                                if (startC <= '3' && index < chars.length()) {
                                    if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                        v2 <<= 3;
                                        v2 += c - 48;
                                    }
                                }
                            } else {
                                --index;
                            }
                        }
                        outChars.append((char)v2);
                        break;
                    }
                    case 'x': {
                        int v;
                        if (index + 2 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index, index + 2), 16);
                                outChars.append((char)v);
                                index += 2;
                                break;
                            }
                            catch (Exception e) {
                                result = false;
                                break block20;
                            }
                        }
                        result = false;
                        break block20;
                    }
                    case 'u': {
                        int v;
                        int v2;
                        if (index + 3 <= chars.length() && chars.charAt(index) == '{') {
                            int end = chars.indexOf(125, index + 1);
                            if (end < 0) {
                                result = false;
                                break block20;
                            }
                            try {
                                v2 = Integer.parseInt(chars.substring(index + 1, end), 16);
                                c = chars.charAt(index + 1);
                                if (c == '+' || c == '-') {
                                    result = false;
                                    break block20;
                                }
                                outChars.appendCodePoint(v2);
                                index = end + 1;
                                break;
                            }
                            catch (Exception e) {
                                result = false;
                                break block20;
                            }
                        }
                        if (index + 4 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index, index + 4), 16);
                                c = chars.charAt(index);
                                if (c == '+' || c == '-') {
                                    result = false;
                                    break block20;
                                }
                                outChars.append((char)v);
                                index += 4;
                                break;
                            }
                            catch (Exception e) {
                                result = false;
                                break block20;
                            }
                        }
                        result = false;
                        break block20;
                    }
                    default: {
                        outChars.append(c);
                    }
                }
            }
            sourceOffsets[outChars.length() - outOffset] = --index;
        }
        sourceOffsets[outChars.length() - outOffset] = chars.length();
        sourceOffsetsRef.set((Object)Arrays.copyOf(sourceOffsets, outChars.length() - outOffset + 1));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/psi/FallbackStringLiteralEscaper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetInHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

