/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class BeanNameViewResolverFactory
extends ViewResolverFactory {
    @Override
    public String getBeanClass() {
        return "org.springframework.web.servlet.view.BeanNameViewResolver";
    }

    @Override
    @NotNull
    public Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        assert (bean != null);
        Module module = model.getModule();
        if (module == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                BeanNameViewResolverFactory.$$$reportNull$$$0(0);
            }
            return set;
        }
        BeanNameViewResolver beanNameViewResolver = new BeanNameViewResolver(module, bean.getBeanName() + "[" + bean.getContainingFile().getName() + "]");
        Set<ViewResolver> set = Collections.singleton(beanNameViewResolver);
        if (set == null) {
            BeanNameViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/mvc/views/BeanNameViewResolverFactory", "createViewResolvers"));
    }

    public static class BeanNameViewResolver
    extends ViewResolver {
        @NotNull
        private final Module myModule;
        @NotNull
        private final String myID;

        public BeanNameViewResolver(@NotNull Module module, @NotNull String ID) {
            if (module == null) {
                BeanNameViewResolver.$$$reportNull$$$0(0);
            }
            if (ID == null) {
                BeanNameViewResolver.$$$reportNull$$$0(1);
            }
            this.myModule = module;
            this.myID = ID;
        }

        public String toString() {
            return "BeanNameViewResolver{id='" + this.myID + "'}";
        }

        @Override
        @TestOnly
        @NotNull
        public String getID() {
            String string = this.myID;
            if (string == null) {
                BeanNameViewResolver.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Set<PsiElement> resolveView(String viewName) {
            if (StringUtil.isEmpty((String)viewName)) {
                Set<PsiElement> set = Collections.emptySet();
                if (set == null) {
                    BeanNameViewResolver.$$$reportNull$$$0(3);
                }
                return set;
            }
            HashSet<PsiElement> elements = new HashSet<PsiElement>();
            Collection<SpringModel> models = this.getModels();
            for (SpringModel model : models) {
                PsiElement pointerPsiElement;
                SpringBeanPointer beanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)viewName);
                if (beanPointer == null) continue;
                CommonSpringBean bean = beanPointer.getSpringBean();
                String url = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"url");
                if (url != null) {
                    for (WebDirectoryElement webDirectoryElement : SpringMvcUtils.findWebDirectoryElements(url, this.getModule())) {
                        elements.add((PsiElement)webDirectoryElement.getOriginalFile());
                    }
                }
                if ((pointerPsiElement = beanPointer.getPsiElement()) == null) continue;
                elements.add(pointerPsiElement);
            }
            HashSet<PsiElement> hashSet = elements;
            if (hashSet == null) {
                BeanNameViewResolver.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public List<LookupElement> getAllResolverViews() {
            PsiClass servletView = SpringCommonUtils.findLibraryClass((Module)this.getModule(), (String)"org.springframework.web.servlet.View");
            if (servletView == null) {
                List<LookupElement> list = Collections.emptyList();
                if (list == null) {
                    BeanNameViewResolver.$$$reportNull$$$0(5);
                }
                return list;
            }
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)servletView).withInheritors();
            ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
            for (SpringModel model : this.getModels()) {
                List beanPointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
                variants.addAll(ContainerUtil.mapNotNull((Collection)beanPointers, SpringConverterUtil::createCompletionVariant));
            }
            ArrayList<LookupElement> arrayList = variants;
            if (arrayList == null) {
                BeanNameViewResolver.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @Override
        public String bindToElement(PsiElement element) {
            return null;
        }

        @Override
        @NotNull
        public String handleElementRename(String newElementName) {
            String string = newElementName;
            if (string == null) {
                BeanNameViewResolver.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        protected Collection<SpringModel> getModels() {
            Set<SpringModel> set = SpringMvcService.getServletModels(this.getModule());
            if (set == null) {
                BeanNameViewResolver.$$$reportNull$$$0(8);
            }
            return set;
        }

        @NotNull
        public Module getModule() {
            Module module = this.myModule;
            if (module == null) {
                BeanNameViewResolver.$$$reportNull$$$0(9);
            }
            return module;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ID";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/mvc/views/BeanNameViewResolverFactory$BeanNameViewResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/mvc/views/BeanNameViewResolverFactory$BeanNameViewResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getID";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveView";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllResolverViews";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handleElementRename";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModels";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

