/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.pathVariables;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.jvm.pathvars.PathVariableConsumerInfo;
import com.intellij.microservices.jvm.pathvars.PathVariableContext;
import com.intellij.microservices.jvm.pathvars.PathVariableMethodInspection;
import com.intellij.microservices.url.parameters.PathVariableUtils;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.mvc.model.jam.MVCPathVariable;
import com.intellij.spring.mvc.model.jam.SpringMVCModelAttribute;
import com.intellij.spring.mvc.pathVariables.SpringPathVariableContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/mvc/pathVariables/MVCPathVariableInspection;", "Lcom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection;", "<init>", "()V", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "method", "Lorg/jetbrains/uast/UMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nMVCPathVariableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MVCPathVariableInspection.kt\ncom/intellij/spring/mvc/pathVariables/MVCPathVariableInspection\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,62:1\n216#2,2:63\n*S KotlinDebug\n*F\n+ 1 MVCPathVariableInspection.kt\ncom/intellij/spring/mvc/pathVariables/MVCPathVariableInspection\n*L\n43#1:63,2\n*E\n"})
public final class MVCPathVariableInspection
extends PathVariableMethodInspection {
    public MVCPathVariableInspection() {
        super((PathVariableContext)SpringPathVariableContext.INSTANCE);
    }

    @NotNull
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Object[] baseProblems = super.checkMethod(method, manager, isOnTheFly);
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
        if (uClass == null) {
            return baseProblems;
        }
        UClass containingClass = uClass;
        PsiMethod psiMethod = method.getJavaPsi();
        if (SpringMVCModelAttribute.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod) == null) {
            return baseProblems;
        }
        PsiParameter[] psiParameterArray = psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Map variables = MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])psiParameterArray), MVCPathVariableInspection::checkMethod$lambda$0));
        if (variables.isEmpty()) {
            return baseProblems;
        }
        HashMap undeclaredUsages = new HashMap();
        HashSet unusedDeclarations = new HashSet();
        for (UMethod uMethod : containingClass.getMethods()) {
            UrlPathContext urlPathContext = this.getPathVariableContext().getUrlPathContext(uMethod);
            if (urlPathContext.isEmpty()) continue;
            Set allDeclaredPathVariableNamesForContext = CollectionsKt.toSet((Iterable)PathVariableUtils.getPathVariablesFromContext((UrlPathContext)urlPathContext));
            unusedDeclarations.addAll(SetsKt.minus((Set)allDeclaredPathVariableNamesForContext, (Iterable)variables.keySet()));
            Map $this$forEach$iv = variables;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                String name = (String)k;
                PathVariableConsumerInfo info = (PathVariableConsumerInfo)entry.getValue();
                if (allDeclaredPathVariableNamesForContext.contains(name)) continue;
                ((Map)undeclaredUsages).put(name, info);
            }
        }
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, (PsiFile)psiElement, isOnTheFly);
        for (Map.Entry entry : ((Map)undeclaredUsages).entrySet()) {
            String pathVariableName = (String)entry.getKey();
            PathVariableConsumerInfo consumerInfo = (PathVariableConsumerInfo)entry.getValue();
            PsiElement anchor = consumerInfo.getAnchor();
            if (anchor == null || !consumerInfo.getReportIfNotDeclared()) continue;
            Object[] objectArray = new Object[]{pathVariableName};
            String string = MicroservicesBundle.message((String)"PathVariableInspection.cannot.resolve", (Object[])objectArray);
            objectArray = LocalQuickFix.notNullElements((LocalQuickFix)this.createRenameQuickfix(anchor, pathVariableName, unusedDeclarations));
            holder.registerProblem(anchor, string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return (ProblemDescriptor[])ArraysKt.plus((Object[])baseProblems, (Object[])problemDescriptorArray);
    }

    private static final Pair checkMethod$lambda$0(PsiParameter param) {
        Pair pair;
        MVCPathVariable mVCPathVariable = (MVCPathVariable)MVCPathVariable.META.getJamElement((PsiModifierListOwner)param);
        if (mVCPathVariable != null) {
            MVCPathVariable pv = mVCPathVariable;
            boolean bl = false;
            String string = pv.getName();
            String string2 = pv.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-name>(...)");
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)param));
            pair = TuplesKt.to((Object)string, (Object)new PathVariableConsumerInfo(string2, (PsiElement)(uElement != null ? uElement.getSourcePsi() : null), true));
        } else {
            pair = null;
        }
        return pair;
    }
}

