/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.customDeployment;

import com.intellij.javaee.appServers.customDeployment.DeploymentSourcesCollection;
import com.intellij.javaee.appServers.deployment.DeploymentSource;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CustomDeploymentActionHandler {
    @Nls
    private final String myName;
    private final Icon myIcon;
    private final Project myProject;
    private final DeploymentSourcesCollection mySources;

    public CustomDeploymentActionHandler(@Nls String name, Icon icon, Project project, DeploymentSourcesCollection sources) {
        this.myName = name;
        this.myIcon = icon;
        this.myProject = project;
        this.mySources = sources;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected void addSource(DeploymentSource source) {
        this.mySources.addItem(source);
    }

    protected @Unmodifiable Collection<DeploymentSource> getChosenSources() {
        return this.mySources.getItems();
    }

    public abstract boolean isAvailable();

    public abstract void run();
}

