/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.javaee.constants.RestAnnotations;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.ws.rest.model.jam.RSApplicationPath;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPath;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import com.intellij.ws.rest.model.jam.microprofile.MicroprofileRegisterRestClient;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RSUtils {
    private RSUtils() {
    }

    @NotNull
    @NlsSafe
    public static String getResourcePath(@NotNull RSHttpMethod httpMethod) {
        String resourceValue;
        RSJamPsiMethodPath methodPathResource;
        RSJamPsiClassPath psiClassPath;
        if (httpMethod == null) {
            RSUtils.$$$reportNull$$$0(0);
        }
        StringBuilder buffer = new StringBuilder();
        PsiMethod psiMethod = (PsiMethod)httpMethod.getPsiElement();
        JamService service = JamService.getJamService((Project)psiMethod.getProject());
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && (psiClassPath = (RSJamPsiClassPath)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{RSJamPsiClassPath.META})) != null) {
            buffer.append(psiClassPath.getResourceValue());
        }
        if ((methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{RSJamPsiMethodPath.META})) != null && (resourceValue = methodPathResource.getResourceValue()) != null) {
            if (!buffer.toString().endsWith("/") && !resourceValue.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(resourceValue);
        }
        String string = buffer.toString();
        if (string == null) {
            RSUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getResourcePath(@NotNull RSHttpMappingInfo httpMapping) {
        String resourceValue;
        PsiMethod psiMethod;
        RSJamPsiMethodPath methodPathResource;
        PsiClass containingClass;
        String pathResourceValue;
        RSApplicationPath applicationPath;
        if (httpMapping == null) {
            RSUtils.$$$reportNull$$$0(2);
        }
        UrlMappingBuilder builder = new UrlMappingBuilder();
        RSHttpMethod mapping = httpMapping.getMapping();
        JamService service = JamService.getJamService((Project)((PsiMethod)mapping.getPsiElement()).getProject());
        PsiClass application = httpMapping.getApplication();
        if (application != null && (applicationPath = (RSApplicationPath)service.getJamElement(RSApplicationPath.PATH_JAM_KEY, (PsiElement)application)) != null && StringUtil.isNotEmpty((String)(pathResourceValue = applicationPath.getResourceValue()))) {
            builder.appendSegment(pathResourceValue);
        }
        if ((containingClass = httpMapping.getHolder()) != null) {
            RSJamPsiClassPath psiClassPath;
            MicroprofileRegisterRestClient registerRestClient = (MicroprofileRegisterRestClient)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{MicroprofileRegisterRestClient.META});
            if (registerRestClient != null) {
                builder.appendSegment(registerRestClient.getBaseUri());
            }
            if ((psiClassPath = (RSJamPsiClassPath)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{RSJamPsiClassPath.META})) != null) {
                builder.appendSegment(psiClassPath.getResourceValue());
            } else {
                for (PsiElementRef<PsiMember> pointer : httpMapping.getPathPointers()) {
                    RSJamPath path;
                    PsiMember element = (PsiMember)pointer.getPsiElement();
                    if (element == null || !element.isValid() || (path = (RSJamPath)service.getJamElement(RSJamPath.PATH_JAM_KEY, (PsiElement)element)) == null) continue;
                    builder.appendSegment(path.getResourceValue());
                }
            }
        }
        if ((methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)(psiMethod = (PsiMethod)mapping.getPsiElement()), new JamMemberMeta[]{RSJamPsiMethodPath.META})) != null && (resourceValue = methodPathResource.getResourceValue()) != null) {
            builder.appendSegment(resourceValue);
        }
        return builder.buildOrNull();
    }

    public static boolean isResourceClass(@NotNull PsiClass resource) {
        if (resource == null) {
            RSUtils.$$$reportNull$$$0(3);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)resource, Arrays.asList(RestAnnotations.PATH.all()), (int)1);
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            RSUtils.$$$reportNull$$$0(4);
        }
        return (String)AnnotationModelUtil.getStringValue((PsiAnnotation)anno, (String)"value", null).getValue();
    }

    public static void annotateFieldWithPathParam(Project project, PsiField field, String name) {
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(field.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation annotation = factory.createAnnotationFromText("@" + RestAnnotations.PATH_PARAM.fqn((PsiElement)field) + "(\"" + name + "\")", (PsiElement)field);
        PsiElement firstChild = modifierList.getFirstChild();
        if (firstChild != null) {
            modifierList.addBefore((PsiElement)annotation, firstChild);
        } else {
            modifierList.add((PsiElement)annotation);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
    }

    public static boolean hasRestLibrary(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)RestAnnotations.PATH.javax()) || JavaLibraryUtil.hasLibraryClass((Module)module, (String)RestAnnotations.PATH.jakarta());
    }

    public static boolean hasRestLibrary(@NotNull Project project) {
        if (project == null) {
            RSUtils.$$$reportNull$$$0(5);
        }
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)RestAnnotations.PATH.javax()) || JavaLibraryUtil.hasLibraryClass((Project)project, (String)RestAnnotations.PATH.jakarta());
    }

    public static boolean hasRestEasy(@NotNull Project project) {
        if (project == null) {
            RSUtils.$$$reportNull$$$0(6);
        }
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.jboss.resteasy.core.ResteasyContext");
    }

    public static boolean hasJersey(@NotNull Project project) {
        if (project == null) {
            RSUtils.$$$reportNull$$$0(7);
        }
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.glassfish.jersey.server.ServerConfig");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/utils/RSUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpMapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/utils/RSUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourcePath";
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasRestLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasRestEasy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasJersey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

