/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionDurationsAggregatorService;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionEventsCollector;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionFingerprintAggregatorService;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionInfoQodanaReporterService;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionProblemsFoundAggregatorService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionEventsListener;", "Lcom/intellij/codeInspection/ex/InspectListener;", "<init>", "()V", "verboseLogging", "", "inspectionFinished", "", "duration", "", "threadId", "problemsCount", "", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "activityFinished", "activityKind", "", "fileAnalyzed", "intellij.qodana"})
public final class InspectionEventsListener
implements InspectListener {
    private final boolean verboseLogging = Boolean.getBoolean("qodana.verbose.inspections.statistic");

    public void inspectionFinished(long duration, long threadId, int problemsCount, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull InspectListener.InspectionKind kind, @Nullable PsiFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!ApplicationKt.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.verboseLogging) {
            InspectionEventsCollector.logInspectionFinished(duration, threadId, problemsCount, tool, kind, project);
        }
        InspectionDurationsAggregatorService inspectionDurationService = (InspectionDurationsAggregatorService)project.getService(InspectionDurationsAggregatorService.class);
        inspectionDurationService.addInspectionFinishedEvent(duration, problemsCount, tool, kind);
        InspectionProblemsFoundAggregatorService inspectionProblemsFoundService = (InspectionProblemsFoundAggregatorService)project.getService(InspectionProblemsFoundAggregatorService.class);
        inspectionProblemsFoundService.addInspectionFinishedEvent(problemsCount, tool, kind);
        PsiFile psiFile2 = file2;
        InspectionInfoQodanaReporterService.Companion.getInstance(project).addInspectionFinishedEvent(duration, problemsCount, tool, kind, (VirtualFile)(psiFile2 != null ? psiFile2.getVirtualFile() : null));
    }

    public void activityFinished(long duration, long threadId, @NotNull String activityKind, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)activityKind, (String)"activityKind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!ApplicationKt.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.verboseLogging) {
            InspectionEventsCollector.logActivityFinished(duration, threadId, activityKind, project);
        }
    }

    public void fileAnalyzed(@NotNull PsiFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!ApplicationKt.getApplication().isHeadlessEnvironment()) {
            return;
        }
        ((InspectionFingerprintAggregatorService)project.getService(InspectionFingerprintAggregatorService.class)).registerAnalyzedFile(file2);
    }
}

