/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.manipulators;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.hibernate.HibernateBundle;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.model.xml.mapping.HbmHibernateMapping;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.jpa.model.manipulators.JpaUnitManipulator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionFactoryManipulator
extends AbstractPersistenceManipulator<SessionFactory>
implements PersistenceUnitManipulator<SessionFactory> {
    public SessionFactoryManipulator(SessionFactory target) {
        super((Object)target);
    }

    public List<PersistenceAction> getCreateActions() {
        ArrayList<PersistenceAction> result = new ArrayList<PersistenceAction>();
        return SessionFactoryManipulator.getCreateActionsDefault(this, result);
    }

    public static List<PersistenceAction> getCreateActionsDefault(PersistenceUnitManipulator unitManipulator, ArrayList<PersistenceAction> result) {
        result.add((PersistenceAction)new JpaUnitManipulator.MyMappingsAction(unitManipulator, HibernateBundle.message("action.name.create.mapping", new Object[0]), HibernateBundle.message("type.hibernate.mappings", new Object[0]), HibernateDescriptorsConstants.HIBERNATE_MAPPING_META_DATA.getDefaultVersion().getTemplateName(), HbmHibernateMapping.class));
        return JpaUnitManipulator.getCreateActionsDefault((PersistenceUnitManipulator)unitManipulator, result);
    }

    public void ensureMappingIncluded(PersistenceMappings mappings) {
        if (mappings instanceof DomElement && !GenericValueUtil.containsValue((Collection)((SessionFactory)this.getManipulatorTarget()).getModelHelper().getMappingFiles(PersistenceMappings.class), (Object)mappings)) {
            ((SessionFactory)this.getManipulatorTarget()).addMapping().getResource().setValue((Object)mappings.getContainingFile());
        }
    }

    public void ensureClassIncluded(PsiClass psiClass) {
        if (!GenericValueUtil.containsValue((Collection)((SessionFactory)this.getManipulatorTarget()).getModelHelper().getClasses(), (Object)psiClass)) {
            String packageName = ((PsiJavaFile)psiClass.getContainingFile()).getPackageName();
            PsiManager manager = psiClass.getManager();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageName);
            for (GenericValue pkgValue : ((SessionFactory)this.getManipulatorTarget()).getModelHelper().getPackages()) {
                if (!manager.areElementsEquivalent((PsiElement)psiPackage, (PsiElement)pkgValue.getValue())) continue;
                return;
            }
            ((SessionFactory)this.getManipulatorTarget()).addMapping().getClazz().setValue((Object)psiClass);
        }
    }

    public void setConnectionProperties(@NotNull Project project, @NotNull RawConnectionConfig info, @Nullable Credentials credentials) {
        if (project == null) {
            SessionFactoryManipulator.$$$reportNull$$$0(0);
        }
        if (info == null) {
            SessionFactoryManipulator.$$$reportNull$$$0(1);
        }
        SessionFactory factory = (SessionFactory)this.getManipulatorTarget();
        String url = DataSourceUtil.getEffectiveUrl((Project)project, (RawConnectionConfig)info);
        HibernateUtil.setSessionFactoryProperty(factory, "connection.url", url);
        HibernateUtil.setSessionFactoryProperty(factory, "connection.driver_class", info.getDriverClass());
        HibernateUtil.setSessionFactoryProperty(factory, "connection.username", credentials == null ? null : credentials.getUserName());
        HibernateUtil.setSessionFactoryProperty(factory, "connection.password", credentials == null ? null : credentials.getPasswordAsString());
        Property<Object> dialect = HibernateUtil.findSessionFactoryProperty(factory, "dialect");
        if (dialect == null) {
            dialect = factory.addProperty();
            String dialectValue = HibernateUtil.getDefaultDialectValue((PsiElement)dialect.getXmlElement(), url);
            if (StringUtil.isNotEmpty((String)dialectValue)) {
                dialect.getName().setStringValue("dialect");
                HibernateUtil.setSessionFactoryProperty(factory, "dialect", dialectValue);
            } else {
                dialect.undefine();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/hibernate/model/manipulators/SessionFactoryManipulator";
        objectArray[2] = "setConnectionProperties";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

