/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.async.windows.WindowsSymbolsResolver;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.profiler.ultimate.jfr.DllDebugInfo;
import com.intellij.profiler.ultimate.jfr.JfrContentsDescriptor;
import com.intellij.profiler.ultimate.jfr.MultipleStepsProgressTracker;
import com.intellij.profiler.ultimate.jfr.events.JfrEvent;
import com.intellij.profiler.ultimate.jfr.events.JfrEventGroup;
import com.intellij.profiler.ultimate.jfr.events.JfrEventTypesBuilder;
import com.intellij.profiler.ultimate.jfr.events.JfrEvents;
import com.intellij.profiler.ultimate.jfr.events.JfrSamplingEvents;
import com.intellij.profiler.ultimate.jfr.jmc.StreamModel;
import com.intellij.profiler.ultimate.jfr.ui.JFRDumpViewKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData;", "Lcom/intellij/profiler/api/ProfilerData;", "allEvents", "Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;", "parsedEvents", "", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvents;", "startTimeMs", "", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;Ljava/util/List;J)V", "getAllEvents$intellij_profiler_ultimate", "()Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;", "getParsedEvents", "()Ljava/util/List;", "getStartTimeMs", "()J", "isEmpty", "", "()Z", "doCreateTopLevelComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "clearLineData", "", "Builder", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRProfilerData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,199:1\n1869#2,2:200\n13#3:202\n*S KotlinDebug\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData\n*L\n35#1:200,2\n175#1:202\n*E\n"})
public final class JFRProfilerData
implements ProfilerData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamModel allEvents;
    @NotNull
    private final List<JfrEvents> parsedEvents;
    private final long startTimeMs;
    private final boolean isEmpty;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String WINDOWS_SYMBOLS = "srv*c:\\JBRSymbols*https://msdl.microsoft.com/download/symbols";
    @NotNull
    private static final String JBR_SYMBOLS = "srv*C:\\JBRSymbols*https://resources.jetbrains.com/pdb";
    @NotNull
    private static final String NT_LIBRARY_PATH = "srv*c:\\JBRSymbols*https://msdl.microsoft.com/download/symbols;srv*C:\\JBRSymbols*https://resources.jetbrains.com/pdb";

    public JFRProfilerData(@NotNull StreamModel allEvents, @NotNull List<JfrEvents> parsedEvents, long startTimeMs) {
        Intrinsics.checkNotNullParameter((Object)allEvents, (String)"allEvents");
        Intrinsics.checkNotNullParameter(parsedEvents, (String)"parsedEvents");
        this.allEvents = allEvents;
        this.parsedEvents = parsedEvents;
        this.startTimeMs = startTimeMs;
        this.isEmpty = !this.allEvents.getItems().hasItems() && this.parsedEvents.isEmpty();
    }

    @NotNull
    public final StreamModel getAllEvents$intellij_profiler_ultimate() {
        return this.allEvents;
    }

    @NotNull
    public final List<JfrEvents> getParsedEvents() {
        return this.parsedEvents;
    }

    public final long getStartTimeMs() {
        return this.startTimeMs;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @NotNull
    public JComponent doCreateTopLevelComponent(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return JFRDumpViewKt.createJFRDumpView(project, parent, this.allEvents, this.parsedEvents);
    }

    public void clearLineData() {
        Iterable $this$forEach$iv = this.parsedEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JfrEvents it = (JfrEvents)element$iv;
            boolean bl = false;
            for (JfrSamplingEvents sampling : it.getSamplingEvents()) {
                sampling.setRawStacks(null);
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JFRProfilerData.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002'(B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ#\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJB\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f2$\u0010!\u001a \u0012\u0004\u0012\u00020#\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020&0%0$0\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "registeredBuilders", "", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder;", "setDataStructure", "", "event", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "addEvent", "values", "", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)V", "create", "Lcom/intellij/profiler/api/ProfilerData;", "model", "Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;", "progressTracker", "Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker;", "contentsDescriptor", "Lcom/intellij/profiler/ultimate/jfr/JfrContentsDescriptor;", "create$intellij_profiler_ultimate", "doResolveNativeFrames", "Ljava/util/HashMap;", "Lorg/openjdk/jmc/common/IMCFrame;", "unresolvedNativeFrames", "", "Lcom/intellij/profiler/ultimate/jfr/DllDebugInfo;", "", "Lkotlin/Pair;", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion$UnresolvedNativeFrame;", "GroupedNativeFrames", "NativeSymbolsResolver", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nJFRProfilerData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,199:1\n774#2:200\n865#2,2:201\n1285#2,2:204\n1299#2,4:206\n1252#2,4:219\n1563#2:223\n1634#2,3:224\n1#3:203\n504#4,7:210\n463#4:217\n413#4:218\n*S KotlinDebug\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder\n*L\n59#1:200\n59#1:201,2\n76#1:204,2\n76#1:206,4\n76#1:219,4\n90#1:223\n90#1:224,3\n76#1:210,7\n76#1:217\n76#1:218\n*E\n"})
    public static final class Builder {
        @Nullable
        private final Project project;
        @NotNull
        private final Map<JfrEventGroup, JfrEventTypesBuilder> registeredBuilders;

        public Builder(@Nullable Project project) {
            this.project = project;
            this.registeredBuilders = new EnumMap(JfrEventGroup.class);
        }

        public final void setDataStructure(@NotNull JfrEvent event, @Nullable List<ValueField> dataStructure) {
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            if (dataStructure == null) {
                return;
            }
            JfrEventGroup group = event.getGroup();
            this.registeredBuilders.computeIfAbsent(group, arg_0 -> Builder.setDataStructure$lambda$1(arg_0 -> Builder.setDataStructure$lambda$0(group, this, arg_0), arg_0)).setDataStructure(event, dataStructure);
        }

        public final void addEvent(@NotNull JfrEvent event, @NotNull Object[] values) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                JfrEventTypesBuilder jfrEventTypesBuilder = this.registeredBuilders.get((Object)event.getGroup());
                if (jfrEventTypesBuilder == null) break block0;
                jfrEventTypesBuilder.addEvent(event, values);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProfilerData create$intellij_profiler_ultimate(@NotNull StreamModel model2, @NotNull MultipleStepsProgressTracker progressTracker, @NotNull JfrContentsDescriptor contentsDescriptor) {
            void $this$mapTo$iv$iv;
            Object registryValue;
            Object element$iv$iv;
            Object $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)progressTracker, (String)"progressTracker");
            Intrinsics.checkNotNullParameter((Object)contentsDescriptor, (String)"contentsDescriptor");
            boolean areNativeStacksDevalued = contentsDescriptor.component1();
            boolean isWinAsyncDump = contentsDescriptor.component2();
            boolean isJetBrainsRuntime = contentsDescriptor.component3();
            Integer wallClockIntervalMs = contentsDescriptor.component4();
            boolean hasFakeNativeEvents = contentsDescriptor.component5();
            long startTimeMs = contentsDescriptor.component6();
            List<DllDebugInfo> unresolvedDlls = contentsDescriptor.component7();
            Iterable $this$filter$iv = this.registeredBuilders.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                JfrEventTypesBuilder it = (JfrEventTypesBuilder)element$iv$iv;
                boolean bl = false;
                if (!(it.getSize() > 0L)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonEmptyTreeBuilders = (List)destination$iv$iv;
            boolean ignoreNativeStacks = areNativeStacksDevalued;
            HashMap<IMCFrame, IMCFrame> maybeResolvedNativeFrames = new HashMap<IMCFrame, IMCFrame>();
            if (isWinAsyncDump) {
                $this$filterTo$iv$iv = GroupedNativeFrames.Companion.build(nonEmptyTreeBuilders);
                Set<IMCFrame> resolvedNativeFrames = ((GroupedNativeFrames)$this$filterTo$iv$iv).component1();
                Map<String, List<Pair<IMCFrame, Companion.UnresolvedNativeFrame>>> unresolvedNativeFrames = ((GroupedNativeFrames)$this$filterTo$iv$iv).component2();
                element$iv$iv = unresolvedNativeFrames.values();
                int it = 0;
                Iterator bl = element$iv$iv.iterator();
                while (bl.hasNext()) {
                    void it2;
                    Object t = bl.next();
                    List list = (List)t;
                    int n = it;
                    boolean bl2 = false;
                    int n2 = it2.size();
                    it = n + n2;
                }
                int totalUnresolvedFrames = it;
                if (resolvedNativeFrames.size() < totalUnresolvedFrames) {
                    ignoreNativeStacks = true;
                }
                registryValue = Registry.Companion.get("com.intellij.profiler.win.async.resolve.native.symbols");
                if (!areNativeStacksDevalued && SystemInfo.isWindows && totalUnresolvedFrames > 0 && !((Collection)unresolvedDlls).isEmpty() && (registryValue.isOptionEnabled("Always") || isJetBrainsRuntime && registryValue.isOptionEnabled("JBR"))) {
                    void $this$associateByTo$iv$iv$iv;
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Map $this$filterValues$iv;
                    List list;
                    Object element$iv$iv2;
                    Iterator $this$associateWithTo$iv$iv;
                    Object $this$associateWith$iv = unresolvedDlls;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    Iterable bl2 = $this$associateWith$iv;
                    Map destination$iv$iv2 = result$iv;
                    boolean $i$f$associateWithTo = false;
                    Iterator iterator3 = $this$associateWithTo$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        void it3;
                        element$iv$iv2 = iterator3.next();
                        DllDebugInfo dllDebugInfo = (DllDebugInfo)element$iv$iv2;
                        Object t = element$iv$iv2;
                        Map map2 = destination$iv$iv2;
                        boolean bl3 = false;
                        list = unresolvedNativeFrames.get(it3.getDllPath());
                        map2.put(t, list);
                    }
                    $this$associateWith$iv = destination$iv$iv2;
                    boolean $i$f$filterValues = false;
                    result$iv = new LinkedHashMap();
                    for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                        List it4 = (List)entry$iv.getValue();
                        boolean bl4 = false;
                        element$iv$iv2 = it4;
                        if (!(!(element$iv$iv2 == null || element$iv$iv2.isEmpty()))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    $this$filterValues$iv = result$iv;
                    boolean $i$f$mapValues = false;
                    result$iv = $this$mapValues$iv;
                    Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable it4 = $this$mapValuesTo$iv$iv.entrySet();
                    Map destination$iv$iv$iv = destination$iv$iv3;
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it5;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv$iv;
                        boolean bl5 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        Map map4 = map3;
                        boolean bl6 = false;
                        Object v = it5.getValue();
                        Intrinsics.checkNotNull(v);
                        list = (List)v;
                        map4.put(k, list);
                    }
                    Map dllToFrames = destination$iv$iv$iv;
                    maybeResolvedNativeFrames = this.doResolveNativeFrames(dllToFrames, progressTracker);
                    ignoreNativeStacks = false;
                }
                if (Registry.Companion.is("com.intellij.profiler.win.async.show.native.stacks", false)) {
                    ignoreNativeStacks = areNativeStacksDevalued;
                }
            }
            $this$filterTo$iv$iv = nonEmptyTreeBuilders;
            String string = "BuildingModeStep";
            Object object = progressTracker;
            long resolvedNativeFrames = 0L;
            Iterator totalUnresolvedFrames = $this$filterTo$iv$iv.iterator();
            while (totalUnresolvedFrames.hasNext()) {
                void it;
                registryValue = totalUnresolvedFrames.next();
                JfrEventTypesBuilder dllToFrames = (JfrEventTypesBuilder)registryValue;
                long l = resolvedNativeFrames;
                boolean bl = false;
                long l2 = it.getSize();
                resolvedNativeFrames = l + l2;
            }
            long l = resolvedNativeFrames;
            ((MultipleStepsProgressTracker)object).switchToStep(string, l);
            Integer n = wallClockIntervalMs;
            JfrEventTypesBuilder.Context context2 = new JfrEventTypesBuilder.Context(maybeResolvedNativeFrames, ignoreNativeStacks, n != null ? Double.valueOf(n.intValue()) : null, hasFakeNativeEvents);
            Iterable $this$map$iv = nonEmptyTreeBuilders;
            boolean $i$f$map = false;
            registryValue = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JfrEventTypesBuilder destination$iv$iv3 = (JfrEventTypesBuilder)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl = false;
                object.add(it.create(progressTracker, context2));
            }
            List eventTypes = (List)destination$iv$iv4;
            return new JFRProfilerData(model2, eventTypes, startTimeMs);
        }

        private final HashMap<IMCFrame, IMCFrame> doResolveNativeFrames(Map<DllDebugInfo, ? extends List<? extends Pair<? extends IMCFrame, Companion.UnresolvedNativeFrame>>> unresolvedNativeFrames, MultipleStepsProgressTracker progressTracker) {
            progressTracker.switchToStep("ResolvingNativeSymbolsStep", unresolvedNativeFrames.size());
            HashMap<IMCFrame, IMCFrame> maybeResolvedNativeFrames = new HashMap<IMCFrame, IMCFrame>();
            NativeSymbolsResolver resolver = new NativeSymbolsResolver();
            for (Map.Entry<DllDebugInfo, ? extends List<? extends Pair<? extends IMCFrame, Companion.UnresolvedNativeFrame>>> entry : unresolvedNativeFrames.entrySet()) {
                DllDebugInfo dllInfo = entry.getKey();
                List<? extends Pair<? extends IMCFrame, Companion.UnresolvedNativeFrame>> dllFrames = entry.getValue();
                progressTracker.addProgress(1L);
                progressTracker.checkCanceled();
                ((Map)maybeResolvedNativeFrames).putAll(resolver.doResolveNativeDll(dllInfo, dllFrames));
            }
            return maybeResolvedNativeFrames;
        }

        private static final JfrEventTypesBuilder setDataStructure$lambda$0(JfrEventGroup $group, Builder this$0, JfrEventGroup it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return $group.createBuilder(this$0.project);
        }

        private static final JfrEventTypesBuilder setDataStructure$lambda$1(Function1 $tmp0, Object p0) {
            return (JfrEventTypesBuilder)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012$\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t0\b0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J'\u0010\u0012\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t0\b0\u0006H\u00c6\u0003JA\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032&\b\u0002\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t0\b0\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR/\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$GroupedNativeFrames;", "", "resolved", "", "Lorg/openjdk/jmc/common/IMCFrame;", "unresolved", "", "", "", "Lkotlin/Pair;", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion$UnresolvedNativeFrame;", "<init>", "(Ljava/util/Set;Ljava/util/Map;)V", "getResolved", "()Ljava/util/Set;", "getUnresolved", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.profiler.ultimate"})
        private static final class GroupedNativeFrames {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<IMCFrame> resolved;
            @NotNull
            private final Map<String, List<Pair<IMCFrame, Companion.UnresolvedNativeFrame>>> unresolved;

            public GroupedNativeFrames(@NotNull Set<? extends IMCFrame> resolved, @NotNull Map<String, ? extends List<? extends Pair<? extends IMCFrame, Companion.UnresolvedNativeFrame>>> unresolved) {
                Intrinsics.checkNotNullParameter(resolved, (String)"resolved");
                Intrinsics.checkNotNullParameter(unresolved, (String)"unresolved");
                this.resolved = resolved;
                this.unresolved = unresolved;
            }

            @NotNull
            public final Set<IMCFrame> getResolved() {
                return this.resolved;
            }

            @NotNull
            public final Map<String, List<Pair<IMCFrame, Companion.UnresolvedNativeFrame>>> getUnresolved() {
                return this.unresolved;
            }

            @NotNull
            public final Set<IMCFrame> component1() {
                return this.resolved;
            }

            @NotNull
            public final Map<String, List<Pair<IMCFrame, Companion.UnresolvedNativeFrame>>> component2() {
                return this.unresolved;
            }

            @NotNull
            public final GroupedNativeFrames copy(@NotNull Set<? extends IMCFrame> resolved, @NotNull Map<String, ? extends List<? extends Pair<? extends IMCFrame, Companion.UnresolvedNativeFrame>>> unresolved) {
                Intrinsics.checkNotNullParameter(resolved, (String)"resolved");
                Intrinsics.checkNotNullParameter(unresolved, (String)"unresolved");
                return new GroupedNativeFrames(resolved, unresolved);
            }

            public static /* synthetic */ GroupedNativeFrames copy$default(GroupedNativeFrames groupedNativeFrames, Set set, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    set = groupedNativeFrames.resolved;
                }
                if ((n & 2) != 0) {
                    map2 = groupedNativeFrames.unresolved;
                }
                return groupedNativeFrames.copy(set, map2);
            }

            @NotNull
            public String toString() {
                return "GroupedNativeFrames(resolved=" + this.resolved + ", unresolved=" + this.unresolved + ")";
            }

            public int hashCode() {
                int result = ((Object)this.resolved).hashCode();
                result = result * 31 + ((Object)this.unresolved).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GroupedNativeFrames)) {
                    return false;
                }
                GroupedNativeFrames groupedNativeFrames = (GroupedNativeFrames)other;
                if (!Intrinsics.areEqual(this.resolved, groupedNativeFrames.resolved)) {
                    return false;
                }
                return Intrinsics.areEqual(this.unresolved, groupedNativeFrames.unresolved);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$GroupedNativeFrames$Companion;", "", "<init>", "()V", "build", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$GroupedNativeFrames;", "treeBuilders", "", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder;", "intellij.profiler.ultimate"})
            @SourceDebugExtension(value={"SMAP\nJFRProfilerData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$GroupedNativeFrames$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,199:1\n1460#2,5:200\n382#3,7:205\n*S KotlinDebug\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$GroupedNativeFrames$Companion\n*L\n99#1:200,5\n107#1:205,7\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final GroupedNativeFrames build(@NotNull List<? extends JfrEventTypesBuilder> treeBuilders) {
                    void destination$iv;
                    String[] list$iv;
                    void $this$flatMapTo$iv;
                    Intrinsics.checkNotNullParameter(treeBuilders, (String)"treeBuilders");
                    Iterable iterable = treeBuilders;
                    Collection collection = new HashSet();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv : $this$flatMapTo$iv) {
                        JfrEventTypesBuilder it = (JfrEventTypesBuilder)element$iv;
                        boolean bl = false;
                        list$iv = (String[])it.getAllFrames();
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    HashSet allFrames = (HashSet)destination$iv;
                    HashSet resolved = new HashSet();
                    HashMap unresolved = new HashMap();
                    Iterator iterator2 = allFrames.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        IMCFrame frame = (IMCFrame)e;
                        if (frame.getType() != IMCFrame.Type.NATIVE && frame.getType() != IMCFrame.Type.CPP) continue;
                        String string = frame.getMethod().getMethodName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodName(...)");
                        list$iv = new String[]{"+0x"};
                        List parts = StringsKt.split$default((CharSequence)string, (String[])list$iv, (boolean)false, (int)0, (int)6, null);
                        if (parts.size() == 2) {
                            Object object;
                            void $this$getOrPut$iv;
                            Companion.UnresolvedNativeFrame unresolvedNativeFrame = new Companion.UnresolvedNativeFrame((String)parts.get(0), (String)parts.get(1));
                            Map bl = unresolved;
                            String key$iv = unresolvedNativeFrame.getDll();
                            boolean $i$f$getOrPut = false;
                            Object value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                boolean bl2 = false;
                                ArrayList answer$iv = new ArrayList();
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object = answer$iv;
                            } else {
                                object = value$iv;
                            }
                            ((ArrayList)object).add(TuplesKt.to((Object)frame, (Object)unresolvedNativeFrame));
                            continue;
                        }
                        ((Collection)resolved).add(frame);
                    }
                    return new GroupedNativeFrames(resolved, unresolved);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u000e0\rJ \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$NativeSymbolsResolver;", "", "<init>", "()V", "libDbghelpPath", "", "libJniSymbolsResolver", "doResolveNativeDll", "", "Lorg/openjdk/jmc/common/IMCFrame;", "dllDebugInfo", "Lcom/intellij/profiler/ultimate/jfr/DllDebugInfo;", "frames", "", "Lkotlin/Pair;", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion$UnresolvedNativeFrame;", "formatLogMessage", "targetDll", "message", "result", "Lcom/intellij/profiler/async/windows/WindowsSymbolsResolver$ResolveResult;", "intellij.profiler.ultimate"})
        @SourceDebugExtension(value={"SMAP\nJFRProfilerData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$NativeSymbolsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1563#2:200\n1634#2,3:201\n1193#2,2:204\n1267#2,4:206\n1267#2,4:210\n1193#2,2:214\n1267#2,4:216\n*S KotlinDebug\n*F\n+ 1 JFRProfilerData.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder$NativeSymbolsResolver\n*L\n136#1:200\n136#1:201,3\n146#1:204,2\n146#1:206,4\n148#1:210,4\n157#1:214,2\n157#1:216,4\n*E\n"})
        private static final class NativeSymbolsResolver {
            @NotNull
            private final String libDbghelpPath = AsyncProfilerExtractor.INSTANCE.getLibDbghelpPath();
            @NotNull
            private final String libJniSymbolsResolver = AsyncProfilerExtractor.INSTANCE.getLibJniSymbolsResolver();

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<IMCFrame, IMCFrame> doResolveNativeDll(@NotNull DllDebugInfo dllDebugInfo, @NotNull List<? extends Pair<? extends IMCFrame, Companion.UnresolvedNativeFrame>> frames) {
                Object destination$iv$iv;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)dllDebugInfo, (String)"dllDebugInfo");
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                Iterable $this$map$iv = frames;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add("0x" + ((Companion.UnresolvedNativeFrame)it.getSecond()).getOffset());
                }
                Collection collection = (List)destination$iv$iv2;
                ArrayList request = new ArrayList(collection);
                String targetDll = dllDebugInfo.getDllPath();
                try {
                    void destination$iv;
                    void $this$associateTo$iv;
                    WindowsSymbolsResolver.ResolveResult resolveResult = WindowsSymbolsResolver.getInstance((String)this.libJniSymbolsResolver).resolve(this.libDbghelpPath, JFRProfilerData.NT_LIBRARY_PATH, targetDll, request, dllDebugInfo.getSize(), dllDebugInfo.getDbgInfo());
                    Intrinsics.checkNotNull((Object)resolveResult);
                    WindowsSymbolsResolver.ResolveResult result = resolveResult;
                    if (LOG.isDebugEnabled() && result.resolveLog != null) {
                        LOG.debug("DbgHelp log: " + result.resolveLog);
                    }
                    if (result.errorMessage != null) {
                        void $this$associateTo$iv$iv;
                        LOG.debug(this.formatLogMessage(targetDll, "Finished with error: " + result.errorMessage, result));
                        Iterable $this$associate$iv = frames;
                        boolean $i$f$associate = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                        Iterable iterable2 = $this$associate$iv;
                        destination$iv$iv = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateTo = false;
                        for (Object element$iv$iv : $this$associateTo$iv$iv) {
                            Object object = destination$iv$iv;
                            Pair it = (Pair)element$iv$iv;
                            boolean bl = false;
                            it = TuplesKt.to((Object)it.getFirst(), (Object)it.getFirst());
                            object.put(it.getFirst(), it.getSecond());
                        }
                        return destination$iv$iv;
                    }
                    ArrayList arrayList = result.resolvedSymbols;
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"resolvedSymbols");
                    Iterable $i$f$associate = CollectionsKt.zip((Iterable)arrayList, (Iterable)frames);
                    Map capacity$iv = new HashMap();
                    boolean $i$f$associateTo = false;
                    for (Object element$iv : $this$associateTo$iv) {
                        Pair pair;
                        void bl = destination$iv;
                        Pair pair2 = (Pair)element$iv;
                        boolean bl2 = false;
                        String functionName = (String)pair2.component1();
                        Pair unresolvedFrame = (Pair)pair2.component2();
                        if (Intrinsics.areEqual((Object)functionName, (Object)targetDll)) {
                            pair = TuplesKt.to((Object)unresolvedFrame.getFirst(), (Object)unresolvedFrame.getFirst());
                        } else {
                            Object object = unresolvedFrame.getFirst();
                            Intrinsics.checkNotNull((Object)functionName);
                            pair = TuplesKt.to((Object)object, (Object)new Companion.ResolvedNativeIMCFrame(targetDll, functionName));
                        }
                        pair2 = pair;
                        bl.put(pair2.getFirst(), pair2.getSecond());
                    }
                    HashMap resolvedFrames = (HashMap)destination$iv;
                    LOG.debug(this.formatLogMessage(targetDll, "Successfully resolved " + resolvedFrames.size() + " frames", result));
                    return resolvedFrames;
                }
                catch (Exception e) {
                    void $this$associateTo$iv$iv;
                    LOG.error("Resolve for '" + targetDll + "'", (Throwable)e);
                    Iterable $this$associate$iv = frames;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    destination$iv$iv = $this$associate$iv;
                    Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv3;
                        Pair it = (Pair)element$iv$iv;
                        boolean bl = false;
                        Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getFirst());
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    return destination$iv$iv3;
                }
            }

            private final String formatLogMessage(String targetDll, String message, WindowsSymbolsResolver.ResolveResult result) {
                StringBuilder stringBuilder;
                StringBuilder $this$formatLogMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$formatLogMessage_u24lambda_u240.append("Resolve for '" + targetDll + "': " + message).append('\n');
                $this$formatLogMessage_u24lambda_u240.append("Native library log:");
                CharSequence charSequence = result.resolveLog;
                if (charSequence == null || charSequence.length() == 0) {
                    v0 = $this$formatLogMessage_u24lambda_u240.append(" <empty>").append('\n');
                } else {
                    charSequence = $this$formatLogMessage_u24lambda_u240;
                    String string = result.resolveLog;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolveLog");
                    String string2 = "\n" + ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
                    v0 = ((StringBuilder)charSequence).append(string2).append('\n');
                }
                return stringBuilder.toString();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "WINDOWS_SYMBOLS", "", "JBR_SYMBOLS", "NT_LIBRARY_PATH", "UnresolvedNativeFrame", "ResolvedNativeIMCFrame", "ResolvedNativeIMCMethod", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion$ResolvedNativeIMCFrame;", "Lorg/openjdk/jmc/common/IMCFrame;", "dll", "", "functionName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "method", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion$ResolvedNativeIMCMethod;", "getFrameLineNumber", "", "getBCI", "getMethod", "getType", "Lorg/openjdk/jmc/common/IMCFrame$Type;", "intellij.profiler.ultimate"})
        private static final class ResolvedNativeIMCFrame
        implements IMCFrame {
            @NotNull
            private final ResolvedNativeIMCMethod method;

            public ResolvedNativeIMCFrame(@NotNull String dll, @NotNull String functionName) {
                Intrinsics.checkNotNullParameter((Object)dll, (String)"dll");
                Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
                this.method = new ResolvedNativeIMCMethod(dll, functionName);
            }

            @Nullable
            public Void getFrameLineNumber() {
                return null;
            }

            @Nullable
            public Void getBCI() {
                return null;
            }

            @Override
            @NotNull
            public ResolvedNativeIMCMethod getMethod() {
                return this.method;
            }

            @Override
            @NotNull
            public IMCFrame.Type getType() {
                return IMCFrame.Type.NATIVE;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion$ResolvedNativeIMCMethod;", "Lorg/openjdk/jmc/common/IMCMethod;", "dll", "", "functionName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDll", "()Ljava/lang/String;", "getFunctionName", "getType", "", "getMethodName", "getFormalDescriptor", "getModifier", "isNative", "", "()Ljava/lang/Boolean;", "isHidden", "intellij.profiler.ultimate"})
        private static final class ResolvedNativeIMCMethod
        implements IMCMethod {
            @NotNull
            private final String dll;
            @NotNull
            private final String functionName;

            public ResolvedNativeIMCMethod(@NotNull String dll, @NotNull String functionName) {
                Intrinsics.checkNotNullParameter((Object)dll, (String)"dll");
                Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
                this.dll = dll;
                this.functionName = functionName;
            }

            @NotNull
            public final String getDll() {
                return this.dll;
            }

            @NotNull
            public final String getFunctionName() {
                return this.functionName;
            }

            @Nullable
            public Void getType() {
                return null;
            }

            @Override
            @NotNull
            public String getMethodName() {
                return this.functionName;
            }

            @Nullable
            public Void getFormalDescriptor() {
                return null;
            }

            @Nullable
            public Void getModifier() {
                return null;
            }

            @Override
            @NotNull
            public Boolean isNative() {
                return true;
            }

            @Override
            @NotNull
            public Boolean isHidden() {
                return false;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Companion$UnresolvedNativeFrame;", "", "dll", "", "offset", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDll", "()Ljava/lang/String;", "getOffset", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.profiler.ultimate"})
        private static final class UnresolvedNativeFrame {
            @NotNull
            private final String dll;
            @NotNull
            private final String offset;

            public UnresolvedNativeFrame(@NotNull String dll, @NotNull String offset) {
                Intrinsics.checkNotNullParameter((Object)dll, (String)"dll");
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                this.dll = dll;
                this.offset = offset;
            }

            @NotNull
            public final String getDll() {
                return this.dll;
            }

            @NotNull
            public final String getOffset() {
                return this.offset;
            }

            @NotNull
            public final String component1() {
                return this.dll;
            }

            @NotNull
            public final String component2() {
                return this.offset;
            }

            @NotNull
            public final UnresolvedNativeFrame copy(@NotNull String dll, @NotNull String offset) {
                Intrinsics.checkNotNullParameter((Object)dll, (String)"dll");
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                return new UnresolvedNativeFrame(dll, offset);
            }

            public static /* synthetic */ UnresolvedNativeFrame copy$default(UnresolvedNativeFrame unresolvedNativeFrame, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unresolvedNativeFrame.dll;
                }
                if ((n & 2) != 0) {
                    string2 = unresolvedNativeFrame.offset;
                }
                return unresolvedNativeFrame.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "UnresolvedNativeFrame(dll=" + this.dll + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                int result = this.dll.hashCode();
                result = result * 31 + this.offset.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnresolvedNativeFrame)) {
                    return false;
                }
                UnresolvedNativeFrame unresolvedNativeFrame = (UnresolvedNativeFrame)other;
                if (!Intrinsics.areEqual((Object)this.dll, (Object)unresolvedNativeFrame.dll)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.offset, (Object)unresolvedNativeFrame.offset);
            }
        }
    }
}

