/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jbonlymac.configurations;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.configurations.ProfilerAttacher;
import com.intellij.profiler.api.configurations.ProfilerStarter;
import com.intellij.profiler.dtrace.DTraceConfigurable;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationType;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.jbonlymac.JVMDTraceProfilerProcess;
import com.intellij.profiler.ultimate.jbonlymac.configurations.JVMDTraceProfilerConfigurationState;
import com.intellij.profiler.ultimate.jbonlymac.configurations.JVMDTraceProfilerConfigurationType;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/configurations/JVMDTraceProfilerConfigurationType;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationType;", "Lcom/intellij/profiler/ultimate/jbonlymac/configurations/JVMDTraceProfilerConfigurationState;", "<init>", "()V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "id", "getId", "isAvailable", "", "getTemplateState", "createConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "state", "createAttacher", "Lcom/intellij/profiler/api/configurations/ProfilerAttacher;", "createStarter", "Lcom/intellij/profiler/api/configurations/ProfilerStarter;", "Companion", "intellij.profiler.ultimate"})
public final class JVMDTraceProfilerConfigurationType
extends JavaProfilerConfigurationType<JVMDTraceProfilerConfigurationState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String displayName;
    @NotNull
    private final String id;
    @NotNull
    public static final String ID = "JVMDTraceProfilerConfiguration";

    public JVMDTraceProfilerConfigurationType() {
        this.displayName = "JVM DTrace based profiler";
        this.id = ID;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.Profile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Profile");
        return icon;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public boolean isAvailable() {
        return UtilsKt.dtraceProfilerAvailable();
    }

    @NotNull
    public JVMDTraceProfilerConfigurationState getTemplateState() {
        return JVMDTraceProfilerConfigurationState.Companion.create$default(JVMDTraceProfilerConfigurationState.Companion, this.getDisplayName(), null, null, 6, null);
    }

    @NotNull
    public UnnamedConfigurable createConfigurable(@NotNull JVMDTraceProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new UnnamedConfigurable(state){
            private final DTraceConfigurable delegate;
            {
                void p0;
                SimpleProfilerSettingsState simpleProfilerSettingsState = $state.getSettings();
                createConfigurable.1 var4_3 = this;
                boolean bl = false;
                var4_3.delegate = new DTraceConfigurable((SimpleProfilerSettingsState)p0);
            }

            public JComponent createComponent() {
                JBBox jBBox;
                DialogPanel main = this.delegate.createComponent();
                JBLabel onlyAttach = new JBLabel(UltimateProfilerBundleKt.profilerMessage("dtrace.configurable.settings.only.attach", new Object[0]), AllIcons.General.Information, 2);
                JBBox $this$createComponent_u24lambda_u240 = jBBox = JBBox.createVerticalBox();
                boolean bl = false;
                $this$createComponent_u24lambda_u240.add((Component)main);
                $this$createComponent_u24lambda_u240.add((Component)new TitledSeparator());
                $this$createComponent_u24lambda_u240.add((Component)onlyAttach);
                JBBox jBBox2 = jBBox;
                Intrinsics.checkNotNullExpressionValue((Object)jBBox2, (String)"apply(...)");
                return (JComponent)jBBox2;
            }

            public boolean isModified() {
                return this.delegate.isModified();
            }

            public void apply() {
                this.delegate.apply();
            }

            public void reset() {
                this.delegate.reset();
            }
        };
    }

    @NotNull
    public ProfilerAttacher createAttacher(@NotNull JVMDTraceProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new ProfilerAttacher(state){
            final /* synthetic */ JVMDTraceProfilerConfigurationState $state;
            {
                this.$state = $state;
            }

            public Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> attachTo(AttachableTargetProcess targetProcess, Project project) {
                Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (!(targetProcess instanceof JavaTargetProcess)) {
                    return Promises.rejectedPromise((String)"Internal error: Can't attach to this process");
                }
                return JVMDTraceProfilerProcess.Companion.attach((JavaTargetProcess)targetProcess, this.$state, 10000, project);
            }
        };
    }

    @Nullable
    public ProfilerStarter createStarter(@NotNull JVMDTraceProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/configurations/JVMDTraceProfilerConfigurationType$Companion;", "", "<init>", "()V", "ID", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

