/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.profiler.ultimate.hprof.utils.PagedByteBuffer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;

public interface IntList
extends AutoCloseable {
    public int limit();

    public int get(int var1);

    public void put(int var1, int var2);

    public void swap(int var1, int var2);

    @Override
    default public void close() {
    }

    public static class OffHeap
    implements IntList {
        @NotNull
        private final PagedByteBuffer myBuffer;

        public OffHeap(int size) {
            this.myBuffer = new PagedByteBuffer((long)size << 2, 4);
        }

        @Override
        public int limit() {
            return (int)(this.myBuffer.getSize() >> 2);
        }

        @Override
        public int get(int index) {
            return this.myBuffer.getInt((long)index << 2);
        }

        @Override
        public void put(int index, int value) {
            this.myBuffer.putInt((long)index << 2, value);
        }

        @Override
        public void swap(int i, int j) {
            int t = this.get(i);
            this.put(i, this.get(j));
            this.put(j, t);
        }

        @Override
        public void close() {
            this.myBuffer.close();
        }
    }

    public static class FileBuffer
    implements IntList {
        @NotNull
        private final PagedByteBuffer myBuffer;

        public FileBuffer(int size, @NotNull Path path, StandardOpenOption ... options) throws IOException {
            if (path == null) {
                FileBuffer.$$$reportNull$$$0(0);
            }
            this.myBuffer = new PagedByteBuffer((long)size << 2, 4, path, options);
        }

        @Override
        public int limit() {
            return (int)(this.myBuffer.getSize() >> 2);
        }

        @Override
        public int get(int index) {
            return this.myBuffer.getInt((long)index << 2);
        }

        @Override
        public void put(int index, int value) {
            this.myBuffer.putInt((long)index << 2, value);
        }

        @Override
        public void swap(int i, int j) {
            int t = this.get(i);
            this.put(i, this.get(j));
            this.put(j, t);
        }

        @Override
        public void close() {
            this.myBuffer.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/profiler/ultimate/hprof/utils/IntList$FileBuffer", "<init>"));
        }
    }

    public static class InMemory
    implements IntList {
        private final int @NotNull [] myArray;

        public InMemory(int capacity) {
            this.myArray = new int[capacity];
        }

        @Override
        public int limit() {
            return this.myArray.length;
        }

        @Override
        public int get(int index) {
            return this.myArray[index];
        }

        @Override
        public void put(int index, int value) {
            this.myArray[index] = value;
        }

        @Override
        public void swap(int i, int j) {
            int t = this.myArray[i];
            this.myArray[i] = this.myArray[j];
            this.myArray[j] = t;
        }
    }
}

