/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.dom;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.hprof.dom.Graph;
import com.intellij.profiler.ultimate.hprof.dom.Remap;
import com.intellij.profiler.ultimate.hprof.utils.IntList;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class DominatorTree<T> {
    private final Graph<T> myGraph;
    private final Remap<T> myRemap;
    @VisibleForTesting
    public boolean isShouldCleanSdom = true;
    private IntList mySdom;
    private IntList myVertex;
    private IntList myParent;
    private IntList myAncestors;
    private IntList myLabel;
    private IntList myBucket;
    private IntList myDom;
    private IntList myStack;
    private int n;

    public DominatorTree(Graph<T> graph2, Remap<T> remap) {
        this.myGraph = graph2;
        this.myRemap = remap;
    }

    public final void compute() {
        this.compute(null);
    }

    public final void compute(@Nullable ProgressIndicator indicator) {
        int size = this.myGraph.size();
        this.mySdom = this.alloc("sdom", size + 1, null);
        this.myVertex = this.alloc("vertex", size + 1, null);
        this.myParent = this.alloc("parent", size + 1, null);
        this.myAncestors = this.alloc("ancestors", size + 1, null);
        this.myLabel = this.alloc("label", size + 1, i -> i);
        this.myBucket = this.alloc("bucket", size + 1, i -> -1);
        this.myDom = this.alloc("dom", size + 1, i -> i);
        this.myStack = this.alloc("stack", size * 2, null);
        this.computeDfs(indicator);
        this.computeDominators(indicator);
        this.myBucket = null;
        this.myLabel = null;
        this.myAncestors = null;
        this.myParent = null;
        if (this.isShouldCleanSdom) {
            this.mySdom = null;
            this.myVertex = null;
        }
    }

    @TestOnly
    public String printResult() {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < this.n; ++i) {
            int v = this.myVertex.get(i);
            int w = this.myVertex.get(this.mySdom.get(v));
            T object = this.myRemap.toObject(v - 1);
            builder.append(object).append(" -> (").append(i).append(", ").append(this.myRemap.toObject(w - 1)).append("), ").append(this.getParent(object));
            if (i >= this.myVertex.limit() - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public T getParent(T node) {
        return this.myRemap.toObject(this.myDom.get(this.myRemap.toInt(node) + 1) - 1);
    }

    public void forEach(BiConsumer<? super Integer, ? super T> consumer) {
        for (int i = 1; i < this.myDom.limit(); ++i) {
            T parent = this.myRemap.toObject(this.myDom.get(i) - 1);
            consumer.accept((Integer)((Integer)Integer.valueOf(i - 1)), (Integer)parent);
        }
    }

    public void forEachRaw(RawConsumer consumer) {
        for (int i = 1; i < this.myDom.limit(); ++i) {
            consumer.accept(i - 1, this.myDom.get(i) - 1);
        }
    }

    @NotNull
    protected IntList alloc(@NotNull String name, int size, @Nullable IntUnaryOperator generator) {
        if (name == null) {
            DominatorTree.$$$reportNull$$$0(0);
        }
        IntList.InMemory buffer = new IntList.InMemory(size);
        if (generator != null) {
            for (int i = 0; i < buffer.limit(); ++i) {
                buffer.put(i, generator.applyAsInt(i));
            }
        }
        IntList.InMemory inMemory = buffer;
        if (inMemory == null) {
            DominatorTree.$$$reportNull$$$0(1);
        }
        return inMemory;
    }

    private void computeDfs(@Nullable ProgressIndicator indicator) {
        int stackSize = 0;
        this.myStack.put(stackSize++, this.myRemap.toInt(this.myGraph.root()));
        this.n = 1;
        while (stackSize != 0) {
            Iterator<T> children;
            int v;
            if (this.mySdom.get(v = this.myStack.get(--stackSize) + 1) != 0) continue;
            this.mySdom.put(v, this.n);
            this.myVertex.put(this.n, v);
            ++this.n;
            T node = this.myRemap.toObject(v - 1);
            Iterator<T> iterator2 = children = node == null ? null : this.myGraph.successors(node);
            if (children != null) {
                while (children.hasNext()) {
                    T child = children.next();
                    int w = this.myRemap.toInt(child) + 1;
                    if (this.mySdom.get(w) != 0) continue;
                    this.myParent.put(w, v);
                    this.myStack.put(stackSize++, this.myRemap.toInt(child));
                }
            }
            DominatorTree.updateProgressIndicator(indicator, this.n, this.mySdom.limit());
        }
    }

    private void computeDominators(@Nullable ProgressIndicator indicator) {
        int w;
        int i;
        for (i = this.n - 1; i >= 1; --i) {
            Iterator<T> predecessors;
            w = this.myVertex.get(i);
            T node = this.myRemap.toObject(w - 1);
            Iterator<T> iterator2 = predecessors = node == null ? null : this.myGraph.predecessors(node);
            if (predecessors != null) {
                while (predecessors.hasNext()) {
                    T ancestor = predecessors.next();
                    int u = this.eval(this.myRemap.toInt(ancestor) + 1);
                    if (this.mySdom.get(u) >= this.mySdom.get(w)) continue;
                    this.mySdom.put(w, this.mySdom.get(u));
                }
            }
            this.myBucket.put(w, this.myBucket.get(this.myVertex.get(this.mySdom.get(w))));
            this.myBucket.put(this.myVertex.get(this.mySdom.get(w)), w);
            int parent = this.myParent.get(w);
            this.link(parent, w);
            int v = this.myBucket.get(parent);
            while (v != -1) {
                int u = this.eval(v);
                if (this.mySdom.get(u) < this.mySdom.get(v)) {
                    this.myDom.put(v, u);
                } else {
                    this.myDom.put(v, parent);
                }
                v = this.myBucket.get(v);
            }
            this.myBucket.put(parent, -1);
            DominatorTree.updateProgressIndicator(indicator, this.n - i + this.n, this.n);
        }
        for (i = 1; i < this.n; ++i) {
            w = this.myVertex.get(i);
            if (this.myDom.get(w) != this.myVertex.get(this.mySdom.get(w))) {
                this.myDom.put(w, this.myDom.get(this.myDom.get(w)));
            }
            DominatorTree.updateProgressIndicator(indicator, i + this.n + this.n, this.n);
        }
    }

    private int eval(int v) {
        if (this.myAncestors.get(v) == 0) {
            return v;
        }
        this.compress(v);
        return this.myLabel.get(v);
    }

    private void compress(int v) {
        int stackSize = 0;
        while (this.myAncestors.get(this.myAncestors.get(v)) != 0) {
            this.myStack.put(stackSize++, v);
            v = this.myAncestors.get(v);
        }
        while (stackSize > 0) {
            if (this.mySdom.get(this.myLabel.get(this.myAncestors.get(v = this.myStack.get(--stackSize)))) < this.mySdom.get(this.myLabel.get(v))) {
                this.myLabel.put(v, this.myLabel.get(this.myAncestors.get(v)));
            }
            this.myAncestors.put(v, this.myAncestors.get(this.myAncestors.get(v)));
        }
    }

    private void link(int v, int w) {
        this.myAncestors.put(w, v);
    }

    private static void updateProgressIndicator(@Nullable ProgressIndicator indicator, int currentValue, int totalInstances) {
        if (indicator != null) {
            indicator.setFraction((double)currentValue / (double)totalInstances / 3.0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ultimate/hprof/dom/DominatorTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ultimate/hprof/dom/DominatorTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "alloc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "alloc";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface RawConsumer {
        public void accept(int var1, int var2);
    }
}

