/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.openapi.module.WebInspectionToolProvider;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class WebXmlValidator
extends InspectionValidator {
    public WebXmlValidator() {
        super("Web Xml Validator", WebBundle.message("web.xml.validator.description", new Object[0]), WebBundle.message("progress.validating.web.xml.text", new Object[0]));
    }

    public Class<? extends LocalInspectionTool> @NotNull [] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new WebInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            WebXmlValidator.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            WebXmlValidator.$$$reportNull$$$0(1);
        }
        return WebXmlValidator.containsWebFacets(scope);
    }

    private static boolean containsWebFacets(CompileScope scope) {
        for (Module module : scope.getAffectedModules()) {
            if (WebFacet.getInstances((Module)module).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collection webFacets = WebFacet.getInstances((Module)module);
            for (WebFacet webFacet : webFacets) {
                InspectionValidatorUtil.addDescriptor(list, (ConfigFile)webFacet.getWebXmlDescriptor());
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(list, (CompileContext)context);
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/highlighting/WebXmlValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/highlighting/WebXmlValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

