/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class StmtIf
extends Stmt {
    private final Expr cond;
    private Stmt trueStmt;
    private Stmt falseStmt;

    public StmtIf(Expr cond, Stmt stmt, Context context) {
        super(context, stmt);
        this.cond = cond;
        this.trueStmt = stmt;
    }

    public StmtIf(Expr cond, Stmt trueStmt, Stmt falseStmt, Context context) {
        this(cond, trueStmt, context);
        this.falseStmt = falseStmt;
        if (falseStmt != null) {
            this.setChildren(new QueryNode[]{trueStmt, falseStmt});
        }
    }

    @Override
    public void accept(StmtVisitor visitor2) {
        if (visitor2.visitIf(this)) {
            this.trueStmt.accept(visitor2);
            if (this.falseStmt != null) {
                this.falseStmt.accept(visitor2);
            }
        }
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.trueStmt = this.trueStmt.transform(transformer);
        if (this.falseStmt != null) {
            this.falseStmt = this.falseStmt.transform(transformer);
        }
        return transformer.transformIf(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        if (this.cond.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) != 0) {
            this.trueStmt.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        } else if (this.falseStmt != null) {
            this.falseStmt.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        }
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
    }

    @Override
    public String toLongString() {
        return "StmtIf{cond=" + this.cond.toLongString() + ", stmt=" + this.trueStmt.toLongString() + "}";
    }

    @Override
    public String toShortString() {
        return "If (" + this.cond.toShortString() + ") {" + this.trueStmt.toShortString() + "} " + (String)(this.falseStmt != null ? " Else {" + this.falseStmt.toShortString() + "}" : "");
    }
}

