/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.utils.ArrayHelper;
import com.intellij.rml.dfa.utils.Cancellation;

public class RelExprIf
extends RelExpr {
    private RelExpr ifRelExpr;
    private Expr ifExpr;
    private RelExpr thenBranch;
    private RelExpr elseBranch;

    public RelExprIf(RelExpr ifRelExpr, RelExpr thenBranch, RelExpr elseBranch, Context context) {
        super(context, ifRelExpr, thenBranch, elseBranch);
        this.ifRelExpr = ifRelExpr;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
    }

    public RelExprIf(Expr ifExpr, RelExpr thenBranch, RelExpr elseBranch, Context context) {
        super(context, thenBranch, elseBranch);
        this.ifExpr = ifExpr;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
    }

    public RelExpr getIfRelExpr() {
        return this.ifRelExpr;
    }

    public Expr getIfExpr() {
        return this.ifExpr;
    }

    public RelExpr getThenBranch() {
        return this.thenBranch;
    }

    public RelExpr getElseBranch() {
        return this.elseBranch;
    }

    @Override
    public void accept(RelExprVisitor visitor2) {
        if (visitor2.visitIfStart(this)) {
            if (this.ifRelExpr != null) {
                this.ifRelExpr.accept(visitor2);
            }
            this.thenBranch.accept(visitor2);
            this.elseBranch.accept(visitor2);
        }
        visitor2.visitIfEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        if (this.ifRelExpr != null) {
            this.ifRelExpr = this.ifRelExpr.transform(transformer);
        }
        this.thenBranch = this.thenBranch.transform(transformer);
        this.elseBranch = this.elseBranch.transform(transformer);
        return transformer.transformIf(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain[] domains = ArrayHelper.uniteArrays(this.thenBranch.getDomains(variablesManager, domainsPool), this.elseBranch.getDomains(variablesManager, domainsPool), Domain.class);
        if (this.ifRelExpr != null) {
            return ArrayHelper.uniteArrays(this.ifRelExpr.getDomains(variablesManager, domainsPool), domains, Domain.class);
        }
        return domains;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        IRelation result;
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        if (this.ifExpr != null) {
            int intResult = this.ifExpr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            result = intResult != 0 ? this.thenBranch.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2) : this.elseBranch.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        } else {
            IRelation ifResult = this.ifRelExpr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
            IRelation ifNotResult = ifResult.complement(cancellation);
            IRelation thenBranchResult = this.thenBranch.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
            IRelation elseBranchResult = this.elseBranch.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
            IRelation thenResult = ifResult.unsafeIntersect(thenBranchResult, cancellation);
            IRelation elseResult = ifNotResult.unsafeIntersect(elseBranchResult, cancellation);
            result = thenResult.unsafeUnite(elseResult, cancellation);
            ifResult.kill();
            ifNotResult.kill();
            thenBranchResult.kill();
            elseBranchResult.kill();
            thenResult.kill();
            elseResult.kill();
        }
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprIf{ifRelExpr=" + (this.ifRelExpr != null ? this.ifRelExpr.toLongString() : "null") + ", ifExpr=" + (this.ifExpr != null ? this.ifExpr.toLongString() : "null") + ", thenBranch=" + this.thenBranch.toLongString() + ", elseBranch=" + this.elseBranch.toLongString() + "}";
    }

    @Override
    public String toShortString() {
        return "If (" + (this.ifRelExpr != null ? this.ifRelExpr.toShortString() : "") + (this.ifExpr != null ? this.ifExpr.toShortString() : "") + ") {" + this.thenBranch.toShortString() + "}Else {" + this.elseBranch.toShortString() + "}";
    }
}

