/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.ImplicitJoinInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlConvertNaturalJoinToOnIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertNaturalJoinToOnIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertNaturalJoinToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertNaturalJoinToOnIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1878#2,3:54\n*S KotlinDebug\n*F\n+ 1 SqlConvertNaturalJoinToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertNaturalJoinToOnIntention\n*L\n33#1:54,3\n*E\n"})
public final class SqlConvertNaturalJoinToOnIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.natural.join.with.on.clause", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return JoinUtilsKt.getNaturalJoinInfoByKeyword$default((PsiElement)element, (boolean)false, (int)2, null) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ImplicitJoinInfo implicitJoinInfo = JoinUtilsKt.getNaturalJoinInfoByKeyword$default((PsiElement)element, (boolean)false, (int)2, null);
        if (implicitJoinInfo == null) {
            return;
        }
        ImplicitJoinInfo info = implicitJoinInfo;
        PsiElement psiElement = element.getParent();
        SqlJoinExpression sqlJoinExpression = psiElement instanceof SqlJoinExpression ? (SqlJoinExpression)psiElement : null;
        if (sqlJoinExpression == null) {
            return;
        }
        SqlJoinExpression joinExpression = sqlJoinExpression;
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)joinExpression));
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, (SqlLanguageDialect)dialect).withDialect(dialect.getDatabaseDialect());
        builder.plain("select * from foo join bar ").keyword("on ");
        if (!((Collection)info.getColumns()).isEmpty()) {
            $this$forEachIndexed$iv = info.getColumns();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void column;
                Object object;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DasColumn dasColumn = (DasColumn)item$iv;
                int i = n;
                boolean bl = false;
                if (i > 0) {
                    builder.keyword(" and ");
                }
                if ((object = info.getLeftTableRef().getIdentifier()) == null || (object = object.getText()) == null) {
                    object = "?";
                }
                builder.plain((String)object + ".");
                builder.identifier((DasObject)column);
                builder.symbol(" = ");
                Object object2 = info.getRightTableRef().getIdentifier();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    object2 = "?";
                }
                builder.plain((String)object2 + ".");
                builder.identifier((DasObject)column);
            }
        } else {
            $this$forEachIndexed$iv = builder.keyword("true");
            Intrinsics.checkNotNull((Object)$this$forEachIndexed$iv);
        }
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText((String)builder.getStatement(), (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement2 = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlJoinConditionClause.class);
        Intrinsics.checkNotNull((Object)psiElement2);
        SqlJoinConditionClause onClause = (SqlJoinConditionClause)psiElement2;
        joinExpression.add((PsiElement)onClause);
        element.delete();
    }
}

