/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.JoinConditionInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlConvertJoinOnToUsingIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "intellij.database.sql.impl"})
public final class SqlConvertJoinOnToUsingIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.on.with.using", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!SqlPsiUtilKt.getSqlDialect((PsiElement)element).supportsJoinUsing()) {
            return false;
        }
        JoinConditionInfo info = JoinUtilsKt.getJoinOnInfo((PsiElement)element);
        return info != null && !((Collection)info.getColumnRefs()).isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JoinConditionInfo joinConditionInfo = JoinUtilsKt.getJoinOnInfo((PsiElement)element);
        if (joinConditionInfo == null) {
            return;
        }
        JoinConditionInfo info = joinConditionInfo;
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)info.getClause()));
        String joinOp = dialect.getDbms().isClickHouse() ? "all inner join" : "join";
        String string = new DdlBuilder().configureBuilder(project, (SqlLanguageDialect)dialect).withDialect(dialect.getDatabaseDialect()).plain("select * from foo " + joinOp + " bar ").keyword("using ").symbol("(").plain(CollectionsKt.joinToString$default((Iterable)info.getColumnRefs(), null, null, null, (int)0, null, SqlConvertJoinOnToUsingIntention::invoke$lambda$0, (int)31, null)).symbol(")").getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String queryText = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText((String)queryText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlUsingClause.class);
        Intrinsics.checkNotNull((Object)psiElement);
        SqlUsingClause usingClause = (SqlUsingClause)psiElement;
        ((SqlJoinConditionClause)info.getClause()).replace((PsiElement)usingClause);
    }

    private static final CharSequence invoke$lambda$0(SqlReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getIdentifier();
        return object != null && (object = object.getText()) != null ? (CharSequence)object : (CharSequence)"?";
    }
}

