/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.RenamePsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "AddAsFix", "AddCommaFix", "intellij.database.sql.impl"})
public final class SqlShadowingAliasInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(dialect, manager, result, onTheFly){
            private final Casing casing;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
                Casing casing = $dialect.getCasing(ObjectKind.COLUMN, null);
                Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
                this.casing = casing;
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (o instanceof SqlWithQueryExpression) {
                    super.visitSqlQueryExpression(o);
                }
                SqlSelectClause sqlSelectClause = o.getSelectClause();
                if (sqlSelectClause == null) {
                    return;
                }
                SqlSelectClause selectClause = sqlSelectClause;
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getDasType()) == null) {
                    return;
                }
                SqlTableExpression originalType = sqlTableExpression;
                HashSet<E> columnNames = new HashSet<E>();
                for (int i = 0; i < originalType.getColumnCount(); ++i) {
                    ((Collection)columnNames).add(SqlImplUtil.getEffectiveName((String)originalType.getColumnName(i), (boolean)originalType.isColumnQuoted(i), (Casing)this.casing));
                }
                for (SqlExpression expression : selectClause.getExpressions()) {
                    String effectiveName;
                    SqlIdentifier nameElement;
                    if (!(expression instanceof SqlAsExpression) || !(((SqlAsExpression)expression).getExpression() instanceof SqlReferenceExpression) || ((SqlAsExpression)expression).getNameElement() == null || !(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)((PsiElement)nameElement)) instanceof SqlExpression)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)SqlImplUtil.getEffectiveName((String)nameElement.getName(), (boolean)nameElement.isQuotedIdentifier(), (Casing)this.casing), (String)"getEffectiveName(...)");
                    if (!columnNames.contains(effectiveName)) continue;
                    this.reportProblem(nameElement);
                }
            }

            private final void reportProblem(SqlIdentifier anchor) {
                Object[] objectArray = new Object[]{anchor.getName()};
                String string = SqlBundle.message((String)"inspection.message.shadowing.alias", (Object[])objectArray);
                objectArray = new LocalQuickFix[]{AddCommaFix.INSTANCE, AddAsFix.INSTANCE, RenamePsiFix.INSTANCE};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)anchor, (PsiElement)anchor, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, (LocalQuickFix[])objectArray));
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection$AddAsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.sql.impl"})
    private static final class AddAsFix
    implements LocalQuickFix,
    DumbAware {
        @NotNull
        public static final AddAsFix INSTANCE = new AddAsFix();

        private AddAsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.name.add.as", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getStartElement();
            SqlIdentifier sqlIdentifier = psiElement instanceof SqlIdentifier ? (SqlIdentifier)psiElement : null;
            if (sqlIdentifier == null) {
                return;
            }
            SqlIdentifier id = sqlIdentifier;
            PsiElement psiElement2 = id.getParent();
            SqlAsExpression sqlAsExpression = psiElement2 instanceof SqlAsExpression ? (SqlAsExpression)psiElement2 : null;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression alias = sqlAsExpression;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)id));
            String string = new DdlBuilder().applyCodeStyle(project, (SqlLanguageDialect)dialect).withDialect(dialect.getDatabaseDialect()).keyword("as").getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
            String keywordText = string;
            PsiFile psiFile = alias.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            IntentionUtilsKt.modifyDocument((PsiFile)psiFile, arg_0 -> AddAsFix.applyFix$lambda$0(id, keywordText, arg_0));
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)alias);
        }

        private static final Unit applyFix$lambda$0(SqlIdentifier $id, String $keywordText, Document $this$modifyDocument) {
            Intrinsics.checkNotNullParameter((Object)$this$modifyDocument, (String)"$this$modifyDocument");
            $this$modifyDocument.insertString(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)$id)), (CharSequence)($keywordText + " "));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection$AddCommaFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.sql.impl"})
    private static final class AddCommaFix
    implements LocalQuickFix,
    HighPriorityAction,
    DumbAware {
        @NotNull
        public static final AddCommaFix INSTANCE = new AddCommaFix();

        private AddCommaFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.name.add.comma", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getStartElement();
            SqlIdentifier sqlIdentifier = psiElement instanceof SqlIdentifier ? (SqlIdentifier)psiElement : null;
            if (sqlIdentifier == null) {
                return;
            }
            SqlIdentifier id = sqlIdentifier;
            PsiElement psiElement2 = id.getParent();
            SqlAsExpression sqlAsExpression = psiElement2 instanceof SqlAsExpression ? (SqlAsExpression)psiElement2 : null;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression alias = sqlAsExpression;
            PsiElement parent = alias.getParent();
            SqlExpression sqlExpression = alias.getExpression();
            if (sqlExpression == null) {
                return;
            }
            SqlExpression expression = sqlExpression;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)id));
            PsiElement psiElement3 = SqlPsiElementFactory.createLeafFromText((Project)parent.getProject(), (SqlLanguageDialect)((SqlLanguageDialect)dialect), (String)",");
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"createLeafFromText(...)");
            PsiElement comma = psiElement3;
            SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText((String)id.getText(), (SqlLanguageDialect)((SqlLanguageDialect)dialect), (SqlReferenceElementType)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (PsiElement)parent);
            if (sqlReferenceExpression == null) {
                return;
            }
            SqlReferenceExpression newRef = sqlReferenceExpression;
            PsiElement commaInPlace = parent.addAfter(comma, (PsiElement)alias);
            PsiElement refInPlace = parent.addAfter((PsiElement)newRef, commaInPlace);
            alias.replace((PsiElement)expression);
            CodeStyleManager.getInstance((Project)project).reformat(refInPlace);
        }
    }
}

