/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.console.DbQueryValidator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlQueryValidatorInspectionBase
extends SqlInspectionBase
implements DbQueryValidator {
    @Nullable
    protected final SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        if (dialect == null) {
            SqlQueryValidatorInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlQueryValidatorInspectionBase.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlQueryValidatorInspectionBase.$$$reportNull$$$0(2);
        }
        return this.createVisitor(dialect, manager, result, onTheFly, false);
    }

    @Nullable
    protected abstract Visitor createVisitor(@NotNull SqlLanguageDialectEx var1, @NotNull InspectionManager var2, @NotNull List<ProblemDescriptor> var3, boolean var4, boolean var5);

    public Collection<String> getValidationErrors(SqlFile file) {
        ArrayList<ProblemDescriptor> messages = new ArrayList<ProblemDescriptor>();
        Visitor visitor = this.createVisitor((SqlLanguageDialectEx)file.getSqlLanguage(), InspectionManager.getInstance((Project)file.getProject()), messages, false, true);
        if (visitor == null) {
            return ContainerUtil.emptyList();
        }
        file.accept((PsiElementVisitor)this.createRecursiveVisitor(visitor));
        return visitor.getErrors();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlQueryValidatorInspectionBase";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Visitor
    extends SqlInspectionBase.SqlAnnotationVisitor {
        private final boolean myOnTheFly;
        private final boolean myIsQueryValidationPass;
        private final List<String> myErrors;

        Visitor(@NotNull InspectionManager manager, SqlLanguageDialect dialect, Collection<ProblemDescriptor> results, boolean onTheFly, boolean isQueryValidationPass) {
            if (manager == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(manager, dialect, results);
            this.myErrors = new ArrayList<String>();
            this.myOnTheFly = onTheFly;
            this.myIsQueryValidationPass = isQueryValidationPass;
        }

        public boolean isQueryValidationPass() {
            return this.myIsQueryValidationPass;
        }

        protected void addDescriptor(ProblemDescriptor problemDescriptor) {
            if (this.myIsQueryValidationPass) {
                throw new UnsupportedOperationException("Use reportIssue instead");
            }
            super.addDescriptor(problemDescriptor);
        }

        protected void reportIssue(PsiElement element, @NotNull ProblemHighlightType highlightType, @InspectionMessage String error) {
            if (highlightType == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (this.myIsQueryValidationPass) {
                this.myErrors.add(error);
            } else {
                super.addDescriptor(this.myManager.createProblemDescriptor(element, error, true, highlightType, this.myOnTheFly, new LocalQuickFix[0]));
            }
        }

        protected void reportIssue(PsiElement element, @InspectionMessage String error) {
            this.reportIssue(element, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, error);
        }

        private List<String> getErrors() {
            return this.myErrors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/inspections/SqlQueryValidatorInspectionBase$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportIssue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

