/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cockroach;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.cockroach.CRoachDdlParsing;
import com.intellij.sql.dialects.cockroach.CRoachDialect;
import com.intellij.sql.dialects.cockroach.CRoachDmlParsing;
import com.intellij.sql.dialects.cockroach.CRoachElementTypes;
import com.intellij.sql.dialects.cockroach.CRoachExpressionParsing;
import com.intellij.sql.dialects.cockroach.CRoachGeneratedParser;
import com.intellij.sql.dialects.cockroach.CRoachOtherParsing;
import com.intellij.sql.dialects.postgres.PgParserBase;
import com.intellij.sql.psi.SqlReferenceElementType;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class CRoachParser
extends PgParserBase {
    public CRoachParser(boolean pl) {
        super((SqlLanguageDialectEx)CRoachDialect.INSTANCE, pl);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return CRoachGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = CRoachExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, CRoachExpressionParsing::evaluable_expression);
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (super.parseSqlStatement(builder, level)) {
            return true;
        }
        return CRoachGeneratedParser.statement(builder, level);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return CRoachGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return CRoachDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? CRoachOtherParsing.type_element_ext(builder, level) : CRoachDdlParsing.type_element(builder, level);
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, CRoachExpressionParsing::parenthesized_values_expr, CRoachDmlParsing::top_query_expression, CRoachParser::parseTopQueryExpressionTail, CRoachExpressionParsing::row_element_list, (b, l) -> CRoachExpressionParsing.root_expr_0(b, l, -1) && CRoachExpressionParsing.row_element_list_separator(b, l) && CRoachExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, CRoachDmlParsing::parenthesized_aliased_join_expression, CRoachDmlParsing::top_query_expression, CRoachParser::parseTopQueryExpressionTail, (b, l) -> CRoachDmlParsing.join_expression(b, l, -1), (b, l) -> CRoachDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (CRoachGeneratedParser.within_group_clause(builder, level) | CRoachGeneratedParser.analytic_clause(builder, level)) {
            IElementType type;
            LighterASTNode ref = SqlGeneratedParserUtil.getExposedFunctionRef((PsiBuilder)builder);
            IElementType iElementType = type = ref == null ? null : ref.getTokenType();
            if (type == SQL_REFERENCE || type == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, BuiltinFunction definition) {
        CRoachDmlParsing.order_by_clause(builder, level);
        return true;
    }

    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result = super.parseTypedReference(builder, refType);
        if (!result && SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done((IElementType)SQL_STRING_LITERAL);
            result = true;
        }
        if (result && (SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)CROACH_OP_TYPE_CAST) || SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)PG_OP_TYPE_CAST))) {
            PsiBuilder.Marker marker = Objects.requireNonNull((PsiBuilder.Marker)builder.getLatestDoneMarker());
            CRoachOtherParsing.type_element_ext_inner(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result;
    }

    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean variadic = SqlParserUtil.consumeToken((PsiBuilder)builder, (boolean)true, null);
        return super.parseFunctionArgument(builder, level, optional && !variadic, allowBoolean);
    }

    @Nullable
    public IElementType getLazyCodeBlockType() {
        return CRoachElementTypes.Misc.CROACH_LAZY_CODE_BLOCK;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        CRoachDmlParsing.query_expression_0(builder, level, -1);
        return CRoachDmlParsing.left_inner_table_op_tail(builder, level);
    }

    public boolean parseAtSymbolNext(PsiBuilder builder, SqlReferenceElementType refType, int endOffset) {
        if (refType == SQL_TABLE_REFERENCE) {
            return false;
        }
        return super.parseAtSymbolNext(builder, refType, endOffset);
    }
}

