/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.inspections.fixes.CssAddPrefixQuickFix;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.postcss.PostCssBundle;
import org.intellij.plugins.postcss.inspections.PostCssBaseInspection;
import org.intellij.plugins.postcss.psi.PostCssCustomSelectorAtRule;
import org.intellij.plugins.postcss.psi.PostCssPsiUtil;
import org.intellij.plugins.postcss.psi.impl.PostCssCustomSelectorAtRuleImpl;
import org.intellij.plugins.postcss.psi.impl.PostCssCustomSelectorImpl;
import org.intellij.plugins.postcss.psi.impl.PostCssElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PostCssCustomSelectorInspection
extends PostCssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PostCssCustomSelectorInspection.$$$reportNull$$$0(0);
        }
        return new PostCssElementVisitor(this){

            @Override
            public void visitPostCssCustomSelector(PostCssCustomSelectorImpl postCssCustomSelector) {
                if (!PostCssPsiUtil.isInsidePostCss((PsiElement)postCssCustomSelector)) {
                    return;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)postCssCustomSelector.getParent())) {
                    return;
                }
                String text = postCssCustomSelector.getText();
                if (StringUtil.isEmpty((String)text)) {
                    String description = PostCssBundle.message("annotator.custom.selector.name.expected", new Object[0]);
                    TextRange textRange = TextRange.from((int)postCssCustomSelector.getStartOffsetInParent(), (int)1);
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor(postCssCustomSelector.getParent(), textRange, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]);
                    holder.registerProblem(problemDescriptor);
                } else if (text.equals(":--")) {
                    holder.registerProblem((PsiElement)postCssCustomSelector, PostCssBundle.message("annotator.custom.selector.name.should.not.be.empty", new Object[0]), new LocalQuickFix[0]);
                } else if (!StringUtil.startsWith((CharSequence)text, (CharSequence)":--")) {
                    CssAddPrefixQuickFix quickFix = new CssAddPrefixQuickFix(":--", PostCssCustomSelectorAtRule.class, PostCssBundle.message("annotator.add.prefix.to.custom.selector.quickfix.name", new Object[0]));
                    String description = PostCssBundle.message("annotator.custom.selector.name.should.start.with", new Object[0]);
                    TextRange textRange = TextRange.from((int)postCssCustomSelector.getStartOffsetInParent(), (int)postCssCustomSelector.getTextLength());
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor(postCssCustomSelector.getParent(), textRange, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{quickFix});
                    holder.registerProblem(problemDescriptor);
                }
            }

            @Override
            public void visitPostCssCustomSelectorAtRule(PostCssCustomSelectorAtRuleImpl postCssCustomSelectorAtRule) {
                if (PsiTreeUtil.hasErrorElements((PsiElement)postCssCustomSelectorAtRule)) {
                    return;
                }
                CssSelectorList selectorList = postCssCustomSelectorAtRule.getSelectorList();
                if (selectorList == null) {
                    return;
                }
                if (selectorList.getText().isEmpty()) {
                    String description = PostCssBundle.message("annotator.custom.selector.at.rule.should.contain.selector.list", new Object[0]);
                    TextRange textRange = TextRange.from((int)selectorList.getStartOffsetInParent(), (int)1);
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor((PsiElement)postCssCustomSelectorAtRule, textRange, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]);
                    holder.registerProblem(problemDescriptor);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/postcss/inspections/PostCssCustomSelectorInspection", "buildVisitor"));
    }
}

