/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.ext;

import com.intellij.flyway.ext.MigrationVersion;
import com.intellij.flyway.ext.ResourceName;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public final class ResourceNameParser {
    @Nullable
    public static ResourceName parse(Project project, String resourceName) {
        String flywayMigrationSeparator;
        String extension = FileUtilRt.getExtension((String)resourceName);
        if (StringUtil.isEmpty((String)extension)) {
            return null;
        }
        DatabaseMigrationState dbMigrationState = DatabaseMigrationConfig.getInstance((Project)project).getState();
        String sqlMigrationPrefix = dbMigrationState.getFlywayMigrationPrefixNN();
        if (!resourceName.startsWith(sqlMigrationPrefix)) {
            return null;
        }
        String nameWithoutPrefix = resourceName.substring(sqlMigrationPrefix.length());
        Pair<String, String> splitName = ResourceNameParser.splitAtSeparator(nameWithoutPrefix, flywayMigrationSeparator = dbMigrationState.getFlywayMigrationSeparatorNN());
        if (StringUtil.isEmpty((String)((String)splitName.getFirst())) || StringUtil.isEmpty((String)((String)splitName.getSecond()))) {
            return null;
        }
        try {
            MigrationVersion.fromVersion((String)splitName.getFirst());
        }
        catch (Exception e) {
            return null;
        }
        String description = FileUtilRt.getNameWithoutExtension((String)((String)splitName.getSecond()).replace("_", " "));
        return new ResourceName(sqlMigrationPrefix, (String)splitName.getFirst(), flywayMigrationSeparator, description, extension, resourceName);
    }

    private static Pair<String, String> splitAtSeparator(String name, String separator) {
        int separatorIndex = name.indexOf(separator);
        if (separatorIndex >= 0) {
            return Pair.create((Object)name.substring(0, separatorIndex), (Object)name.substring(separatorIndex + separator.length()));
        }
        return Pair.create((Object)name, (Object)"");
    }
}

