/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.quarkus.qute.lang.QuteFileViewProviderKt;
import com.intellij.quarkus.qute.lang.QuteLanguage;
import com.intellij.quarkus.qute.lang.psi.tree.QuteElementTypes;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0006H\u0014J\b\u0010\u0018\u001a\u00020\fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/quarkus/qute/lang/QuteFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "psiManager", "Lcom/intellij/psi/PsiManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "myTemplatingLanguage", "Lcom/intellij/lang/Language;", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "getContentElementType", "Lcom/intellij/psi/tree/IElementType;", "language", "getBaseLanguage", "getLanguages", "", "cloneInner", "fileCopy", "getTemplateDataLanguage", "intellij.quarkus"})
public final class QuteFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Language myTemplatingLanguage;

    public QuteFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        super(psiManager, virtualFile, eventSystemEnabled);
        this.myTemplatingLanguage = QuteFileViewProviderKt.computeTemplateLanguage(virtualFile);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        if (lang != this.getTemplateDataLanguage()) {
            return super.createFile(lang);
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        PsiFile psiFile = parserDefinition2.createFile((FileViewProvider)this);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFile(...)");
        PsiFile psiFile2 = psiFile;
        if (psiFile2 instanceof PsiFileImpl) {
            ((PsiFileImpl)psiFile2).setContentElementType(QuteElementTypes.QUTE_TEMPLATE_DATA);
        }
        return psiFile2;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language == this.getTemplateDataLanguage() ? QuteElementTypes.QUTE_TEMPLATE_DATA : null;
    }

    @NotNull
    public Language getBaseLanguage() {
        return QuteLanguage.INSTANCE;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Object[] objectArray = new Language[]{this.getBaseLanguage(), this.getTemplateDataLanguage()};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new QuteFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        return this.myTemplatingLanguage;
    }
}

