/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MicroservicesConfigUtils;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.hints.QsHintReferencesProvider;
import com.intellij.quarkus.config.properties.QsPropertiesUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesValueReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "canHaveMultipleValues", "", "propertyKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "key", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "isUsingIndexedAccess", "intellij.quarkus"})
public final class QsPropertiesValueReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PropertyImpl propertyImpl = (PropertyImpl)PsiTreeUtil.getParentOfType((PsiElement)element, PropertyImpl.class);
        if (propertyImpl == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PropertyImpl property = propertyImpl;
        PropertyKeyImpl propertyKeyImpl = QsPropertiesUtils.INSTANCE.getPropertyKey$intellij_quarkus(property);
        if (propertyKeyImpl == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PropertyKeyImpl propertyKey = propertyKeyImpl;
        Object[] placeholderReferences = QsConfigUtils.INSTANCE.createPlaceholderReferences(element);
        MetaConfigKey metaConfigKey = QsPropertiesUtils.INSTANCE.getLastResolvedMetaConfigKey$intellij_quarkus((PsiElement)propertyKey);
        if (metaConfigKey == null) {
            return placeholderReferences;
        }
        MetaConfigKey key = metaConfigKey;
        if (this.canHaveMultipleValues(propertyKey, key)) {
            List list2 = MicroservicesConfigUtils.getListValueRanges((PsiElement)element);
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            list = CollectionsKt.listOf((Object)ElementManipulators.getValueTextRange((PsiElement)element));
        }
        List valueTextRanges = list;
        Object[] providerReferences = QsHintReferencesProvider.Companion.getInstance().getValueReferences(key, (PsiElement)propertyKey, element, valueTextRanges, context);
        Object[] objectArray = ArrayUtil.mergeArrays((Object[])providerReferences, (Object[])placeholderReferences);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"mergeArrays(...)");
        return (PsiReference[])objectArray;
    }

    private final boolean canHaveMultipleValues(PropertyKeyImpl propertyKey, MetaConfigKey key) {
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
        if (key.isAccessType(accessTypeArray)) {
            return false;
        }
        accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED};
        if (key.isAccessType(accessTypeArray)) {
            return !this.isUsingIndexedAccess(propertyKey);
        }
        if (this.isUsingIndexedAccess(propertyKey)) {
            return false;
        }
        PsiType psiType = key.getEffectiveValueType();
        if (psiType == null) {
            return false;
        }
        PsiType mapValueType = psiType;
        MetaConfigKey.AccessType mapValueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)mapValueType);
        return mapValueAccessType == MetaConfigKey.AccessType.INDEXED;
    }

    private final boolean isUsingIndexedAccess(PropertyKeyImpl propertyKey) {
        return propertyKey.textContains('[');
    }
}

